/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.StoredUndoableBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.Utils;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.DatabaseFullPrunedBlockStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresFullPrunedBlockStore
extends DatabaseFullPrunedBlockStore {
    private static final Logger log = LoggerFactory.getLogger(PostgresFullPrunedBlockStore.class);
    private static final String POSTGRES_DUPLICATE_KEY_ERROR_CODE = "23505";
    private static final String DATABASE_DRIVER_CLASS = "org.postgresql.Driver";
    private static final String DATABASE_CONNECTION_URL_PREFIX = "jdbc:postgresql://";
    private static final String CREATE_SETTINGS_TABLE = "CREATE TABLE settings (\n    name character varying(32) NOT NULL,\n    value bytea,\n    CONSTRAINT setting_pk PRIMARY KEY (name)\n)\n";
    private static final String CREATE_HEADERS_TABLE = "CREATE TABLE headers (\n    hash bytea NOT NULL,\n    chainwork bytea NOT NULL,\n    height integer NOT NULL,\n    header bytea NOT NULL,\n    wasundoable boolean NOT NULL,\n    CONSTRAINT headers_pk PRIMARY KEY (hash)\n)\n";
    private static final String CREATE_UNDOABLE_TABLE = "CREATE TABLE undoableblocks (\n    hash bytea NOT NULL,\n    height integer NOT NULL,\n    txoutchanges bytea,\n    transactions bytea,\n    CONSTRAINT undoableblocks_pk PRIMARY KEY (hash)\n)\n";
    private static final String CREATE_OPEN_OUTPUT_TABLE = "CREATE TABLE openoutputs (\n    hash bytea NOT NULL,\n    index integer NOT NULL,\n    height integer NOT NULL,\n    value bigint NOT NULL,\n    scriptbytes bytea NOT NULL,\n    toaddress character varying(35),\n    addresstargetable smallint,\n    coinbase boolean,\n    CONSTRAINT openoutputs_pk PRIMARY KEY (hash,index)\n)\n";
    private static final String CREATE_OUTPUTS_ADDRESS_MULTI_INDEX = "CREATE INDEX openoutputs_hash_index_num_height_toaddress_idx ON openoutputs USING btree (hash, index, height, toaddress)";
    private static final String CREATE_OUTPUTS_TOADDRESS_INDEX = "CREATE INDEX openoutputs_toaddress_idx ON openoutputs USING btree (toaddress)";
    private static final String CREATE_OUTPUTS_ADDRESSTARGETABLE_INDEX = "CREATE INDEX openoutputs_addresstargetable_idx ON openoutputs USING btree (addresstargetable)";
    private static final String CREATE_OUTPUTS_HASH_INDEX = "CREATE INDEX openoutputs_hash_idx ON openoutputs USING btree (hash)";
    private static final String CREATE_UNDOABLE_TABLE_INDEX = "CREATE INDEX undoableblocks_height_idx ON undoableBlocks USING btree (height)";
    private static final String SELECT_UNDOABLEBLOCKS_EXISTS_SQL = "select 1 from undoableBlocks where hash = ?";

    public PostgresFullPrunedBlockStore(NetworkParameters params, int fullStoreDepth, String hostname, String dbName, String username, String password) throws BlockStoreException {
        super(params, DATABASE_CONNECTION_URL_PREFIX + hostname + "/" + dbName, fullStoreDepth, username, password, null);
    }

    public PostgresFullPrunedBlockStore(NetworkParameters params, int fullStoreDepth, String hostname, String dbName, String username, String password, @Nullable String schemaName) throws BlockStoreException {
        super(params, DATABASE_CONNECTION_URL_PREFIX + hostname + "/" + dbName, fullStoreDepth, username, password, schemaName);
    }

    @Override
    protected String getDuplicateKeyErrorCode() {
        return POSTGRES_DUPLICATE_KEY_ERROR_CODE;
    }

    @Override
    protected List<String> getCreateTablesSQL() {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        sqlStatements.add(CREATE_SETTINGS_TABLE);
        sqlStatements.add(CREATE_HEADERS_TABLE);
        sqlStatements.add(CREATE_UNDOABLE_TABLE);
        sqlStatements.add(CREATE_OPEN_OUTPUT_TABLE);
        return sqlStatements;
    }

    @Override
    protected List<String> getCreateIndexesSQL() {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        sqlStatements.add(CREATE_UNDOABLE_TABLE_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_ADDRESS_MULTI_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_ADDRESSTARGETABLE_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_HASH_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_TOADDRESS_INDEX);
        return sqlStatements;
    }

    @Override
    protected List<String> getCreateSchemeSQL() {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        sqlStatements.add("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
        sqlStatements.add("set search_path to '" + this.schemaName + "'");
        return sqlStatements;
    }

    @Override
    protected String getDatabaseDriverClass() {
        return DATABASE_DRIVER_CLASS;
    }

    @Override
    public void put(StoredBlock storedBlock, StoredUndoableBlock undoableBlock) throws BlockStoreException {
        block17: {
            this.maybeConnect();
            byte[] hashBytes = new byte[28];
            System.arraycopy(storedBlock.getHeader().getHash().getBytes(), 4, hashBytes, 0, 28);
            int height = storedBlock.getHeight();
            byte[] transactions = null;
            byte[] txOutChanges = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                if (undoableBlock.getTxOutChanges() != null) {
                    undoableBlock.getTxOutChanges().serializeToStream(bos);
                    txOutChanges = bos.toByteArray();
                } else {
                    int numTxn = undoableBlock.getTransactions().size();
                    bos.write(0xFF & numTxn >> 0);
                    bos.write(0xFF & numTxn >> 8);
                    bos.write(0xFF & numTxn >> 16);
                    bos.write(0xFF & numTxn >> 24);
                    for (Transaction tx : undoableBlock.getTransactions()) {
                        tx.bitcoinSerialize(bos);
                    }
                    transactions = bos.toByteArray();
                }
                bos.close();
            }
            catch (IOException e) {
                throw new BlockStoreException(e);
            }
            try {
                PreparedStatement s;
                if (log.isDebugEnabled()) {
                    log.debug("Looking for undoable block with hash: " + Utils.HEX.encode(hashBytes));
                }
                PreparedStatement findS = ((Connection)this.conn.get()).prepareStatement(SELECT_UNDOABLEBLOCKS_EXISTS_SQL);
                findS.setBytes(1, hashBytes);
                ResultSet rs = findS.executeQuery();
                if (rs.next()) {
                    findS.close();
                    s = ((Connection)this.conn.get()).prepareStatement(this.getUpdateUndoableBlocksSQL());
                    s.setBytes(3, hashBytes);
                    if (log.isDebugEnabled()) {
                        log.debug("Updating undoable block with hash: " + Utils.HEX.encode(hashBytes));
                    }
                    if (transactions == null) {
                        s.setBytes(1, txOutChanges);
                        s.setNull(2, -2);
                    } else {
                        s.setNull(1, -2);
                        s.setBytes(2, transactions);
                    }
                    s.executeUpdate();
                    s.close();
                    return;
                }
                s = ((Connection)this.conn.get()).prepareStatement(this.getInsertUndoableBlocksSQL());
                s.setBytes(1, hashBytes);
                s.setInt(2, height);
                if (log.isDebugEnabled()) {
                    log.debug("Inserting undoable block with hash: " + Utils.HEX.encode(hashBytes) + " at height " + height);
                }
                if (transactions == null) {
                    s.setBytes(3, txOutChanges);
                    s.setNull(4, -2);
                } else {
                    s.setNull(3, -2);
                    s.setBytes(4, transactions);
                }
                s.executeUpdate();
                s.close();
                try {
                    this.putUpdateStoredBlock(storedBlock, true);
                }
                catch (SQLException e) {
                    throw new BlockStoreException(e);
                }
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(POSTGRES_DUPLICATE_KEY_ERROR_CODE)) break block17;
                throw new BlockStoreException(e);
            }
        }
    }
}

