/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredTransactionOutput;

class StoredTransactionOutPoint
implements Serializable {
    private static final long serialVersionUID = -4064230006297064377L;
    Sha256Hash hash;
    long index;

    StoredTransactionOutPoint(Sha256Hash hash, long index) {
        this.hash = hash;
        this.index = index;
    }

    StoredTransactionOutPoint(StoredTransactionOutput out) {
        this.hash = out.getHash();
        this.index = out.getIndex();
    }

    Sha256Hash getHash() {
        return this.hash;
    }

    long getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hash.hashCode() + (int)this.index;
    }

    public String toString() {
        return "Stored transaction out point: " + this.hash.toString() + ":" + this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredTransactionOutPoint other = (StoredTransactionOutPoint)o;
        return this.getIndex() == other.getIndex() && Objects.equal((Object)this.getHash(), (Object)other.getHash());
    }
}

