/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.utils.Threading;

public class MockTransactionBroadcaster
implements TransactionBroadcaster {
    private final ReentrantLock lock = Threading.lock("mock tx broadcaster");
    private final Wallet wallet;
    private final LinkedBlockingQueue<TxFuturePair> broadcasts = new LinkedBlockingQueue();

    public MockTransactionBroadcaster(Wallet wallet) {
        this.lock.lock();
        try {
            this.wallet = wallet;
            wallet.setTransactionBroadcaster(this);
            wallet.getPendingTransactions();
        }
        finally {
            this.lock.unlock();
        }
    }

    public SettableFuture<Transaction> broadcastTransaction(Transaction tx) {
        this.lock.lock();
        try {
            SettableFuture result = SettableFuture.create();
            this.broadcasts.put(new TxFuturePair(tx, (SettableFuture<Transaction>)result));
            Futures.addCallback((ListenableFuture)result, (FutureCallback)new FutureCallback<Transaction>(){

                public void onSuccess(Transaction result) {
                    try {
                        MockTransactionBroadcaster.this.wallet.receivePending(result, null);
                    }
                    catch (VerificationException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onFailure(Throwable t) {
                }
            });
            SettableFuture settableFuture = result;
            return settableFuture;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Transaction waitForTransaction() {
        return this.waitForTxFuture().tx;
    }

    public Transaction waitForTransactionAndSucceed() {
        TxFuturePair pair = this.waitForTxFuture();
        pair.succeed();
        return pair.tx;
    }

    public TxFuturePair waitForTxFuture() {
        try {
            return this.broadcasts.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.broadcasts.size();
    }

    public static class TxFuturePair {
        public final Transaction tx;
        public final SettableFuture<Transaction> future;

        public TxFuturePair(Transaction tx, SettableFuture<Transaction> future) {
            this.tx = tx;
            this.future = future;
        }

        public void succeed() {
            this.future.set((Object)this.tx);
        }
    }
}

