/*
 * Decompiled with CFR 0.152.
 */
package com.spark.blockchain.rpcclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.spark.blockchain.rpcclient.Bitcoin;
import com.spark.blockchain.rpcclient.BitcoinException;
import com.spark.blockchain.rpcclient.BitcoinRPCException;
import com.spark.blockchain.rpcclient.ListMapWrapper;
import com.spark.blockchain.rpcclient.MapWrapper;
import com.spark.blockchain.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class BitcoinRPCClient
implements Bitcoin {
    private static final Logger logger = Logger.getLogger(BitcoinRPCClient.class.getCanonicalName());
    public final URL rpcURL;
    private URL noAuthURL;
    private String authStr;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    private int connectTimeout = 0;
    public static final Charset QUERY_CHARSET = Charset.forName("UTF-8");

    public BitcoinRPCClient(String rpcUrl) throws MalformedURLException {
        this(new URL(rpcUrl));
    }

    public BitcoinRPCClient(URL rpc) {
        this.rpcURL = rpc;
        try {
            this.noAuthURL = new URI(rpc.getProtocol(), null, rpc.getHost(), rpc.getPort(), rpc.getPath(), rpc.getQuery(), null).toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(rpc.toString(), ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(rpc.toString(), ex);
        }
        this.authStr = rpc.getUserInfo() == null ? null : String.valueOf(Base64Coder.encode(rpc.getUserInfo().getBytes(Charset.forName("ISO8859-1"))));
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public byte[] prepareRequest(final String method, final Object ... params) {
        return com.spark.blockchain.util.JSON.stringify(new LinkedHashMap(){
            {
                this.put("method", method);
                this.put("params", params);
                this.put("id", "1");
            }
        }).getBytes(QUERY_CHARSET);
    }

    private static byte[] loadStream(InputStream in, boolean close) throws IOException {
        int nr;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((nr = in.read(buffer)) != -1) {
            if (nr == 0) {
                throw new IOException("Read timed out");
            }
            o.write(buffer, 0, nr);
        }
        return o.toByteArray();
    }

    public Object loadResponse(InputStream in, Object expectedID, boolean close) throws IOException, BitcoinException {
        try {
            String r = new String(BitcoinRPCClient.loadStream(in, close), QUERY_CHARSET);
            logger.log(Level.FINE, "Bitcoin JSON-RPC response:\n{0}", r);
            try {
                JSONObject response = JSON.parseObject((String)r);
                if (!expectedID.equals(response.get((Object)"id"))) {
                    throw new BitcoinRPCException("Wrong response ID (expected: " + String.valueOf(expectedID) + ", response: " + response.get((Object)"id") + ")");
                }
                if (response.get((Object)"error") != null) {
                    throw new BitcoinException(com.spark.blockchain.util.JSON.stringify(response.get((Object)"error")));
                }
                Object object = response.get((Object)"result");
                return object;
            }
            catch (ClassCastException ex) {
                throw new BitcoinRPCException("Invalid server response format (data: \"" + r + "\")");
            }
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    public Object query(String method, Object ... o) throws BitcoinException {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.noAuthURL.openConnection();
            if (this.connectTimeout != 0) {
                conn.setConnectTimeout(this.connectTimeout);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (conn instanceof HttpsURLConnection) {
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(this.hostnameVerifier);
                }
                if (this.sslSocketFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
                }
            }
            conn.setRequestProperty("Authorization", "Basic " + this.authStr);
            byte[] r = this.prepareRequest(method, o);
            logger.log(Level.FINE, "Bitcoin JSON-RPC request:\n{0}", new String(r, QUERY_CHARSET));
            conn.getOutputStream().write(r);
            conn.getOutputStream().close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new BitcoinRPCException("RPC Query Failed (method: " + method + ", params: " + Arrays.deepToString(o) + ", response header: " + responseCode + " " + conn.getResponseMessage() + ", response: " + new String(BitcoinRPCClient.loadStream(conn.getErrorStream(), true)));
            }
            return this.loadResponse(conn.getInputStream(), "1", true);
        }
        catch (IOException ex) {
            throw new BitcoinRPCException("RPC Query Failed (method: " + method + ", params: " + Arrays.deepToString(o) + ")", ex);
        }
    }

    @Override
    public void addNode(String node, Bitcoin.AddNoteCmd command) throws BitcoinException {
        this.query("addnode", node, command.toString());
    }

    @Override
    public String createRawTransaction(List<Bitcoin.TxInput> inputs, List<Bitcoin.TxOutput> outputs) throws BitcoinException {
        ArrayList<2> pInputs = new ArrayList<2>();
        for (final Bitcoin.TxInput txInput : inputs) {
            pInputs.add(new LinkedHashMap(){
                {
                    this.put("txid", txInput.txid());
                    this.put("vout", txInput.vout());
                }
            });
        }
        LinkedHashMap<String, BigDecimal> pOutputs = new LinkedHashMap<String, BigDecimal>();
        for (Bitcoin.TxOutput txOutput : outputs) {
            BigDecimal oldValue = pOutputs.put(txOutput.address(), txOutput.amount());
            if (oldValue == null) continue;
            pOutputs.put(txOutput.address(), oldValue.add(txOutput.amount()));
        }
        return (String)this.query("createrawtransaction", pInputs, pOutputs);
    }

    @Override
    public Bitcoin.RawTransaction decodeRawTransaction(String hex) throws BitcoinException {
        return new RawTransactionImpl((Map)this.query("decoderawtransaction", hex));
    }

    @Override
    public String dumpPrivKey(String address) throws BitcoinException {
        return (String)this.query("dumpprivkey", address);
    }

    @Override
    public String getAccount(String address) throws BitcoinException {
        return (String)this.query("getaccount", address);
    }

    @Override
    public String getAccountAddress(String account) throws BitcoinException {
        return (String)this.query("getaccountaddress", account);
    }

    @Override
    public List<String> getAddressesByAccount(String account) throws BitcoinException {
        return (List)this.query("getaddressesbyaccount", account);
    }

    @Override
    public double getBalance() throws BitcoinException {
        return ((Number)this.query("getbalance", new Object[0])).doubleValue();
    }

    @Override
    public double getBalance(String account) throws BitcoinException {
        return ((Number)this.query("getbalance", account)).doubleValue();
    }

    @Override
    public double getBalance(String account, int minConf) throws BitcoinException {
        return ((Number)this.query("getbalance", account, minConf)).doubleValue();
    }

    @Override
    public Bitcoin.Block getBlock(String blockHash) throws BitcoinException {
        return new BlockMapWrapper((Map)this.query("getblock", blockHash));
    }

    @Override
    public int getBlockCount() throws BitcoinException {
        return ((Number)this.query("getblockcount", new Object[0])).intValue();
    }

    @Override
    public String getBlockHash(int blockId) throws BitcoinException {
        return (String)this.query("getblockhash", blockId);
    }

    @Override
    public int getConnectionCount() throws BitcoinException {
        return ((Number)this.query("getconnectioncount", new Object[0])).intValue();
    }

    @Override
    public double getDifficulty() throws BitcoinException {
        return ((Number)this.query("getdifficulty", new Object[0])).doubleValue();
    }

    @Override
    public boolean getGenerate() throws BitcoinException {
        return (Boolean)this.query("getgenerate", new Object[0]);
    }

    @Override
    public double getHashesPerSec() throws BitcoinException {
        return ((Number)this.query("gethashespersec", new Object[0])).doubleValue();
    }

    @Override
    public Bitcoin.Info getInfo() throws BitcoinException {
        return new InfoMapWrapper((Map)this.query("getinfo", new Object[0]));
    }

    @Override
    public Bitcoin.MiningInfo getMiningInfo() throws BitcoinException {
        return new MiningInfoMapWrapper((Map)this.query("getmininginfo", new Object[0]));
    }

    @Override
    public String getNewAddress() throws BitcoinException {
        return (String)this.query("getnewaddress", new Object[0]);
    }

    @Override
    public String getNewAddress(String account) throws BitcoinException {
        return (String)this.query("getnewaddress", account);
    }

    @Override
    public Bitcoin.PeerInfo getPeerInfo() throws BitcoinException {
        return new PeerInfoMapWrapper((Map)this.query("getmininginfo", new Object[0]));
    }

    @Override
    public String getRawTransactionHex(String txId) throws BitcoinException {
        return (String)this.query("getrawtransaction", txId);
    }

    @Override
    public Bitcoin.RawTransaction getRawTransaction(String txId) throws BitcoinException {
        return new RawTransactionImpl((Map)this.query("getrawtransaction", txId, 1));
    }

    @Override
    public double getReceivedByAccount(String account) throws BitcoinException {
        return ((Number)this.query("getreceivedbyaccount", account)).doubleValue();
    }

    @Override
    public double getReceivedByAccount(String account, int minConf) throws BitcoinException {
        return ((Number)this.query("getreceivedbyaccount", account, minConf)).doubleValue();
    }

    @Override
    public double getReceivedByAddress(String address) throws BitcoinException {
        return ((Number)this.query("getreceivedbyaddress", address)).doubleValue();
    }

    @Override
    public double getReceivedByAddress(String address, int minConf) throws BitcoinException {
        return ((Number)this.query("getreceivedbyaddress", address, minConf)).doubleValue();
    }

    @Override
    public Bitcoin.RawTransaction getTransaction(String txId) throws BitcoinException {
        return new RawTransactionImpl((Map)this.query("gettransaction", txId));
    }

    @Override
    public Bitcoin.TxOutSetInfo getTxOutSetInfo() throws BitcoinException {
        final Map txoutsetinfoResult = (Map)this.query("gettxoutsetinfo", new Object[0]);
        return new Bitcoin.TxOutSetInfo(){

            @Override
            public int height() {
                return ((Number)txoutsetinfoResult.get("height")).intValue();
            }

            @Override
            public String bestBlock() {
                return (String)txoutsetinfoResult.get("bestblock");
            }

            @Override
            public int transactions() {
                return ((Number)txoutsetinfoResult.get("transactions")).intValue();
            }

            @Override
            public int txOuts() {
                return ((Number)txoutsetinfoResult.get("txouts")).intValue();
            }

            @Override
            public int bytesSerialized() {
                return ((Number)txoutsetinfoResult.get("bytes_serialized")).intValue();
            }

            @Override
            public String hashSerialized() {
                return (String)txoutsetinfoResult.get("hash_serialized");
            }

            @Override
            public double totalAmount() {
                return ((Number)txoutsetinfoResult.get("total_amount")).doubleValue();
            }

            public String toString() {
                return txoutsetinfoResult.toString();
            }
        };
    }

    @Override
    public Bitcoin.Work getWork() throws BitcoinException {
        final Map workResult = (Map)this.query("getwork", new Object[0]);
        return new Bitcoin.Work(){

            @Override
            public String midstate() {
                return (String)workResult.get("midstate");
            }

            @Override
            public String data() {
                return (String)workResult.get("data");
            }

            @Override
            public String hash1() {
                return (String)workResult.get("hash1");
            }

            @Override
            public String target() {
                return (String)workResult.get("target");
            }

            public String toString() {
                return workResult.toString();
            }
        };
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey) throws BitcoinException {
        this.query("importprivkey", bitcoinPrivKey);
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey, String label) throws BitcoinException {
        this.query("importprivkey", bitcoinPrivKey, label);
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey, String label, boolean rescan) throws BitcoinException {
        this.query("importprivkey", bitcoinPrivKey, label, rescan);
    }

    @Override
    public Map<String, Number> listAccounts() throws BitcoinException {
        return (Map)this.query("listaccounts", new Object[0]);
    }

    @Override
    public Map<String, Number> listAccounts(int minConf) throws BitcoinException {
        return (Map)this.query("listaccounts", minConf);
    }

    @Override
    public List<Bitcoin.ReceivedAddress> listReceivedByAccount() throws BitcoinException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaccount", new Object[0]));
    }

    @Override
    public List<Bitcoin.ReceivedAddress> listReceivedByAccount(int minConf) throws BitcoinException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaccount", minConf));
    }

    @Override
    public List<Bitcoin.ReceivedAddress> listReceivedByAccount(int minConf, boolean includeEmpty) throws BitcoinException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaccount", minConf, includeEmpty));
    }

    @Override
    public List<Bitcoin.ReceivedAddress> listReceivedByAddress() throws BitcoinException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", new Object[0]));
    }

    @Override
    public List<Bitcoin.ReceivedAddress> listReceivedByAddress(int minConf) throws BitcoinException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf));
    }

    @Override
    public List<Bitcoin.ReceivedAddress> listReceivedByAddress(int minConf, boolean includeEmpty) throws BitcoinException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf, includeEmpty));
    }

    @Override
    public Bitcoin.TransactionsSinceBlock listSinceBlock() throws BitcoinException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", new Object[0]));
    }

    @Override
    public Bitcoin.TransactionsSinceBlock listSinceBlock(String blockHash) throws BitcoinException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash));
    }

    @Override
    public Bitcoin.TransactionsSinceBlock listSinceBlock(String blockHash, int targetConfirmations) throws BitcoinException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash, targetConfirmations));
    }

    @Override
    public List<Bitcoin.Transaction> listTransactions() throws BitcoinException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", new Object[0]));
    }

    @Override
    public List<Bitcoin.Transaction> listTransactions(String account) throws BitcoinException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account));
    }

    @Override
    public List<Bitcoin.Transaction> listTransactions(String account, int count) throws BitcoinException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count));
    }

    @Override
    public List<Bitcoin.Transaction> listTransactions(String account, int count, int from) throws BitcoinException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count, from));
    }

    @Override
    public List<Bitcoin.Unspent> listUnspent() throws BitcoinException {
        return new UnspentListWrapper((List)this.query("listunspent", new Object[0]));
    }

    @Override
    public List<Bitcoin.Unspent> listUnspent(int minConf) throws BitcoinException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf));
    }

    @Override
    public List<Bitcoin.Unspent> listUnspent(int minConf, int maxConf) throws BitcoinException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf));
    }

    @Override
    public List<Bitcoin.Unspent> listUnspent(int minConf, int maxConf, String ... addresses) throws BitcoinException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf, addresses));
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount) throws BitcoinException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount);
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount, int minConf) throws BitcoinException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount, minConf);
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount, int minConf, String comment) throws BitcoinException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount, minConf, comment);
    }

    @Override
    public String sendFrom(String fromAccount, String toBitcoinAddress, double amount, int minConf, String comment, String commentTo) throws BitcoinException {
        return (String)this.query("sendfrom", fromAccount, toBitcoinAddress, amount, minConf, comment, commentTo);
    }

    @Override
    public String sendMany(String fromAccount, List<Bitcoin.TxOutput> outputs) throws BitcoinException {
        LinkedHashMap<String, BigDecimal> pOutputs = new LinkedHashMap<String, BigDecimal>();
        for (Bitcoin.TxOutput txOutput : outputs) {
            BigDecimal oldValue = pOutputs.put(txOutput.address(), txOutput.amount());
            if (oldValue == null) continue;
            pOutputs.put(txOutput.address(), oldValue.add(txOutput.amount()));
        }
        return (String)this.query("sendmany", fromAccount, pOutputs);
    }

    @Override
    public String sendMany(String fromAccount, List<Bitcoin.TxOutput> outputs, int minConf) throws BitcoinException {
        LinkedHashMap<String, BigDecimal> pOutputs = new LinkedHashMap<String, BigDecimal>();
        for (Bitcoin.TxOutput txOutput : outputs) {
            BigDecimal oldValue = pOutputs.put(txOutput.address(), txOutput.amount());
            if (oldValue == null) continue;
            pOutputs.put(txOutput.address(), oldValue.add(txOutput.amount()));
        }
        return (String)this.query("sendmany", fromAccount, pOutputs, minConf);
    }

    @Override
    public String sendMany(String fromAccount, List<Bitcoin.TxOutput> outputs, int minConf, String comment) throws BitcoinException {
        LinkedHashMap<String, BigDecimal> pOutputs = new LinkedHashMap<String, BigDecimal>();
        for (Bitcoin.TxOutput txOutput : outputs) {
            BigDecimal oldValue = pOutputs.put(txOutput.address(), txOutput.amount());
            if (oldValue == null) continue;
            pOutputs.put(txOutput.address(), oldValue.add(txOutput.amount()));
        }
        return (String)this.query("sendmany", fromAccount, pOutputs, minConf, comment);
    }

    @Override
    public String sendRawTransaction(String hex) throws BitcoinException {
        return (String)this.query("sendrawtransaction", hex);
    }

    @Override
    public String sendToAddress(String toAddress, double amount) throws BitcoinException {
        return (String)this.query("sendtoaddress", toAddress, amount);
    }

    @Override
    public String sendToAddress(String toAddress, double amount, String comment) throws BitcoinException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment);
    }

    @Override
    public Boolean setTxFee(double amount) throws BitcoinException {
        return (Boolean)this.query("settxfee", amount);
    }

    @Override
    public String sendToAddress(String toAddress, double amount, String comment, String commentTo) throws BitcoinException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment, commentTo);
    }

    @Override
    public String signMessage(String address, String message) throws BitcoinException {
        return (String)this.query("signmessage", address, message);
    }

    @Override
    public String signRawTransaction(String hex) throws BitcoinException {
        Map result = (Map)this.query("signrawtransaction", hex);
        if (((Boolean)result.get("complete")).booleanValue()) {
            return (String)result.get("hex");
        }
        throw new BitcoinException("Incomplete");
    }

    @Override
    public void stop() throws BitcoinException {
        this.query("stop", new Object[0]);
    }

    @Override
    public Bitcoin.AddressValidationResult validateAddress(String address) throws BitcoinException {
        final Map validationResult = (Map)this.query("validateaddress", address);
        return new Bitcoin.AddressValidationResult(){

            @Override
            public boolean isValid() {
                return (Boolean)validationResult.get("isvalid");
            }

            @Override
            public String address() {
                return (String)validationResult.get("address");
            }

            @Override
            public boolean isMine() {
                return (Boolean)validationResult.get("ismine");
            }

            @Override
            public boolean isScript() {
                return (Boolean)validationResult.get("isscript");
            }

            @Override
            public String pubKey() {
                return (String)validationResult.get("pubkey");
            }

            @Override
            public boolean isCompressed() {
                return (Boolean)validationResult.get("iscompressed");
            }

            @Override
            public String account() {
                return (String)validationResult.get("account");
            }

            public String toString() {
                return validationResult.toString();
            }
        };
    }

    @Override
    public boolean verifyMessage(String address, String signature, String message) throws BitcoinException {
        return (Boolean)this.query("verifymessage", address, signature, message);
    }

    private class UnspentListWrapper
    extends ListMapWrapper<Bitcoin.Unspent> {
        public UnspentListWrapper(List<Map> list) {
            super(list);
        }

        @Override
        protected Bitcoin.Unspent wrap(final Map m) {
            return new Bitcoin.Unspent(){

                @Override
                public String txid() {
                    return MapWrapper.mapStr(m, "txid");
                }

                @Override
                public int vout() {
                    return MapWrapper.mapInt(m, "vout");
                }

                @Override
                public String address() {
                    return MapWrapper.mapStr(m, "address");
                }

                @Override
                public String scriptPubKey() {
                    return MapWrapper.mapStr(m, "scriptPubKey");
                }

                @Override
                public String account() {
                    return MapWrapper.mapStr(m, "account");
                }

                @Override
                public BigDecimal amount() {
                    return MapWrapper.mapBigDecimal(m, "amount");
                }

                @Override
                public int confirmations() {
                    return MapWrapper.mapInt(m, "confirmations");
                }
            };
        }
    }

    private class TransactionsSinceBlockImpl
    implements Bitcoin.TransactionsSinceBlock {
        public final List<Bitcoin.Transaction> transactions;
        public final String lastBlock;

        public TransactionsSinceBlockImpl(Map r) {
            this.transactions = new TransactionListMapWrapper((List)r.get("transactions"));
            this.lastBlock = (String)r.get("lastblock");
        }

        @Override
        public List<Bitcoin.Transaction> transactions() {
            return this.transactions;
        }

        @Override
        public String lastBlock() {
            return this.lastBlock;
        }
    }

    private class TransactionListMapWrapper
    extends ListMapWrapper<Bitcoin.Transaction> {
        public TransactionListMapWrapper(List<Map> list) {
            super(list);
        }

        @Override
        protected Bitcoin.Transaction wrap(final Map m) {
            return new Bitcoin.Transaction(){
                private Bitcoin.RawTransaction raw = null;

                @Override
                public String account() {
                    return MapWrapper.mapStr(m, "account");
                }

                @Override
                public String address() {
                    return MapWrapper.mapStr(m, "address");
                }

                @Override
                public String category() {
                    return MapWrapper.mapStr(m, "category");
                }

                @Override
                public double amount() {
                    return MapWrapper.mapDouble(m, "amount");
                }

                @Override
                public double fee() {
                    return MapWrapper.mapDouble(m, "fee");
                }

                @Override
                public int confirmations() {
                    return MapWrapper.mapInt(m, "confirmations");
                }

                @Override
                public String blockHash() {
                    return MapWrapper.mapStr(m, "blockhash");
                }

                @Override
                public int blockIndex() {
                    return MapWrapper.mapInt(m, "blockindex");
                }

                @Override
                public Date blockTime() {
                    return MapWrapper.mapCTime(m, "blocktime");
                }

                @Override
                public String txId() {
                    return MapWrapper.mapStr(m, "txid");
                }

                @Override
                public Date time() {
                    return MapWrapper.mapCTime(m, "time");
                }

                @Override
                public Date timeReceived() {
                    return MapWrapper.mapCTime(m, "timereceived");
                }

                @Override
                public String comment() {
                    return MapWrapper.mapStr(m, "comment");
                }

                @Override
                public String commentTo() {
                    return MapWrapper.mapStr(m, "to");
                }

                @Override
                public Bitcoin.RawTransaction raw() {
                    if (this.raw == null) {
                        try {
                            this.raw = BitcoinRPCClient.this.getRawTransaction(this.txId());
                        }
                        catch (BitcoinException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    return this.raw;
                }

                public String toString() {
                    return m.toString();
                }
            };
        }
    }

    private static class ReceivedAddressListWrapper
    extends AbstractList<Bitcoin.ReceivedAddress> {
        private final List<Map<String, Object>> wrappedList;

        public ReceivedAddressListWrapper(List<Map<String, Object>> wrappedList) {
            this.wrappedList = wrappedList;
        }

        @Override
        public Bitcoin.ReceivedAddress get(int index) {
            final Map<String, Object> e = this.wrappedList.get(index);
            return new Bitcoin.ReceivedAddress(){

                @Override
                public String address() {
                    return (String)e.get("address");
                }

                @Override
                public String account() {
                    return (String)e.get("account");
                }

                @Override
                public double amount() {
                    return ((Number)e.get("amount")).doubleValue();
                }

                @Override
                public int confirmations() {
                    return ((Number)e.get("confirmations")).intValue();
                }

                public String toString() {
                    return e.toString();
                }
            };
        }

        @Override
        public int size() {
            return this.wrappedList.size();
        }
    }

    private class RawTransactionImpl
    extends MapWrapper
    implements Bitcoin.RawTransaction {
        public RawTransactionImpl(Map<String, Object> tx) {
            super(tx);
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public String txId() {
            return this.mapStr("txid");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public long lockTime() {
            return this.mapLong("locktime");
        }

        @Override
        public List<Bitcoin.RawTransaction.In> vIn() {
            final List vIn = (List)this.m.get("vin");
            return new AbstractList<Bitcoin.RawTransaction.In>(){

                @Override
                public Bitcoin.RawTransaction.In get(int index) {
                    return new InImpl((Map)vIn.get(index));
                }

                @Override
                public int size() {
                    return vIn.size();
                }
            };
        }

        @Override
        public List<Bitcoin.RawTransaction.Out> vOut() {
            final List vOut = (List)this.m.get("vout");
            return new AbstractList<Bitcoin.RawTransaction.Out>(){

                @Override
                public Bitcoin.RawTransaction.Out get(int index) {
                    return new OutImpl((Map)vOut.get(index));
                }

                @Override
                public int size() {
                    return vOut.size();
                }
            };
        }

        @Override
        public String blockHash() {
            return this.mapStr("blockhash");
        }

        @Override
        public int confirmations() {
            return this.mapInt("confirmations");
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public Date blocktime() {
            return this.mapCTime("blocktime");
        }

        private class OutImpl
        extends MapWrapper
        implements Bitcoin.RawTransaction.Out {
            public OutImpl(Map m) {
                super(m);
            }

            @Override
            public double value() {
                return this.mapDouble("value");
            }

            @Override
            public int n() {
                return this.mapInt("n");
            }

            @Override
            public Bitcoin.RawTransaction.Out.ScriptPubKey scriptPubKey() {
                return new ScriptPubKeyImpl((Map)this.m.get("scriptPubKey"));
            }

            @Override
            public Bitcoin.TxInput toInput() {
                return new Bitcoin.BasicTxInput(this.transaction().txId(), this.n());
            }

            @Override
            public Bitcoin.RawTransaction transaction() {
                return RawTransactionImpl.this;
            }

            private class ScriptPubKeyImpl
            extends MapWrapper
            implements Bitcoin.RawTransaction.Out.ScriptPubKey {
                public ScriptPubKeyImpl(Map m) {
                    super(m);
                }

                @Override
                public String asm() {
                    return this.mapStr("asm");
                }

                @Override
                public String hex() {
                    return this.mapStr("hex");
                }

                @Override
                public int reqSigs() {
                    return this.mapInt("reqSigs");
                }

                @Override
                public String type() {
                    return this.mapStr(this.type());
                }

                @Override
                public List<String> addresses() {
                    return (List)this.m.get("addresses");
                }
            }
        }

        private class InImpl
        extends MapWrapper
        implements Bitcoin.RawTransaction.In {
            public InImpl(Map m) {
                super(m);
            }

            @Override
            public String txid() {
                return this.mapStr("txid");
            }

            @Override
            public int vout() {
                return this.mapInt("vout");
            }

            @Override
            public Map<String, Object> scriptSig() {
                return (Map)this.m.get("scriptSig");
            }

            @Override
            public long sequence() {
                return this.mapLong("sequence");
            }

            @Override
            public Bitcoin.RawTransaction getTransaction() {
                try {
                    return BitcoinRPCClient.this.getRawTransaction(this.mapStr("txid"));
                }
                catch (BitcoinException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public Bitcoin.RawTransaction.Out getTransactionOutput() {
                return this.getTransaction().vOut().get(this.mapInt("vout"));
            }
        }
    }

    private class PeerInfoMapWrapper
    extends MapWrapper
    implements Bitcoin.PeerInfo {
        public PeerInfoMapWrapper(Map m) {
            super(m);
        }

        @Override
        public String addr() {
            return this.mapStr("addr");
        }

        @Override
        public String services() {
            return this.mapStr("services");
        }

        @Override
        public int lastsend() {
            return this.mapInt("lastsend");
        }

        @Override
        public int lastrecv() {
            return this.mapInt("lastrecv");
        }

        @Override
        public int bytessent() {
            return this.mapInt("bytessent");
        }

        @Override
        public int bytesrecv() {
            return this.mapInt("bytesrecv");
        }

        @Override
        public int blocksrequested() {
            return this.mapInt("blocksrequested");
        }

        @Override
        public Date conntime() {
            return this.mapCTime("conntime");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public String subver() {
            return this.mapStr("subver");
        }

        @Override
        public boolean inbound() {
            return this.mapBool("inbound");
        }

        @Override
        public int startingheight() {
            return this.mapInt("startingheight");
        }

        @Override
        public int banscore() {
            return this.mapInt("banscore");
        }
    }

    private class MiningInfoMapWrapper
    extends MapWrapper
    implements Bitcoin.MiningInfo {
        public MiningInfoMapWrapper(Map m) {
            super(m);
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public int currentblocksize() {
            return this.mapInt("currentblocksize");
        }

        @Override
        public int currentblocktx() {
            return this.mapInt("currentblocktx");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public String errors() {
            return this.mapStr("errors");
        }

        @Override
        public int genproclimit() {
            return this.mapInt("genproclimit");
        }

        @Override
        public double networkhashps() {
            return this.mapDouble("networkhashps");
        }

        @Override
        public int pooledtx() {
            return this.mapInt("pooledtx");
        }

        @Override
        public boolean testnet() {
            return this.mapBool("testnet");
        }

        @Override
        public String chain() {
            return this.mapStr("chain");
        }

        @Override
        public boolean generate() {
            return this.mapBool("generate");
        }
    }

    private class InfoMapWrapper
    extends MapWrapper
    implements Bitcoin.Info {
        public InfoMapWrapper(Map m) {
            super(m);
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public int protocolversion() {
            return this.mapInt("protocolversion");
        }

        @Override
        public int walletversion() {
            return this.mapInt("walletversion");
        }

        @Override
        public double balance() {
            return this.mapDouble("balance");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public int timeoffset() {
            return this.mapInt("timeoffset");
        }

        @Override
        public int connections() {
            return this.mapInt("connections");
        }

        @Override
        public String proxy() {
            return this.mapStr("proxy");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public boolean testnet() {
            return this.mapBool("testnet");
        }

        @Override
        public int keypoololdest() {
            return this.mapInt("keypoololdest");
        }

        @Override
        public int keypoolsize() {
            return this.mapInt("keypoolsize");
        }

        @Override
        public int unlocked_until() {
            return this.mapInt("unlocked_until");
        }

        @Override
        public double paytxfee() {
            return this.mapDouble("paytxfee");
        }

        @Override
        public double relayfee() {
            return this.mapDouble("relayfee");
        }

        @Override
        public String errors() {
            return this.mapStr("errors");
        }
    }

    private class BlockMapWrapper
    extends MapWrapper
    implements Bitcoin.Block {
        public BlockMapWrapper(Map m) {
            super(m);
        }

        @Override
        public String hash() {
            return this.mapStr("hash");
        }

        @Override
        public int confirmations() {
            return this.mapInt("confirmations");
        }

        @Override
        public int size() {
            return this.mapInt("size");
        }

        @Override
        public int height() {
            return this.mapInt("height");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public String merkleRoot() {
            return this.mapStr("");
        }

        @Override
        public List<String> tx() {
            return (List)this.m.get("tx");
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public long nonce() {
            return this.mapLong("nonce");
        }

        @Override
        public String bits() {
            return this.mapStr("bits");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public String previousHash() {
            return this.mapStr("previousblockhash");
        }

        @Override
        public String nextHash() {
            return this.mapStr("nextblockhash");
        }

        @Override
        public Bitcoin.Block previous() throws BitcoinException {
            if (!this.m.containsKey("previousblockhash")) {
                return null;
            }
            return BitcoinRPCClient.this.getBlock(this.previousHash());
        }

        @Override
        public Bitcoin.Block next() throws BitcoinException {
            if (!this.m.containsKey("nextblockhash")) {
                return null;
            }
            return BitcoinRPCClient.this.getBlock(this.nextHash());
        }
    }
}

