/*
 * Decompiled with CFR 0.152.
 */
package com.sparkframework.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMapUtils {
    public static Log log = LogFactory.getLog(BeanMapUtils.class);
    public static String format = "yyyy-MM-dd HH:mm:ss";

    public static void map2Bean(Map<String, ?> map, Object bean) throws NumberFormatException, IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Class<?> rtClass = bean.getClass();
        Field[] fieldArray = fields = rtClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            String key = field.getName();
            if (field.isAnnotationPresent(com.sparkframework.sql.annotation.Field.class)) {
                com.sparkframework.sql.annotation.Field alias = field.getAnnotation(com.sparkframework.sql.annotation.Field.class);
                key = alias.value();
            }
            Class<?> type = field.getType();
            Object value = map.get(key);
            if (value != null) {
                String typeName = type.getName();
                if (typeName.equals("int")) {
                    field.setInt(bean, Integer.parseInt(value.toString()));
                } else if (typeName.equals("long")) {
                    field.setLong(bean, Long.parseLong(value.toString()));
                } else if (typeName.equals("double")) {
                    field.setDouble(bean, Double.parseDouble(value.toString()));
                } else {
                    field.set(bean, value);
                }
            }
            ++n2;
        }
    }

    public static Map<String, String> bean2Map(Object bean) throws IllegalArgumentException, IllegalAccessException {
        Class<?> rtClass = bean.getClass();
        Field[] fields = rtClass.getDeclaredFields();
        HashMap<String, String> map = new HashMap<String, String>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            String key = field.getName();
            if (field.isAnnotationPresent(com.sparkframework.sql.annotation.Field.class)) {
                com.sparkframework.sql.annotation.Field alias = field.getAnnotation(com.sparkframework.sql.annotation.Field.class);
                key = alias.value();
            }
            if ((value = field.get(bean)) != null) {
                map.put(key, value.toString());
            }
            ++n2;
        }
        return map;
    }
}

