/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.handler;

import com.alibaba.fastjson.JSON;
import com.aqmd.netty.annotation.HawkBean;
import com.aqmd.netty.annotation.HawkMethod;
import com.aqmd.netty.common.constant.NettyResponseCode;
import com.aqmd.netty.exception.NettyException;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.Objects;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HawkBean
public class JsonLoginHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @HawkMethod(cmd=11000, version=1)
    public String login(long seqId, byte[] body, ChannelHandlerContext ctx) {
        Subject subject = SecurityUtils.getSubject();
        try {
            Map user = (Map)JSON.parse((String)new String(body));
            UsernamePasswordToken token = new UsernamePasswordToken((String)user.get("username"), (String)user.get("password"));
            subject.login((AuthenticationToken)token);
        }
        catch (IncorrectCredentialsException | UnknownAccountException e) {
            throw new NettyException(e, NettyResponseCode.LOGIN_AUTH_ERROR.getResponseCode() + "~" + NettyResponseCode.LOGIN_AUTH_ERROR.getResponseMessage());
        }
        Session session = subject.getSession();
        session.setAttribute((Object)"loginUser", subject.getPrincipal());
        String userName = Objects.toString(subject.getPrincipal());
        String channelId = ctx.channel().id().asLongText();
        this.logger.info("[{}]\u7528\u6237\u767b\u5f55\u6210\u529f\uff0c\u7f13\u5b58Channel\u53caSession\u4fe1\u606f\uff0cid\u5206\u522b\u4e3a\uff1a[{}]\uff0c[{}]", new Object[]{userName, channelId, session.getId()});
        return "{'responseCode':'200','responseMessage':'\u64cd\u4f5c\u6210\u529f'}";
    }
}

