/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.core;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.litecoinj.core.AbstractBlockChain;
import org.litecoinj.core.Block;
import org.litecoinj.core.Context;
import org.litecoinj.core.FilteredBlock;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.PrunedException;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.StoredBlock;
import org.litecoinj.core.TransactionOutputChanges;
import org.litecoinj.core.VerificationException;
import org.litecoinj.store.BlockStore;
import org.litecoinj.store.BlockStoreException;
import org.litecoinj.wallet.Wallet;

public class BlockChain
extends AbstractBlockChain {
    protected final BlockStore blockStore;

    public BlockChain(Context context, Wallet wallet, BlockStore blockStore) throws BlockStoreException {
        this(context, new ArrayList(), blockStore);
        this.addWallet(wallet);
    }

    public BlockChain(NetworkParameters params, Wallet wallet, BlockStore blockStore) throws BlockStoreException {
        this(Context.getOrCreate(params), wallet, blockStore);
    }

    public BlockChain(Context context, BlockStore blockStore) throws BlockStoreException {
        this(context, new ArrayList(), blockStore);
    }

    public BlockChain(NetworkParameters params, BlockStore blockStore) throws BlockStoreException {
        this(params, new ArrayList(), blockStore);
    }

    public BlockChain(Context params, List<? extends Wallet> wallets, BlockStore blockStore) throws BlockStoreException {
        super(params, wallets, blockStore);
        this.blockStore = blockStore;
    }

    public BlockChain(NetworkParameters params, List<? extends Wallet> wallets, BlockStore blockStore) throws BlockStoreException {
        this(Context.getOrCreate(params), wallets, blockStore);
    }

    @Override
    protected StoredBlock addToBlockStore(StoredBlock storedPrev, Block blockHeader, TransactionOutputChanges txOutChanges) throws BlockStoreException, VerificationException {
        StoredBlock newBlock = storedPrev.build(blockHeader);
        this.blockStore.put(newBlock);
        return newBlock;
    }

    @Override
    protected StoredBlock addToBlockStore(StoredBlock storedPrev, Block blockHeader) throws BlockStoreException, VerificationException {
        StoredBlock newBlock = storedPrev.build(blockHeader);
        this.blockStore.put(newBlock);
        return newBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rollbackBlockStore(int height) throws BlockStoreException {
        this.lock.lock();
        try {
            int currentHeight = this.getBestChainHeight();
            Preconditions.checkArgument((height >= 0 && height <= currentHeight ? 1 : 0) != 0, (String)"Bad height: %s", (int)height);
            if (height == currentHeight) {
                return;
            }
            StoredBlock newChainHead = this.blockStore.getChainHead();
            while (newChainHead.getHeight() > height) {
                if ((newChainHead = newChainHead.getPrev(this.blockStore)) != null) continue;
                throw new BlockStoreException("Unreachable height");
            }
            this.blockStore.put(newChainHead);
            this.setChainHead(newChainHead);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected boolean shouldVerifyTransactions() {
        return false;
    }

    @Override
    protected TransactionOutputChanges connectTransactions(int height, Block block) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TransactionOutputChanges connectTransactions(StoredBlock newBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void disconnectTransactions(StoredBlock block) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doSetChainHead(StoredBlock chainHead) throws BlockStoreException {
        this.blockStore.setChainHead(chainHead);
    }

    @Override
    protected void notSettingChainHead() throws BlockStoreException {
    }

    @Override
    protected StoredBlock getStoredBlockInCurrentScope(Sha256Hash hash) throws BlockStoreException {
        return this.blockStore.get(hash);
    }

    @Override
    public boolean add(FilteredBlock block) throws VerificationException, PrunedException {
        boolean success = super.add(block);
        if (success) {
            this.trackFilteredTransactions(block.getTransactionCount());
        }
        return success;
    }
}

