/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.core;

import com.google.common.base.Objects;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.litecoinj.core.BitcoinSerializer;
import org.litecoinj.core.Block;
import org.litecoinj.core.Coin;
import org.litecoinj.core.MessageSerializer;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.StoredBlock;
import org.litecoinj.core.Transaction;
import org.litecoinj.core.TransactionInput;
import org.litecoinj.core.TransactionOutput;
import org.litecoinj.core.Utils;
import org.litecoinj.core.VerificationException;
import org.litecoinj.net.discovery.HttpDiscovery;
import org.litecoinj.params.MainNetParams;
import org.litecoinj.params.RegTestParams;
import org.litecoinj.params.TestNet2Params;
import org.litecoinj.params.TestNet3Params;
import org.litecoinj.params.UnitTestParams;
import org.litecoinj.script.Script;
import org.litecoinj.store.BlockStore;
import org.litecoinj.store.BlockStoreException;
import org.litecoinj.utils.MonetaryFormat;
import org.litecoinj.utils.VersionTally;

public abstract class NetworkParameters {
    public static final byte[] SATOSHI_KEY = Utils.HEX.decode((CharSequence)"040184710fa689ad5023690c80f3a49c8f13f8d45b8c857fbcbc8bc4a8e4d3eb4b10f4d4604fa08dce601aaf0f470216fe1b51850b4acf21b179c45070ac7b03a9");
    public static final String ID_MAINNET = "org.litecoin.production";
    public static final String ID_TESTNET = "org.litecoin.test";
    public static final String ID_REGTEST = "org.litecoin.regtest";
    public static final String ID_UNITTESTNET = "org.litecoinj.unittest";
    public static final String PAYMENT_PROTOCOL_ID_MAINNET = "main";
    public static final String PAYMENT_PROTOCOL_ID_TESTNET = "test";
    public static final String PAYMENT_PROTOCOL_ID_UNIT_TESTS = "unittest";
    public static final String PAYMENT_PROTOCOL_ID_REGTEST = "regtest";
    protected Block genesisBlock;
    protected BigInteger maxTarget;
    protected int port;
    protected long packetMagic;
    protected int addressHeader;
    protected int p2shHeader;
    protected int dumpedPrivateKeyHeader;
    protected int interval;
    protected int targetTimespan;
    protected byte[] alertSigningKey;
    protected int bip32HeaderPub;
    protected int bip32HeaderPriv;
    protected int majorityEnforceBlockUpgrade;
    protected int majorityRejectBlockOutdated;
    protected int majorityWindow;
    protected String id;
    protected int spendableCoinbaseDepth;
    protected int subsidyDecreaseBlockCount;
    protected int[] acceptableAddressCodes;
    protected String[] dnsSeeds;
    protected int[] addrSeeds;
    protected HttpDiscovery.Details[] httpSeeds = new HttpDiscovery.Details[0];
    protected Map<Integer, Sha256Hash> checkpoints = new HashMap<Integer, Sha256Hash>();
    protected transient MessageSerializer defaultSerializer = null;
    public static final int TARGET_TIMESPAN = 302400;
    public static final int TARGET_SPACING = 150;
    public static final int INTERVAL = 2016;
    public static final int BIP16_ENFORCE_TIME = 1333238400;
    public static final long MAX_COINS = 84000000L;
    public static final Coin MAX_MONEY = Coin.COIN.multiply(84000000L);

    protected NetworkParameters() {
        this.alertSigningKey = SATOSHI_KEY;
        this.genesisBlock = NetworkParameters.createGenesis(this);
    }

    private static Block createGenesis(NetworkParameters n) {
        Block genesisBlock = new Block(n, 1L);
        Transaction t = new Transaction(n);
        try {
            byte[] bytes = Utils.HEX.decode((CharSequence)"04b217bb4e022309");
            TransactionInput input = new TransactionInput(n, t, bytes);
            t.addInput(input);
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes(scriptPubKeyBytes, Utils.HEX.decode((CharSequence)"41044870341873accab7600d65e204bb4ae47c43d20c562ebfbf70cbcb188da98dec8b5ccf0526c8e4d954c6b47b898cc30adf1ff77c2e518ddc9785b87ccb90b8cdac"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(n, t, Coin.FIFTY_COINS, scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        genesisBlock.setMerkleRoot(Sha256Hash.wrap("97ddfbbae6be97fd6cdf3e7ca13232a3afff2353e29badfab7f73011edd4ced9"));
        return genesisBlock;
    }

    @Deprecated
    public static NetworkParameters testNet() {
        return TestNet3Params.get();
    }

    @Deprecated
    public static NetworkParameters testNet2() {
        return TestNet2Params.get();
    }

    @Deprecated
    public static NetworkParameters testNet3() {
        return TestNet3Params.get();
    }

    @Deprecated
    public static NetworkParameters prodNet() {
        return MainNetParams.get();
    }

    @Deprecated
    public static NetworkParameters unitTests() {
        return UnitTestParams.get();
    }

    @Deprecated
    public static NetworkParameters regTests() {
        return RegTestParams.get();
    }

    public String getId() {
        return this.id;
    }

    public abstract String getPaymentProtocolId();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getId().equals(((NetworkParameters)o).getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId()});
    }

    @Nullable
    public static NetworkParameters fromID(String id) {
        if (id.equals(ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (id.equals(ID_TESTNET)) {
            return TestNet3Params.get();
        }
        if (id.equals(ID_UNITTESTNET)) {
            return UnitTestParams.get();
        }
        if (id.equals(ID_REGTEST)) {
            return RegTestParams.get();
        }
        return null;
    }

    @Nullable
    public static NetworkParameters fromPmtProtocolID(String pmtProtocolId) {
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_TESTNET)) {
            return TestNet3Params.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_UNIT_TESTS)) {
            return UnitTestParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_REGTEST)) {
            return RegTestParams.get();
        }
        return null;
    }

    public int getSpendableCoinbaseDepth() {
        return this.spendableCoinbaseDepth;
    }

    public abstract void checkDifficultyTransitions(StoredBlock var1, Block var2, BlockStore var3) throws VerificationException, BlockStoreException;

    public boolean passesCheckpoint(int height, Sha256Hash hash) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash == null || checkpointHash.equals(hash);
    }

    public boolean isCheckpoint(int height) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash != null;
    }

    public int getSubsidyDecreaseBlockCount() {
        return this.subsidyDecreaseBlockCount;
    }

    public String[] getDnsSeeds() {
        return this.dnsSeeds;
    }

    public int[] getAddrSeeds() {
        return this.addrSeeds;
    }

    public HttpDiscovery.Details[] getHttpSeeds() {
        return this.httpSeeds;
    }

    public Block getGenesisBlock() {
        return this.genesisBlock;
    }

    public int getPort() {
        return this.port;
    }

    public long getPacketMagic() {
        return this.packetMagic;
    }

    public int getAddressHeader() {
        return this.addressHeader;
    }

    public int getP2SHHeader() {
        return this.p2shHeader;
    }

    public int getDumpedPrivateKeyHeader() {
        return this.dumpedPrivateKeyHeader;
    }

    public int getTargetTimespan() {
        return this.targetTimespan;
    }

    public int[] getAcceptableAddressCodes() {
        return this.acceptableAddressCodes;
    }

    public boolean allowEmptyPeerChain() {
        return true;
    }

    public int getInterval() {
        return this.interval;
    }

    public BigInteger getMaxTarget() {
        return this.maxTarget;
    }

    public byte[] getAlertSigningKey() {
        return this.alertSigningKey;
    }

    public int getBip32HeaderPub() {
        return this.bip32HeaderPub;
    }

    public int getBip32HeaderPriv() {
        return this.bip32HeaderPriv;
    }

    public abstract Coin getMaxMoney();

    public abstract Coin getMinNonDustOutput();

    public abstract MonetaryFormat getMonetaryFormat();

    public abstract String getUriScheme();

    public abstract boolean hasMaxMoney();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageSerializer getDefaultSerializer() {
        if (null == this.defaultSerializer) {
            NetworkParameters networkParameters = this;
            synchronized (networkParameters) {
                if (null == this.defaultSerializer) {
                    this.defaultSerializer = this.getSerializer(false);
                }
            }
        }
        return this.defaultSerializer;
    }

    public abstract BitcoinSerializer getSerializer(boolean var1);

    public int getMajorityEnforceBlockUpgrade() {
        return this.majorityEnforceBlockUpgrade;
    }

    public int getMajorityRejectBlockOutdated() {
        return this.majorityRejectBlockOutdated;
    }

    public int getMajorityWindow() {
        return this.majorityWindow;
    }

    public EnumSet<Block.VerifyFlag> getBlockVerificationFlags(Block block, VersionTally tally, Integer height) {
        Integer count;
        EnumSet<Block.VerifyFlag> flags = EnumSet.noneOf(Block.VerifyFlag.class);
        if (block.isBIP34() && null != (count = tally.getCountAtOrAbove(2L)) && count >= this.getMajorityEnforceBlockUpgrade()) {
            flags.add(Block.VerifyFlag.HEIGHT_IN_COINBASE);
        }
        return flags;
    }

    public EnumSet<Script.VerifyFlag> getTransactionVerificationFlags(Block block, Transaction transaction, VersionTally tally, Integer height) {
        EnumSet<Script.VerifyFlag> verifyFlags = EnumSet.noneOf(Script.VerifyFlag.class);
        if (block.getTimeSeconds() >= 1333238400L) {
            verifyFlags.add(Script.VerifyFlag.P2SH);
        }
        if (block.getVersion() >= 4L && tally.getCountAtOrAbove(4L) > this.getMajorityEnforceBlockUpgrade()) {
            verifyFlags.add(Script.VerifyFlag.CHECKLOCKTIMEVERIFY);
        }
        return verifyFlags;
    }

    public abstract int getProtocolVersionNum(ProtocolVersion var1);

    public static enum ProtocolVersion {
        MINIMUM(70000),
        PONG(60001),
        BLOOM_FILTER(70000),
        CURRENT(70002);

        private final int bitcoinProtocol;

        private ProtocolVersion(int bitcoinProtocol) {
            this.bitcoinProtocol = bitcoinProtocol;
        }

        public int getBitcoinProtocolVersion() {
            return this.bitcoinProtocol;
        }
    }
}

