/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.litecoinj.core.Block;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.ProtocolException;
import org.litecoinj.core.VerificationException;
import org.litecoinj.store.BlockStore;
import org.litecoinj.store.BlockStoreException;

public class StoredBlock {
    public static final int CHAIN_WORK_BYTES = 12;
    public static final byte[] EMPTY_BYTES = new byte[12];
    public static final int COMPACT_SERIALIZED_SIZE = 96;
    private Block header;
    private BigInteger chainWork;
    private int height;

    public StoredBlock(Block header, BigInteger chainWork, int height) {
        this.header = header;
        this.chainWork = chainWork;
        this.height = height;
    }

    public Block getHeader() {
        return this.header;
    }

    public BigInteger getChainWork() {
        return this.chainWork;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean moreWorkThan(StoredBlock other) {
        return this.chainWork.compareTo(other.chainWork) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredBlock other = (StoredBlock)o;
        return this.header.equals(other.header) && this.chainWork.equals(other.chainWork) && this.height == other.height;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.header, this.chainWork, this.height});
    }

    public StoredBlock build(Block block) throws VerificationException {
        BigInteger chainWork = this.chainWork.add(block.getWork());
        int height = this.height + 1;
        return new StoredBlock(block, chainWork, height);
    }

    public StoredBlock getPrev(BlockStore store) throws BlockStoreException {
        return store.get(this.getHeader().getPrevBlockHash());
    }

    public void serializeCompact(ByteBuffer buffer) {
        byte[] chainWorkBytes = this.getChainWork().toByteArray();
        Preconditions.checkState((chainWorkBytes.length <= 12 ? 1 : 0) != 0, (Object)"Ran out of space to store chain work!");
        if (chainWorkBytes.length < 12) {
            buffer.put(EMPTY_BYTES, 0, 12 - chainWorkBytes.length);
        }
        buffer.put(chainWorkBytes);
        buffer.putInt(this.getHeight());
        byte[] bytes = this.getHeader().unsafeBitcoinSerialize();
        buffer.put(bytes, 0, 80);
    }

    public static StoredBlock deserializeCompact(NetworkParameters params, ByteBuffer buffer) throws ProtocolException {
        byte[] chainWorkBytes = new byte[12];
        buffer.get(chainWorkBytes);
        BigInteger chainWork = new BigInteger(1, chainWorkBytes);
        int height = buffer.getInt();
        byte[] header = new byte[81];
        buffer.get(header, 0, 80);
        return new StoredBlock(params.getDefaultSerializer().makeBlock(header), chainWork, height);
    }

    public String toString() {
        return String.format(Locale.US, "Block %s at height %d: %s", this.getHeader().getHashAsString(), this.getHeight(), this.getHeader().toString());
    }
}

