/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.core;

import java.util.List;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.Transaction;
import org.litecoinj.core.TransactionOutputChanges;

public class StoredUndoableBlock {
    Sha256Hash blockHash;
    private TransactionOutputChanges txOutChanges;
    private List<Transaction> transactions;

    public StoredUndoableBlock(Sha256Hash hash, TransactionOutputChanges txOutChanges) {
        this.blockHash = hash;
        this.transactions = null;
        this.txOutChanges = txOutChanges;
    }

    public StoredUndoableBlock(Sha256Hash hash, List<Transaction> transactions) {
        this.blockHash = hash;
        this.txOutChanges = null;
        this.transactions = transactions;
    }

    public TransactionOutputChanges getTxOutChanges() {
        return this.txOutChanges;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Sha256Hash getHash() {
        return this.blockHash;
    }

    public int hashCode() {
        return this.blockHash.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getHash().equals(((StoredUndoableBlock)o).getHash());
    }

    public String toString() {
        return "Undoable Block " + this.blockHash;
    }
}

