/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.net;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.net.SocketFactory;
import org.litecoinj.net.BlockingClient;
import org.litecoinj.net.ClientConnectionManager;
import org.litecoinj.net.StreamConnection;

public class BlockingClientManager
extends AbstractIdleService
implements ClientConnectionManager {
    private final SocketFactory socketFactory;
    private final Set<BlockingClient> clients = Collections.synchronizedSet(new HashSet());
    private int connectTimeoutMillis = 1000;

    public BlockingClientManager() {
        this.socketFactory = SocketFactory.getDefault();
    }

    public BlockingClientManager(SocketFactory socketFactory) {
        this.socketFactory = (SocketFactory)Preconditions.checkNotNull((Object)socketFactory);
    }

    @Override
    public ListenableFuture<SocketAddress> openConnection(SocketAddress serverAddress, StreamConnection connection) {
        try {
            if (!this.isRunning()) {
                throw new IllegalStateException();
            }
            return new BlockingClient(serverAddress, connection, this.connectTimeoutMillis, this.socketFactory, this.clients).getConnectFuture();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    protected void startUp() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws Exception {
        Set<BlockingClient> set = this.clients;
        synchronized (set) {
            for (BlockingClient client : this.clients) {
                client.closeConnection();
            }
        }
    }

    @Override
    public int getConnectedClientCount() {
        return this.clients.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnections(int n) {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        Set<BlockingClient> set = this.clients;
        synchronized (set) {
            Iterator<BlockingClient> it = this.clients.iterator();
            while (n-- > 0 && it.hasNext()) {
                it.next().closeConnection();
            }
        }
    }
}

