/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import org.litecoinj.net.ConnectionHandler;
import org.litecoinj.net.StreamConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioServer
extends AbstractExecutionThreadService {
    private static final Logger log = LoggerFactory.getLogger(NioServer.class);
    private final StreamConnectionFactory connectionFactory;
    private final ServerSocketChannel sc;
    @VisibleForTesting
    final Selector selector;

    private void handleKey(Selector selector, SelectionKey key) throws IOException {
        if (key.isValid() && key.isAcceptable()) {
            SocketChannel newChannel = this.sc.accept();
            newChannel.configureBlocking(false);
            SelectionKey newKey = newChannel.register(selector, 1);
            try {
                ConnectionHandler handler = new ConnectionHandler(this.connectionFactory, newKey);
                newKey.attach(handler);
                handler.connection.connectionOpened();
            }
            catch (IOException e) {
                log.error("Error handling new connection", (Object)Throwables.getRootCause((Throwable)e).getMessage());
                newKey.channel().close();
            }
        } else {
            ConnectionHandler.handleKey(key);
        }
    }

    public NioServer(StreamConnectionFactory connectionFactory, InetSocketAddress bindAddress) throws IOException {
        this.connectionFactory = connectionFactory;
        this.sc = ServerSocketChannel.open();
        this.sc.configureBlocking(false);
        this.sc.socket().bind(bindAddress);
        this.selector = SelectorProvider.provider().openSelector();
        this.sc.register(this.selector, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws Exception {
        try {
            while (this.isRunning()) {
                this.selector.select();
                Iterator<SelectionKey> keyIterator = this.selector.selectedKeys().iterator();
                while (keyIterator.hasNext()) {
                    SelectionKey key = keyIterator.next();
                    keyIterator.remove();
                    this.handleKey(this.selector, key);
                }
            }
        }
        catch (Exception e) {
            log.error("Error trying to open/read from connection: {}", (Throwable)e);
        }
        finally {
            for (SelectionKey key : this.selector.keys()) {
                try {
                    key.channel().close();
                }
                catch (IOException e) {
                    log.error("Error closing channel", (Throwable)e);
                }
                try {
                    key.cancel();
                    this.handleKey(this.selector, key);
                }
                catch (IOException e) {
                    log.error("Error closing selection key", (Throwable)e);
                }
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                log.error("Error closing server selector", (Throwable)e);
            }
            try {
                this.sc.close();
            }
            catch (IOException e) {
                log.error("Error closing server channel", (Throwable)e);
            }
        }
    }

    public void triggerShutdown() {
        this.selector.wakeup();
    }
}

