/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.net.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.litecoin.crawler.PeerSeedProtos;
import org.litecoinj.core.ECKey;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.Utils;
import org.litecoinj.net.discovery.PeerDiscovery;
import org.litecoinj.net.discovery.PeerDiscoveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(HttpDiscovery.class);
    private final Details details;
    private final NetworkParameters params;
    private final OkHttpClient client;

    public HttpDiscovery(NetworkParameters params, URI uri, @Nullable ECKey pubkey) {
        this(params, new Details(pubkey, uri));
    }

    public HttpDiscovery(NetworkParameters params, Details details) {
        this(params, details, new OkHttpClient());
    }

    public HttpDiscovery(NetworkParameters params, Details details, OkHttpClient client) {
        Preconditions.checkArgument((boolean)details.uri.getScheme().startsWith("http"));
        this.details = details;
        this.params = params;
        this.client = client;
    }

    @Override
    public InetSocketAddress[] getPeers(long services, long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        try {
            HttpUrl.Builder url = HttpUrl.get((URI)this.details.uri).newBuilder();
            if (services != 0L) {
                url.addQueryParameter("srvmask", Long.toString(services));
            }
            Request.Builder request = new Request.Builder();
            request.url(url.build());
            request.addHeader("User-Agent", "/litecoinj:0.15-SNAPSHOT/");
            log.info("Requesting seeds from {}", (Object)url);
            Response response = this.client.newCall(request.build()).execute();
            if (!response.isSuccessful()) {
                throw new PeerDiscoveryException("HTTP request failed: " + response.code() + " " + response.message());
            }
            InputStream stream = response.body().byteStream();
            GZIPInputStream zip = new GZIPInputStream(stream);
            PeerSeedProtos.SignedPeerSeeds proto = PeerSeedProtos.SignedPeerSeeds.parseDelimitedFrom(zip);
            stream.close();
            return this.protoToAddrs(proto);
        }
        catch (PeerDiscoveryException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new PeerDiscoveryException(e);
        }
    }

    @VisibleForTesting
    public InetSocketAddress[] protoToAddrs(PeerSeedProtos.SignedPeerSeeds proto) throws PeerDiscoveryException, InvalidProtocolBufferException, SignatureException {
        PeerSeedProtos.PeerSeeds seeds;
        if (this.details.pubkey != null) {
            if (!Arrays.equals(proto.getPubkey().toByteArray(), this.details.pubkey.getPubKey())) {
                throw new PeerDiscoveryException("Public key mismatch");
            }
            byte[] hash = Sha256Hash.hash(proto.getPeerSeeds().toByteArray());
            this.details.pubkey.verifyOrThrow(hash, proto.getSignature().toByteArray());
        }
        if ((seeds = PeerSeedProtos.PeerSeeds.parseFrom(proto.getPeerSeeds())).getTimestamp() < Utils.currentTimeSeconds() - 86400L) {
            throw new PeerDiscoveryException("Seed data is more than one day old: replay attack?");
        }
        if (!seeds.getNet().equals(this.params.getPaymentProtocolId())) {
            throw new PeerDiscoveryException("Network mismatch");
        }
        InetSocketAddress[] results = new InetSocketAddress[seeds.getSeedCount()];
        int i = 0;
        for (PeerSeedProtos.PeerSeedData data : seeds.getSeedList()) {
            results[i++] = new InetSocketAddress(data.getIpAddress(), data.getPort());
        }
        return results;
    }

    @Override
    public void shutdown() {
    }

    public static class Details {
        @Nullable
        public final ECKey pubkey;
        public final URI uri;

        public Details(@Nullable ECKey pubkey, URI uri) {
            this.pubkey = pubkey;
            this.uri = uri;
        }
    }
}

