/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.store;

import java.util.LinkedHashMap;
import java.util.Map;
import org.litecoinj.core.Block;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.StoredBlock;
import org.litecoinj.core.VerificationException;
import org.litecoinj.store.BlockStore;
import org.litecoinj.store.BlockStoreException;

public class MemoryBlockStore
implements BlockStore {
    private LinkedHashMap<Sha256Hash, StoredBlock> blockMap = new LinkedHashMap<Sha256Hash, StoredBlock>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Sha256Hash, StoredBlock> eldest) {
            return MemoryBlockStore.this.blockMap.size() > 5000;
        }
    };
    private StoredBlock chainHead;
    private NetworkParameters params;

    public MemoryBlockStore(NetworkParameters params) {
        try {
            Block genesisHeader = params.getGenesisBlock().cloneAsHeader();
            StoredBlock storedGenesis = new StoredBlock(genesisHeader, genesisHeader.getWork(), 0);
            this.put(storedGenesis);
            this.setChainHead(storedGenesis);
            this.params = params;
        }
        catch (BlockStoreException e) {
            throw new RuntimeException(e);
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized void put(StoredBlock block) throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        Sha256Hash hash = block.getHeader().getHash();
        this.blockMap.put(hash, block);
    }

    @Override
    public synchronized StoredBlock get(Sha256Hash hash) throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        return this.blockMap.get(hash);
    }

    @Override
    public StoredBlock getChainHead() throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        return this.chainHead;
    }

    @Override
    public final void setChainHead(StoredBlock chainHead) throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        this.chainHead = chainHead;
    }

    @Override
    public void close() {
        this.blockMap = null;
    }

    @Override
    public NetworkParameters getParams() {
        return this.params;
    }
}

