/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.utils;

import java.util.Stack;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.StoredBlock;
import org.litecoinj.store.BlockStore;
import org.litecoinj.store.BlockStoreException;

public class VersionTally {
    private final long[] versionWindow;
    private int versionWriteHead = 0;
    private int versionsStored = 0;

    public VersionTally(NetworkParameters params) {
        this.versionWindow = new long[params.getMajorityWindow()];
    }

    public void add(long version) {
        this.versionWindow[this.versionWriteHead++] = version;
        if (this.versionWriteHead == this.versionWindow.length) {
            this.versionWriteHead = 0;
        }
        ++this.versionsStored;
    }

    public Integer getCountAtOrAbove(long version) {
        if (this.versionsStored < this.versionWindow.length) {
            return null;
        }
        int count = 0;
        for (int versionIdx = 0; versionIdx < this.versionWindow.length; ++versionIdx) {
            if (this.versionWindow[versionIdx] < version) continue;
            ++count;
        }
        return count;
    }

    public void initialize(BlockStore blockStore, StoredBlock chainHead) throws BlockStoreException {
        StoredBlock versionBlock = chainHead;
        Stack<Long> versions = new Stack<Long>();
        versions.push(versionBlock.getHeader().getVersion());
        for (int headOffset = 0; headOffset < this.versionWindow.length && null != (versionBlock = versionBlock.getPrev(blockStore)); ++headOffset) {
            versions.push(versionBlock.getHeader().getVersion());
        }
        while (!versions.isEmpty()) {
            this.add((Long)versions.pop());
        }
    }

    public int size() {
        return this.versionWindow.length;
    }
}

