/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.wallet;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.litecoinj.core.Coin;
import org.litecoinj.core.Transaction;
import org.litecoinj.core.TransactionInput;
import org.litecoinj.core.TransactionOutPoint;
import org.litecoinj.core.TransactionOutput;
import org.litecoinj.wallet.CoinSelection;
import org.litecoinj.wallet.CoinSelector;

public class FilteringCoinSelector
implements CoinSelector {
    protected CoinSelector delegate;
    protected HashSet<TransactionOutPoint> spent = new HashSet();

    public FilteringCoinSelector(CoinSelector delegate) {
        this.delegate = delegate;
    }

    public void excludeOutputsSpentBy(Transaction tx) {
        for (TransactionInput input : tx.getInputs()) {
            this.spent.add(input.getOutpoint());
        }
    }

    @Override
    public CoinSelection select(Coin target, List<TransactionOutput> candidates) {
        Iterator<TransactionOutput> iter = candidates.iterator();
        while (iter.hasNext()) {
            TransactionOutput output = iter.next();
            if (!this.spent.contains(output.getOutPointFor())) continue;
            iter.remove();
        }
        return this.delegate.select(target, candidates);
    }
}

