/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.wallet;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.litecoinj.core.Utils;
import org.litecoinj.utils.ContextPropagatingThreadFactory;
import org.litecoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletFiles {
    private static final Logger log = LoggerFactory.getLogger(WalletFiles.class);
    private final Wallet wallet;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ContextPropagatingThreadFactory("Wallet autosave thread", 1));
    private final File file;
    private final AtomicBoolean savePending;
    private final long delay;
    private final TimeUnit delayTimeUnit;
    private final Callable<Void> saver;
    private volatile Listener vListener;

    public WalletFiles(final Wallet wallet, File file, long delay, TimeUnit delayTimeUnit) {
        this.executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        this.executor.allowCoreThreadTimeOut(true);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.savePending = new AtomicBoolean();
        this.delay = delay;
        this.delayTimeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)delayTimeUnit)));
        this.saver = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!WalletFiles.this.savePending.getAndSet(false)) {
                    return null;
                }
                Date lastBlockSeenTime = wallet.getLastBlockSeenTime();
                log.info("Background saving wallet; last seen block is height {}, date {}, hash {}", new Object[]{wallet.getLastBlockSeenHeight(), lastBlockSeenTime != null ? Utils.dateTimeFormat(lastBlockSeenTime) : "unknown", wallet.getLastBlockSeenHash()});
                WalletFiles.this.saveNowInternal();
                return null;
            }
        };
    }

    public void setListener(@Nonnull Listener listener) {
        this.vListener = (Listener)Preconditions.checkNotNull((Object)listener);
    }

    public void saveNow() throws IOException {
        Date lastBlockSeenTime = this.wallet.getLastBlockSeenTime();
        log.info("Saving wallet; last seen block is height {}, date {}, hash {}", new Object[]{this.wallet.getLastBlockSeenHeight(), lastBlockSeenTime != null ? Utils.dateTimeFormat(lastBlockSeenTime) : "unknown", this.wallet.getLastBlockSeenHash()});
        this.saveNowInternal();
    }

    private void saveNowInternal() throws IOException {
        Stopwatch watch = Stopwatch.createStarted();
        File directory = this.file.getAbsoluteFile().getParentFile();
        File temp = File.createTempFile("wallet", null, directory);
        Listener listener = this.vListener;
        if (listener != null) {
            listener.onBeforeAutoSave(temp);
        }
        this.wallet.saveToFile(temp, this.file);
        if (listener != null) {
            listener.onAfterAutoSave(this.file);
        }
        watch.stop();
        log.info("Save completed in {}", (Object)watch);
    }

    public void saveLater() {
        if (this.savePending.getAndSet(true)) {
            return;
        }
        this.executor.schedule(this.saver, this.delay, this.delayTimeUnit);
    }

    public void shutdownAndWait() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException x) {
            throw new RuntimeException(x);
        }
    }

    public static interface Listener {
        public void onBeforeAutoSave(File var1);

        public void onAfterAutoSave(File var1);
    }
}

