/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.wallet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.litecoinj.core.Coin;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.PeerAddress;
import org.litecoinj.core.ScriptException;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.Transaction;
import org.litecoinj.core.TransactionConfidence;
import org.litecoinj.core.TransactionInput;
import org.litecoinj.core.TransactionOutPoint;
import org.litecoinj.core.TransactionOutput;
import org.litecoinj.crypto.KeyCrypter;
import org.litecoinj.crypto.KeyCrypterScrypt;
import org.litecoinj.script.Script;
import org.litecoinj.signers.LocalTransactionSigner;
import org.litecoinj.signers.TransactionSigner;
import org.litecoinj.utils.ExchangeRate;
import org.litecoinj.utils.Fiat;
import org.litecoinj.wallet.DefaultKeyChainFactory;
import org.litecoinj.wallet.KeyChainFactory;
import org.litecoinj.wallet.KeyChainGroup;
import org.litecoinj.wallet.Protos;
import org.litecoinj.wallet.UnreadableWalletException;
import org.litecoinj.wallet.Wallet;
import org.litecoinj.wallet.WalletExtension;
import org.litecoinj.wallet.WalletTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletProtobufSerializer {
    private static final Logger log = LoggerFactory.getLogger(WalletProtobufSerializer.class);
    public static final int CURRENT_WALLET_VERSION = Protos.Wallet.getDefaultInstance().getVersion();
    private static final int WALLET_SIZE_LIMIT = 0x20000000;
    protected Map<ByteString, Transaction> txMap = new HashMap<ByteString, Transaction>();
    private boolean requireMandatoryExtensions = true;
    private boolean requireAllExtensionsKnown = false;
    private int walletWriteBufferSize = 4096;
    private final WalletFactory factory;
    private KeyChainFactory keyChainFactory;

    public WalletProtobufSerializer() {
        this(new WalletFactory(){

            @Override
            public Wallet create(NetworkParameters params, KeyChainGroup keyChainGroup) {
                return new Wallet(params, keyChainGroup);
            }
        });
    }

    public WalletProtobufSerializer(WalletFactory factory) {
        this.factory = factory;
        this.keyChainFactory = new DefaultKeyChainFactory();
    }

    public void setKeyChainFactory(KeyChainFactory keyChainFactory) {
        this.keyChainFactory = keyChainFactory;
    }

    public void setRequireMandatoryExtensions(boolean value) {
        this.requireMandatoryExtensions = value;
    }

    public void setRequireAllExtensionsKnown(boolean value) {
        this.requireAllExtensionsKnown = value;
    }

    public void setWalletWriteBufferSize(int walletWriteBufferSize) {
        this.walletWriteBufferSize = walletWriteBufferSize;
    }

    public void writeWallet(Wallet wallet, OutputStream output) throws IOException {
        Protos.Wallet walletProto = this.walletToProto(wallet);
        CodedOutputStream codedOutput = CodedOutputStream.newInstance((OutputStream)output, (int)this.walletWriteBufferSize);
        walletProto.writeTo(codedOutput);
        codedOutput.flush();
    }

    public String walletToText(Wallet wallet) {
        Protos.Wallet walletProto = this.walletToProto(wallet);
        return TextFormat.printToString((MessageOrBuilder)walletProto);
    }

    public Protos.Wallet walletToProto(Wallet wallet) {
        KeyCrypter keyCrypter;
        Protos.Wallet.Builder walletBuilder = Protos.Wallet.newBuilder();
        walletBuilder.setNetworkIdentifier(wallet.getNetworkParameters().getId());
        if (wallet.getDescription() != null) {
            walletBuilder.setDescription(wallet.getDescription());
        }
        for (WalletTransaction wtx : wallet.getWalletTransactions()) {
            Protos.Transaction txProto = WalletProtobufSerializer.makeTxProto(wtx);
            walletBuilder.addTransaction(txProto);
        }
        walletBuilder.addAllKey(wallet.serializeKeyChainGroupToProtobuf());
        for (Script script : wallet.getWatchedScripts()) {
            Protos.Script protoScript = Protos.Script.newBuilder().setProgram(ByteString.copyFrom((byte[])script.getProgram())).setCreationTimestamp(script.getCreationTimeSeconds() * 1000L).build();
            walletBuilder.addWatchedScript(protoScript);
        }
        Sha256Hash lastSeenBlockHash = wallet.getLastBlockSeenHash();
        if (lastSeenBlockHash != null) {
            walletBuilder.setLastSeenBlockHash(WalletProtobufSerializer.hashToByteString(lastSeenBlockHash));
            walletBuilder.setLastSeenBlockHeight(wallet.getLastBlockSeenHeight());
        }
        if (wallet.getLastBlockSeenTimeSecs() > 0L) {
            walletBuilder.setLastSeenBlockTimeSecs(wallet.getLastBlockSeenTimeSecs());
        }
        if ((keyCrypter = wallet.getKeyCrypter()) == null) {
            walletBuilder.setEncryptionType(Protos.Wallet.EncryptionType.UNENCRYPTED);
        } else {
            walletBuilder.setEncryptionType(keyCrypter.getUnderstoodEncryptionType());
            if (keyCrypter instanceof KeyCrypterScrypt) {
                KeyCrypterScrypt keyCrypterScrypt = (KeyCrypterScrypt)keyCrypter;
                walletBuilder.setEncryptionParameters(keyCrypterScrypt.getScryptParameters());
            } else {
                throw new RuntimeException("The wallet has encryption of type '" + (Object)((Object)keyCrypter.getUnderstoodEncryptionType()) + "' but this WalletProtobufSerializer does not know how to persist this.");
            }
        }
        if (wallet.getKeyRotationTime() != null) {
            long timeSecs = wallet.getKeyRotationTime().getTime() / 1000L;
            walletBuilder.setKeyRotationTime(timeSecs);
        }
        WalletProtobufSerializer.populateExtensions(wallet, walletBuilder);
        for (Map.Entry<String, ByteString> entry : wallet.getTags().entrySet()) {
            Protos.Tag.Builder tag = Protos.Tag.newBuilder().setTag(entry.getKey()).setData(entry.getValue());
            walletBuilder.addTags(tag);
        }
        for (TransactionSigner signer : wallet.getTransactionSigners()) {
            if (signer instanceof LocalTransactionSigner) continue;
            Protos.TransactionSigner.Builder protoSigner = Protos.TransactionSigner.newBuilder();
            protoSigner.setClassName(signer.getClass().getName());
            protoSigner.setData(ByteString.copyFrom((byte[])signer.serialize()));
            walletBuilder.addTransactionSigners(protoSigner);
        }
        walletBuilder.setVersion(wallet.getVersion());
        return walletBuilder.build();
    }

    private static void populateExtensions(Wallet wallet, Protos.Wallet.Builder walletBuilder) {
        for (WalletExtension extension : wallet.getExtensions().values()) {
            Protos.Extension.Builder proto = Protos.Extension.newBuilder();
            proto.setId(extension.getWalletExtensionID());
            proto.setMandatory(extension.isWalletExtensionMandatory());
            proto.setData(ByteString.copyFrom((byte[])extension.serializeWalletExtension()));
            walletBuilder.addExtension(proto);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Protos.Transaction makeTxProto(WalletTransaction wtx) {
        void var4_18;
        Transaction tx = wtx.getTransaction();
        Protos.Transaction.Builder txBuilder = Protos.Transaction.newBuilder();
        txBuilder.setPool(WalletProtobufSerializer.getProtoPool(wtx)).setHash(WalletProtobufSerializer.hashToByteString(tx.getHash())).setVersion((int)tx.getVersion());
        if (tx.getUpdateTime() != null) {
            txBuilder.setUpdatedAt(tx.getUpdateTime().getTime());
        }
        if (tx.getLockTime() > 0L) {
            txBuilder.setLockTime((int)tx.getLockTime());
        }
        for (TransactionInput transactionInput : tx.getInputs()) {
            Protos.TransactionInput.Builder builder = Protos.TransactionInput.newBuilder().setScriptBytes(ByteString.copyFrom((byte[])transactionInput.getScriptBytes())).setTransactionOutPointHash(WalletProtobufSerializer.hashToByteString(transactionInput.getOutpoint().getHash())).setTransactionOutPointIndex((int)transactionInput.getOutpoint().getIndex());
            if (transactionInput.hasSequence()) {
                builder.setSequence((int)transactionInput.getSequenceNumber());
            }
            if (transactionInput.getValue() != null) {
                builder.setValue(transactionInput.getValue().value);
            }
            txBuilder.addTransactionInput(builder);
        }
        for (TransactionOutput transactionOutput : tx.getOutputs()) {
            Protos.TransactionOutput.Builder builder = Protos.TransactionOutput.newBuilder().setScriptBytes(ByteString.copyFrom((byte[])transactionOutput.getScriptBytes())).setValue(transactionOutput.getValue().value);
            TransactionInput spentBy = transactionOutput.getSpentBy();
            if (spentBy != null) {
                Sha256Hash spendingHash = spentBy.getParentTransaction().getHash();
                int spentByTransactionIndex = spentBy.getParentTransaction().getInputs().indexOf(spentBy);
                builder.setSpentByTransactionHash(WalletProtobufSerializer.hashToByteString(spendingHash)).setSpentByTransactionIndex(spentByTransactionIndex);
            }
            txBuilder.addTransactionOutput(builder);
        }
        Map<Sha256Hash, Integer> appearsInHashes = tx.getAppearsInHashes();
        if (appearsInHashes != null) {
            for (Map.Entry<Sha256Hash, Integer> entry : appearsInHashes.entrySet()) {
                txBuilder.addBlockHash(WalletProtobufSerializer.hashToByteString(entry.getKey()));
                txBuilder.addBlockRelativityOffsets(entry.getValue());
            }
        }
        if (tx.hasConfidence()) {
            TransactionConfidence transactionConfidence = tx.getConfidence();
            Protos.TransactionConfidence.Builder builder = Protos.TransactionConfidence.newBuilder();
            WalletProtobufSerializer.writeConfidence(txBuilder, transactionConfidence, builder);
        }
        switch (tx.getPurpose()) {
            case UNKNOWN: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.UNKNOWN;
                break;
            }
            case USER_PAYMENT: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.USER_PAYMENT;
                break;
            }
            case KEY_ROTATION: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.KEY_ROTATION;
                break;
            }
            case ASSURANCE_CONTRACT_CLAIM: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.ASSURANCE_CONTRACT_CLAIM;
                break;
            }
            case ASSURANCE_CONTRACT_PLEDGE: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.ASSURANCE_CONTRACT_PLEDGE;
                break;
            }
            case ASSURANCE_CONTRACT_STUB: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.ASSURANCE_CONTRACT_STUB;
                break;
            }
            case RAISE_FEE: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.RAISE_FEE;
                break;
            }
            default: {
                throw new RuntimeException("New tx purpose serialization not implemented.");
            }
        }
        txBuilder.setPurpose((Protos.Transaction.Purpose)var4_18);
        ExchangeRate exchangeRate = tx.getExchangeRate();
        if (exchangeRate != null) {
            Protos.ExchangeRate.Builder exchangeRateBuilder = Protos.ExchangeRate.newBuilder().setCoinValue(exchangeRate.coin.value).setFiatValue(exchangeRate.fiat.value).setFiatCurrencyCode(exchangeRate.fiat.currencyCode);
            txBuilder.setExchangeRate(exchangeRateBuilder);
        }
        if (tx.getMemo() != null) {
            txBuilder.setMemo(tx.getMemo());
        }
        return txBuilder.build();
    }

    private static Protos.Transaction.Pool getProtoPool(WalletTransaction wtx) {
        switch (wtx.getPool()) {
            case UNSPENT: {
                return Protos.Transaction.Pool.UNSPENT;
            }
            case SPENT: {
                return Protos.Transaction.Pool.SPENT;
            }
            case DEAD: {
                return Protos.Transaction.Pool.DEAD;
            }
            case PENDING: {
                return Protos.Transaction.Pool.PENDING;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfidence(Protos.Transaction.Builder txBuilder, TransactionConfidence confidence, Protos.TransactionConfidence.Builder confidenceBuilder) {
        TransactionConfidence transactionConfidence = confidence;
        synchronized (transactionConfidence) {
            confidenceBuilder.setType(Protos.TransactionConfidence.Type.valueOf(confidence.getConfidenceType().getValue()));
            if (confidence.getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                confidenceBuilder.setAppearedAtHeight(confidence.getAppearedAtChainHeight());
                confidenceBuilder.setDepth(confidence.getDepthInBlocks());
            }
            if (confidence.getConfidenceType() == TransactionConfidence.ConfidenceType.DEAD && confidence.getOverridingTransaction() != null) {
                Sha256Hash overridingHash = confidence.getOverridingTransaction().getHash();
                confidenceBuilder.setOverridingTransaction(WalletProtobufSerializer.hashToByteString(overridingHash));
            }
            TransactionConfidence.Source source = confidence.getSource();
            switch (source) {
                case SELF: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_SELF);
                    break;
                }
                case NETWORK: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_NETWORK);
                    break;
                }
                default: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_UNKNOWN);
                }
            }
        }
        for (PeerAddress address : confidence.getBroadcastBy()) {
            Protos.PeerAddress proto = Protos.PeerAddress.newBuilder().setIpAddress(ByteString.copyFrom((byte[])address.getAddr().getAddress())).setPort(address.getPort()).setServices(address.getServices().longValue()).build();
            confidenceBuilder.addBroadcastBy(proto);
        }
        Date lastBroadcastedAt = confidence.getLastBroadcastedAt();
        if (lastBroadcastedAt != null) {
            confidenceBuilder.setLastBroadcastedAt(lastBroadcastedAt.getTime());
        }
        txBuilder.setConfidence(confidenceBuilder);
    }

    public static ByteString hashToByteString(Sha256Hash hash) {
        return ByteString.copyFrom((byte[])hash.getBytes());
    }

    public static Sha256Hash byteStringToHash(ByteString bs) {
        return Sha256Hash.wrap(bs.toByteArray());
    }

    public Wallet readWallet(InputStream input, WalletExtension ... walletExtensions) throws UnreadableWalletException {
        return this.readWallet(input, false, walletExtensions);
    }

    public Wallet readWallet(InputStream input, boolean forceReset, @Nullable WalletExtension[] extensions) throws UnreadableWalletException {
        try {
            Protos.Wallet walletProto = WalletProtobufSerializer.parseToProto(input);
            String paramsID = walletProto.getNetworkIdentifier();
            NetworkParameters params = NetworkParameters.fromID(paramsID);
            if (params == null) {
                throw new UnreadableWalletException("Unknown network parameters ID " + paramsID);
            }
            return this.readWallet(params, extensions, walletProto, forceReset);
        }
        catch (IOException e) {
            throw new UnreadableWalletException("Could not parse input stream to protobuf", e);
        }
        catch (IllegalStateException e) {
            throw new UnreadableWalletException("Could not parse input stream to protobuf", e);
        }
        catch (IllegalArgumentException e) {
            throw new UnreadableWalletException("Could not parse input stream to protobuf", e);
        }
    }

    public Wallet readWallet(NetworkParameters params, @Nullable WalletExtension[] extensions, Protos.Wallet walletProto) throws UnreadableWalletException {
        return this.readWallet(params, extensions, walletProto, false);
    }

    public Wallet readWallet(NetworkParameters params, @Nullable WalletExtension[] extensions, Protos.Wallet walletProto, boolean forceReset) throws UnreadableWalletException {
        KeyChainGroup keyChainGroup;
        if (walletProto.getVersion() > CURRENT_WALLET_VERSION) {
            throw new UnreadableWalletException.FutureVersion();
        }
        if (!walletProto.getNetworkIdentifier().equals(params.getId())) {
            throw new UnreadableWalletException.WrongNetwork();
        }
        if (walletProto.hasEncryptionParameters()) {
            Protos.ScryptParameters encryptionParameters = walletProto.getEncryptionParameters();
            KeyCrypterScrypt keyCrypter = new KeyCrypterScrypt(encryptionParameters);
            keyChainGroup = KeyChainGroup.fromProtobufEncrypted(params, walletProto.getKeyList(), keyCrypter, this.keyChainFactory);
        } else {
            keyChainGroup = KeyChainGroup.fromProtobufUnencrypted(params, walletProto.getKeyList(), this.keyChainFactory);
        }
        Wallet wallet = this.factory.create(params, keyChainGroup);
        ArrayList scripts = Lists.newArrayList();
        for (Protos.Script protoScript : walletProto.getWatchedScriptList()) {
            try {
                Script script = new Script(protoScript.getProgram().toByteArray(), protoScript.getCreationTimestamp() / 1000L);
                scripts.add(script);
            }
            catch (ScriptException e) {
                throw new UnreadableWalletException("Unparseable script in wallet");
            }
        }
        wallet.addWatchedScripts(scripts);
        if (walletProto.hasDescription()) {
            wallet.setDescription(walletProto.getDescription());
        }
        if (forceReset) {
            wallet.setLastBlockSeenHash(null);
            wallet.setLastBlockSeenHeight(-1);
            wallet.setLastBlockSeenTimeSecs(0L);
        } else {
            for (Protos.Transaction txProto : walletProto.getTransactionList()) {
                this.readTransaction(txProto, wallet.getParams());
            }
            for (Protos.Transaction txProto : walletProto.getTransactionList()) {
                WalletTransaction wtx = this.connectTransactionOutputs(params, txProto);
                wallet.addWalletTransaction(wtx);
            }
            if (!walletProto.hasLastSeenBlockHash()) {
                wallet.setLastBlockSeenHash(null);
            } else {
                wallet.setLastBlockSeenHash(WalletProtobufSerializer.byteStringToHash(walletProto.getLastSeenBlockHash()));
            }
            if (!walletProto.hasLastSeenBlockHeight()) {
                wallet.setLastBlockSeenHeight(-1);
            } else {
                wallet.setLastBlockSeenHeight(walletProto.getLastSeenBlockHeight());
            }
            wallet.setLastBlockSeenTimeSecs(walletProto.getLastSeenBlockTimeSecs());
            if (walletProto.hasKeyRotationTime()) {
                wallet.setKeyRotationTime(new Date(walletProto.getKeyRotationTime() * 1000L));
            }
        }
        this.loadExtensions(wallet, extensions != null ? extensions : new WalletExtension[]{}, walletProto);
        for (Protos.Tag tag : walletProto.getTagsList()) {
            wallet.setTag(tag.getTag(), tag.getData());
        }
        for (Protos.TransactionSigner signerProto : walletProto.getTransactionSignersList()) {
            try {
                Class<?> signerClass = Class.forName(signerProto.getClassName());
                TransactionSigner signer = (TransactionSigner)signerClass.newInstance();
                signer.deserialize(signerProto.getData().toByteArray());
                wallet.addTransactionSigner(signer);
            }
            catch (Exception e) {
                throw new UnreadableWalletException("Unable to deserialize TransactionSigner instance: " + signerProto.getClassName(), e);
            }
        }
        if (walletProto.hasVersion()) {
            wallet.setVersion(walletProto.getVersion());
        }
        this.txMap.clear();
        return wallet;
    }

    private void loadExtensions(Wallet wallet, WalletExtension[] extensionsList, Protos.Wallet walletProto) throws UnreadableWalletException {
        HashMap<String, WalletExtension> extensions = new HashMap<String, WalletExtension>();
        for (WalletExtension e : extensionsList) {
            extensions.put(e.getWalletExtensionID(), e);
        }
        extensions.putAll(wallet.getExtensions());
        for (Protos.Extension extProto : walletProto.getExtensionList()) {
            String id = extProto.getId();
            WalletExtension extension = (WalletExtension)extensions.get(id);
            if (extension == null) {
                if (extProto.getMandatory()) {
                    if (this.requireMandatoryExtensions) {
                        throw new UnreadableWalletException("Unknown mandatory extension in wallet: " + id);
                    }
                    log.error("Unknown extension in wallet {}, ignoring", (Object)id);
                    continue;
                }
                if (!this.requireAllExtensionsKnown) continue;
                throw new UnreadableWalletException("Unknown extension in wallet: " + id);
            }
            log.info("Loading wallet extension {}", (Object)id);
            try {
                wallet.deserializeExtension(extension, extProto.getData().toByteArray());
            }
            catch (Exception e) {
                if (extProto.getMandatory() && this.requireMandatoryExtensions) {
                    log.error("Error whilst reading mandatory extension {}, failing to read wallet", (Object)id);
                    throw new UnreadableWalletException("Could not parse mandatory extension in wallet: " + id);
                }
                if (this.requireAllExtensionsKnown) {
                    log.error("Error whilst reading extension {}, failing to read wallet", (Object)id);
                    throw new UnreadableWalletException("Could not parse extension in wallet: " + id);
                }
                log.warn("Error whilst reading extension {}, ignoring extension", (Object)id, (Object)e);
            }
        }
    }

    public static Protos.Wallet parseToProto(InputStream input) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)input);
        codedInput.setSizeLimit(0x20000000);
        return Protos.Wallet.parseFrom(codedInput);
    }

    private void readTransaction(Protos.Transaction txProto, NetworkParameters params) throws UnreadableWalletException {
        Transaction tx;
        block21: {
            block20: {
                tx = new Transaction(params);
                tx.setVersion(txProto.getVersion());
                if (txProto.hasUpdatedAt()) {
                    tx.setUpdateTime(new Date(txProto.getUpdatedAt()));
                }
                for (Protos.TransactionOutput outputProto : txProto.getTransactionOutputList()) {
                    Coin value = Coin.valueOf(outputProto.getValue());
                    byte[] scriptBytes = outputProto.getScriptBytes().toByteArray();
                    TransactionOutput output = new TransactionOutput(params, tx, value, scriptBytes);
                    tx.addOutput(output);
                }
                for (Protos.TransactionInput inputProto : txProto.getTransactionInputList()) {
                    byte[] scriptBytes = inputProto.getScriptBytes().toByteArray();
                    TransactionOutPoint outpoint = new TransactionOutPoint(params, (long)inputProto.getTransactionOutPointIndex() & 0xFFFFFFFFL, WalletProtobufSerializer.byteStringToHash(inputProto.getTransactionOutPointHash()));
                    Coin value = inputProto.hasValue() ? Coin.valueOf(inputProto.getValue()) : null;
                    TransactionInput input = new TransactionInput(params, tx, scriptBytes, outpoint, value);
                    if (inputProto.hasSequence()) {
                        input.setSequenceNumber(0xFFFFFFFFL & (long)inputProto.getSequence());
                    }
                    tx.addInput(input);
                }
                for (int i = 0; i < txProto.getBlockHashCount(); ++i) {
                    ByteString blockHash = txProto.getBlockHash(i);
                    int relativityOffset = 0;
                    if (txProto.getBlockRelativityOffsetsCount() > 0) {
                        relativityOffset = txProto.getBlockRelativityOffsets(i);
                    }
                    tx.addBlockAppearance(WalletProtobufSerializer.byteStringToHash(blockHash), relativityOffset);
                }
                if (txProto.hasLockTime()) {
                    tx.setLockTime(0xFFFFFFFFL & (long)txProto.getLockTime());
                }
                if (!txProto.hasPurpose()) break block20;
                switch (txProto.getPurpose()) {
                    case UNKNOWN: {
                        tx.setPurpose(Transaction.Purpose.UNKNOWN);
                        break block21;
                    }
                    case USER_PAYMENT: {
                        tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
                        break block21;
                    }
                    case KEY_ROTATION: {
                        tx.setPurpose(Transaction.Purpose.KEY_ROTATION);
                        break block21;
                    }
                    case ASSURANCE_CONTRACT_CLAIM: {
                        tx.setPurpose(Transaction.Purpose.ASSURANCE_CONTRACT_CLAIM);
                        break block21;
                    }
                    case ASSURANCE_CONTRACT_PLEDGE: {
                        tx.setPurpose(Transaction.Purpose.ASSURANCE_CONTRACT_PLEDGE);
                        break block21;
                    }
                    case ASSURANCE_CONTRACT_STUB: {
                        tx.setPurpose(Transaction.Purpose.ASSURANCE_CONTRACT_STUB);
                        break block21;
                    }
                    case RAISE_FEE: {
                        tx.setPurpose(Transaction.Purpose.RAISE_FEE);
                        break block21;
                    }
                    default: {
                        throw new RuntimeException("New purpose serialization not implemented");
                    }
                }
            }
            tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
        }
        if (txProto.hasExchangeRate()) {
            Protos.ExchangeRate exchangeRateProto = txProto.getExchangeRate();
            tx.setExchangeRate(new ExchangeRate(Coin.valueOf(exchangeRateProto.getCoinValue()), Fiat.valueOf(exchangeRateProto.getFiatCurrencyCode(), exchangeRateProto.getFiatValue())));
        }
        if (txProto.hasMemo()) {
            tx.setMemo(txProto.getMemo());
        }
        Sha256Hash protoHash = WalletProtobufSerializer.byteStringToHash(txProto.getHash());
        if (!tx.getHash().equals(protoHash)) {
            throw new UnreadableWalletException(String.format(Locale.US, "Transaction did not deserialize completely: %s vs %s", tx.getHash(), protoHash));
        }
        if (this.txMap.containsKey(txProto.getHash())) {
            throw new UnreadableWalletException("Wallet contained duplicate transaction " + WalletProtobufSerializer.byteStringToHash(txProto.getHash()));
        }
        this.txMap.put(txProto.getHash(), tx);
    }

    private WalletTransaction connectTransactionOutputs(NetworkParameters params, Protos.Transaction txProto) throws UnreadableWalletException {
        WalletTransaction.Pool pool;
        Transaction tx = this.txMap.get(txProto.getHash());
        switch (txProto.getPool()) {
            case DEAD: {
                pool = WalletTransaction.Pool.DEAD;
                break;
            }
            case PENDING: {
                pool = WalletTransaction.Pool.PENDING;
                break;
            }
            case SPENT: {
                pool = WalletTransaction.Pool.SPENT;
                break;
            }
            case UNSPENT: {
                pool = WalletTransaction.Pool.UNSPENT;
                break;
            }
            case INACTIVE: 
            case PENDING_INACTIVE: {
                pool = WalletTransaction.Pool.PENDING;
                break;
            }
            default: {
                throw new UnreadableWalletException("Unknown transaction pool: " + (Object)((Object)txProto.getPool()));
            }
        }
        for (int i = 0; i < tx.getOutputs().size(); ++i) {
            TransactionOutput output = tx.getOutputs().get(i);
            Protos.TransactionOutput transactionOutput = txProto.getTransactionOutput(i);
            if (!transactionOutput.hasSpentByTransactionHash()) continue;
            ByteString spentByTransactionHash = transactionOutput.getSpentByTransactionHash();
            Transaction spendingTx = this.txMap.get(spentByTransactionHash);
            if (spendingTx == null) {
                throw new UnreadableWalletException(String.format(Locale.US, "Could not connect %s to %s", tx.getHashAsString(), WalletProtobufSerializer.byteStringToHash(spentByTransactionHash)));
            }
            int spendingIndex = transactionOutput.getSpentByTransactionIndex();
            TransactionInput input = (TransactionInput)Preconditions.checkNotNull((Object)spendingTx.getInput(spendingIndex));
            input.connect(output);
        }
        if (txProto.hasConfidence()) {
            Protos.TransactionConfidence confidenceProto = txProto.getConfidence();
            TransactionConfidence confidence = tx.getConfidence();
            this.readConfidence(params, tx, confidenceProto, confidence);
        }
        return new WalletTransaction(pool, tx);
    }

    private void readConfidence(NetworkParameters params, Transaction tx, Protos.TransactionConfidence confidenceProto, TransactionConfidence confidence) throws UnreadableWalletException {
        TransactionConfidence.ConfidenceType confidenceType;
        if (!confidenceProto.hasType()) {
            log.warn("Unknown confidence type for tx {}", (Object)tx.getHashAsString());
            return;
        }
        switch (confidenceProto.getType()) {
            case BUILDING: {
                confidenceType = TransactionConfidence.ConfidenceType.BUILDING;
                break;
            }
            case DEAD: {
                confidenceType = TransactionConfidence.ConfidenceType.DEAD;
                break;
            }
            case NOT_IN_BEST_CHAIN: {
                confidenceType = TransactionConfidence.ConfidenceType.PENDING;
                break;
            }
            case PENDING: {
                confidenceType = TransactionConfidence.ConfidenceType.PENDING;
                break;
            }
            case IN_CONFLICT: {
                confidenceType = TransactionConfidence.ConfidenceType.IN_CONFLICT;
                break;
            }
            default: {
                confidenceType = TransactionConfidence.ConfidenceType.UNKNOWN;
            }
        }
        confidence.setConfidenceType(confidenceType);
        if (confidenceProto.hasAppearedAtHeight()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
                log.warn("Have appearedAtHeight but not BUILDING for tx {}", (Object)tx.getHashAsString());
                return;
            }
            confidence.setAppearedAtChainHeight(confidenceProto.getAppearedAtHeight());
        }
        if (confidenceProto.hasDepth()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
                log.warn("Have depth but not BUILDING for tx {}", (Object)tx.getHashAsString());
                return;
            }
            confidence.setDepthInBlocks(confidenceProto.getDepth());
        }
        if (confidenceProto.hasOverridingTransaction()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.DEAD) {
                log.warn("Have overridingTransaction but not OVERRIDDEN for tx {}", (Object)tx.getHashAsString());
                return;
            }
            Transaction overridingTransaction = this.txMap.get(confidenceProto.getOverridingTransaction());
            if (overridingTransaction == null) {
                log.warn("Have overridingTransaction that is not in wallet for tx {}", (Object)tx.getHashAsString());
                return;
            }
            confidence.setOverridingTransaction(overridingTransaction);
        }
        for (Protos.PeerAddress proto : confidenceProto.getBroadcastByList()) {
            InetAddress ip;
            try {
                ip = InetAddress.getByAddress(proto.getIpAddress().toByteArray());
            }
            catch (UnknownHostException e) {
                throw new UnreadableWalletException("Peer IP address does not have the right length", e);
            }
            int port = proto.getPort();
            int protocolVersion = params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.CURRENT);
            BigInteger services = BigInteger.valueOf(proto.getServices());
            PeerAddress address = new PeerAddress(params, ip, port, protocolVersion, services);
            confidence.markBroadcastBy(address);
        }
        if (confidenceProto.hasLastBroadcastedAt()) {
            confidence.setLastBroadcastedAt(new Date(confidenceProto.getLastBroadcastedAt()));
        }
        switch (confidenceProto.getSource()) {
            case SOURCE_SELF: {
                confidence.setSource(TransactionConfidence.Source.SELF);
                break;
            }
            case SOURCE_NETWORK: {
                confidence.setSource(TransactionConfidence.Source.NETWORK);
                break;
            }
            default: {
                confidence.setSource(TransactionConfidence.Source.UNKNOWN);
            }
        }
    }

    public static boolean isWallet(InputStream is) {
        try {
            CodedInputStream cis = CodedInputStream.newInstance((InputStream)is);
            int tag = cis.readTag();
            int field = WireFormat.getTagFieldNumber((int)tag);
            if (field != 1) {
                return false;
            }
            String network = cis.readString();
            return NetworkParameters.fromID(network) != null;
        }
        catch (IOException x) {
            return false;
        }
    }

    public static interface WalletFactory {
        public Wallet create(NetworkParameters var1, KeyChainGroup var2);
    }
}

