/*
 * Decompiled with CFR 0.152.
 */
package com.cdeer.apns.http2.core.manager;

import com.cdeer.apns.http2.core.model.ApnsConfig;
import com.cdeer.apns.http2.core.service.ApnsService;
import com.cdeer.apns.http2.core.service.NettyApnsService;
import java.util.HashMap;
import java.util.Map;

public class ApnsServiceManager {
    private static Map<String, ApnsService> serviceMap = new HashMap<String, ApnsService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApnsService createService(ApnsConfig config) {
        ApnsServiceManager.checkConfig(config);
        String name = config.getName();
        ApnsService apnsService = serviceMap.get(name);
        if (apnsService == null) {
            String string = name.intern();
            synchronized (string) {
                if (apnsService == null) {
                    apnsService = NettyApnsService.create(config);
                    serviceMap.put(name, apnsService);
                }
            }
        }
        return apnsService;
    }

    public static ApnsService getService(String name) {
        return serviceMap.get(name);
    }

    private static void checkConfig(ApnsConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("\u914d\u7f6e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5");
        }
        if (config.getKeyStore() == null) {
            throw new IllegalArgumentException("\u8bc1\u4e66\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5");
        }
        if (config.getPassword() == null || "".equals(config.getPassword().trim())) {
            throw new IllegalArgumentException("\u5bc6\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5");
        }
        if (config.getPoolSize() <= 0) {
            throw new IllegalArgumentException("\u6c60\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6570,\u8bf7\u68c0\u67e5");
        }
        if (config.getRetries() <= 0) {
            throw new IllegalArgumentException("\u91cd\u8bd5\u6b21\u6570\u5fc5\u987b\u4e3a\u6b63\u6570,\u8bf7\u68c0\u67e5");
        }
        if (config.getCacheLength() <= 0) {
            throw new IllegalArgumentException("\u7f13\u5b58\u957f\u5ea6\u5fc5\u987b\u4e3a\u6b63\u6570,\u8bf7\u68c0\u67e5");
        }
        if (config.getName() == null || "".equals(config.getName().trim())) {
            throw new IllegalArgumentException("\u670d\u52a1\u540d\u4e3a\u5fc5\u586b\u9879,\u8bf7\u68c0\u67e5");
        }
        if (config.getTopic() == null || "".equals(config.getTopic().trim())) {
            throw new IllegalArgumentException("\u6807\u9898,\u5373\u8bc1\u4e66\u7684bundleID\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5");
        }
    }
}

