/*
 * Decompiled with CFR 0.152.
 */
package com.sparkframework.sql.model;

import com.sparkframework.lang.Convert;
import com.sparkframework.sql.DB;
import com.sparkframework.util.BeanMapUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    private String tableName;
    private String conditionClause;
    private Object[] params;
    private String primaryKey = "id";
    private String action = "";
    private String fields = "*";
    private String orderClause = "";
    private String limitClause = "";
    private String groupByClause = "";
    private Map<String, Object> row = new HashMap<String, Object>();
    private Map<String, Object> dirtyData = new HashMap<String, Object>();

    public Model(String tableName) {
        this.tableName = tableName;
    }

    public Object get(String field) {
        return this.row.get(field);
    }

    public Object get(int index) {
        int i = 0;
        for (Map.Entry<String, Object> entry : this.row.entrySet()) {
            if (index == i) {
                return entry.getValue();
            }
            ++i;
        }
        return null;
    }

    public Model set(String field, Object value) {
        this.dirtyData.put(field, String.valueOf(value));
        return this;
    }

    public long delete() {
        this.action = "DELETE";
        long ret = -1L;
        try {
            String cmd = this.buildSQL();
            ret = DB.exec(cmd, this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int count() {
        List<Map<String, String>> list;
        int ret;
        block3: {
            this.action = "COUNT";
            ret = -1;
            String cmd = this.buildSQL();
            list = DB.query(cmd, this.params);
            if (list.size() != 0) break block3;
            return 0;
        }
        try {
            ret = Convert.strToInt(list.get(0).get("count"), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public long delete(long key) {
        this.where(String.valueOf(this.primaryKey) + " = ?", key);
        return this.delete();
    }

    public Model create(Map<String, Object> map) {
        this.dirtyData = map;
        return this;
    }

    public Model create(Object bean) throws IllegalArgumentException, IllegalAccessException {
        this.create(BeanMapUtils.bean2Map(bean));
        return this;
    }

    public long insert() throws SQLException {
        this.action = "INSERT INTO";
        long ret = -1L;
        try {
            String cmd = this.buildSQL();
            ret = DB.exec(cmd, this.params);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    public long update() throws SQLException {
        this.action = "UPDATE";
        long ret = -1L;
        try {
            String cmd = this.buildSQL();
            ret = DB.exec(cmd, this.params);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    public long setField(String field, Object value) throws SQLException {
        this.set(field, value);
        return this.update();
    }

    public long setInc(String field, Object value) throws SQLException {
        this.action = "UPDATE_INC";
        long ret = -1L;
        try {
            this.set(field, value);
            String cmd = this.buildSQL();
            ret = DB.exec(cmd, this.params);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    public long setDec(String field, Object value) throws SQLException {
        this.action = "UPDATE_DEC";
        long ret = -1L;
        try {
            this.set(field, value);
            String cmd = this.buildSQL();
            ret = DB.exec(cmd, this.params);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    public long update(long key) throws SQLException {
        this.where(String.valueOf(this.primaryKey) + " = ?", key);
        return this.update();
    }

    public List<Map<String, String>> select() throws Exception {
        this.action = "SELECT";
        List<Map<String, String>> list = null;
        try {
            String cmd = this.buildSQL();
            list = this.params == null ? DB.query(cmd) : DB.query(cmd, this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return list;
    }

    public <T> List<T> select(Class<T> beanClass) throws Exception {
        List<Map<String, String>> list = this.select();
        ArrayList<T> listBean = new ArrayList<T>();
        for (Map<String, String> map : list) {
            T bean = beanClass.newInstance();
            BeanMapUtils.map2Bean(map, bean);
            listBean.add(bean);
        }
        return listBean;
    }

    public Map<String, String> find() throws Exception {
        this.action = "SELECT";
        Map<String, String> map = null;
        try {
            String cmd = this.buildSQL();
            List<Map<String, String>> list = null;
            list = this.params == null || this.params.length == 0 ? DB.query(cmd) : DB.query(cmd, this.params);
            if (list.size() > 0) {
                map = list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return map;
    }

    public Map<String, String> find(long key) throws Exception {
        this.where(String.valueOf(this.primaryKey) + " = ?", key);
        return this.find();
    }

    public <T> T find(Class<T> beanClass) throws Exception {
        Map<String, String> map = this.find();
        if (map != null) {
            T bean = beanClass.newInstance();
            BeanMapUtils.map2Bean(map, bean);
            return bean;
        }
        return null;
    }

    public Model where(String clause, Object ... params) {
        this.conditionClause = clause;
        if (params != null && params.length > 0) {
            this.params = params;
        }
        return this;
    }

    public Model where(String clause) {
        this.conditionClause = clause;
        return this;
    }

    public Model limit(int offset, int limit) {
        this.limitClause = "limit " + limit + " offset " + offset;
        return this;
    }

    public Model limit(int limit) {
        this.limitClause = "limit " + limit;
        return this;
    }

    public Model field(String fields) {
        this.fields = fields;
        return this;
    }

    public Model group(String clause) {
        this.groupByClause = "group by " + clause;
        return this;
    }

    public Model order(String ... clause) {
        String clauseJoined = StringUtils.join((Object[])clause, (String)",");
        if (StringUtils.isNotBlank((String)clauseJoined)) {
            this.orderClause = "order by " + clauseJoined;
        }
        return this;
    }

    private String buildSQL() throws SQLException {
        if (this.action == null || this.action.equals("")) {
            throw new SQLException("no action defined for model");
        }
        String mdl = this.action;
        if (this.action.equals("UPDATE_INC") || this.action.equals("UPDATE_DEC")) {
            mdl = "UPDATE";
        }
        StringBuilder sb = new StringBuilder(mdl);
        if (this.action.equals("SELECT")) {
            sb.append(" " + this.fields + " from " + this.tableName);
            if (StringUtils.isNotBlank((String)this.conditionClause)) {
                sb.append(" where " + this.conditionClause);
            }
            if (StringUtils.isNotBlank((String)this.groupByClause)) {
                sb.append(" " + this.groupByClause);
            }
            if (StringUtils.isNotBlank((String)this.orderClause)) {
                sb.append(" " + this.orderClause);
            }
            if (StringUtils.isNotBlank((String)this.limitClause)) {
                sb.append(" " + this.limitClause);
            }
        } else if (this.action.equals("INSERT INTO")) {
            sb.append(" " + this.tableName);
            ArrayList<String> columnList = new ArrayList<String>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            ArrayList<String> signList = new ArrayList<String>();
            if (this.dirtyData.isEmpty()) {
                throw new SQLException("row map for insert is empty");
            }
            for (Map.Entry<String, Object> entry : this.dirtyData.entrySet()) {
                columnList.add("`" + entry.getKey() + "`");
                signList.add("?");
                valueList.add(entry.getValue());
            }
            sb.append("(" + StringUtils.join(columnList, (char)',') + ")");
            sb.append(" values(" + StringUtils.join(signList, (char)',') + ")");
            this.params = valueList.toArray();
        } else if (this.action.equals("UPDATE")) {
            sb.append(" " + this.tableName + " set ");
            if (this.dirtyData.isEmpty()) {
                throw new SQLException("no data to update");
            }
            ArrayList<String> columnList = new ArrayList<String>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : this.dirtyData.entrySet()) {
                columnList.add("`" + entry.getKey() + "` = ?");
                valueList.add(entry.getValue());
            }
            sb.append(StringUtils.join(columnList, (char)','));
            if (StringUtils.isNotBlank((String)this.conditionClause)) {
                sb.append(" where " + this.conditionClause);
            }
            this.params = this.params == null || this.params.length == 0 ? valueList.toArray() : ArrayUtils.addAll((Object[])valueList.toArray(), (Object[])this.params);
        } else if (this.action.equals("UPDATE_INC") || this.action.equals("UPDATE_DEC")) {
            sb.append(" " + this.tableName + " set ");
            char op = this.action.equals("UPDATE_INC") ? (char)'+' : '-';
            ArrayList<String> columnList = new ArrayList<String>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : this.dirtyData.entrySet()) {
                columnList.add("`" + entry.getKey() + "` = `" + entry.getKey() + "` " + op + " ?");
                valueList.add(entry.getValue());
            }
            sb.append(StringUtils.join(columnList, (char)','));
            if (StringUtils.isNotBlank((String)this.conditionClause)) {
                sb.append(" where " + this.conditionClause);
            }
            this.params = this.params == null || this.params.length == 0 ? valueList.toArray() : ArrayUtils.addAll((Object[])valueList.toArray(), (Object[])this.params);
        } else if (this.action.equals("DELETE")) {
            sb.append(" from " + this.tableName);
            if (StringUtils.isNotBlank((String)this.conditionClause)) {
                sb.append(" where " + this.conditionClause);
            }
        } else if (this.action.equals("COUNT")) {
            sb = new StringBuilder("SELECT ifnull(count(1),0) as count from " + this.tableName);
            if (StringUtils.isNotBlank((String)this.conditionClause)) {
                sb.append(" where " + this.conditionClause);
            }
            if (StringUtils.isNotBlank((String)this.groupByClause)) {
                sb.append(" " + this.groupByClause);
            }
        }
        return sb.toString();
    }
}

