/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.litecoinj.core.Message;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.ProtocolException;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.Utils;
import org.litecoinj.core.VarInt;

public class GetBlocksMessage
extends Message {
    protected long version;
    protected List<Sha256Hash> locator;
    protected Sha256Hash stopHash;

    public GetBlocksMessage(NetworkParameters params, List<Sha256Hash> locator, Sha256Hash stopHash) {
        super(params);
        this.version = this.protocolVersion;
        this.locator = locator;
        this.stopHash = stopHash;
    }

    public GetBlocksMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0);
    }

    @Override
    protected void parse() throws ProtocolException {
        this.cursor = this.offset;
        this.version = this.readUint32();
        int startCount = (int)this.readVarInt();
        if (startCount > 500) {
            throw new ProtocolException("Number of locators cannot be > 500, received: " + startCount);
        }
        this.length = this.cursor - this.offset + (startCount + 1) * 32;
        this.locator = new ArrayList<Sha256Hash>(startCount);
        for (int i = 0; i < startCount; ++i) {
            this.locator.add(this.readHash());
        }
        this.stopHash = this.readHash();
    }

    public List<Sha256Hash> getLocator() {
        return this.locator;
    }

    public Sha256Hash getStopHash() {
        return this.stopHash;
    }

    public String toString() {
        return "getblocks: " + Utils.join(this.locator);
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Utils.uint32ToByteStreamLE(this.params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.CURRENT), stream);
        stream.write(new VarInt(this.locator.size()).encode());
        for (Sha256Hash hash : this.locator) {
            stream.write(hash.getReversedBytes());
        }
        stream.write(this.stopHash.getReversedBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetBlocksMessage other = (GetBlocksMessage)o;
        return this.version == other.version && this.stopHash.equals(other.stopHash) && this.locator.size() == other.locator.size() && this.locator.containsAll(other.locator);
    }

    public int hashCode() {
        int hashCode = (int)this.version ^ "getblocks".hashCode() ^ this.stopHash.hashCode();
        for (Sha256Hash aLocator : this.locator) {
            hashCode ^= aLocator.hashCode();
        }
        return hashCode;
    }
}

