/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.core;

import com.google.common.base.Preconditions;
import org.litecoinj.core.Block;
import org.litecoinj.core.InventoryItem;
import org.litecoinj.core.ListMessage;
import org.litecoinj.core.MessageSerializer;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.ProtocolException;
import org.litecoinj.core.Transaction;

public class InventoryMessage
extends ListMessage {
    public static final int MAX_INV_SIZE = 50000;

    public InventoryMessage(NetworkParameters params, byte[] bytes) throws ProtocolException {
        super(params, bytes);
    }

    public InventoryMessage(NetworkParameters params, byte[] payload, MessageSerializer serializer, int length) throws ProtocolException {
        super(params, payload, serializer, length);
    }

    public InventoryMessage(NetworkParameters params) {
        super(params);
    }

    public void addBlock(Block block) {
        this.addItem(new InventoryItem(InventoryItem.Type.Block, block.getHash()));
    }

    public void addTransaction(Transaction tx) {
        this.addItem(new InventoryItem(InventoryItem.Type.Transaction, tx.getHash()));
    }

    public static InventoryMessage with(Transaction ... txns) {
        Preconditions.checkArgument((txns.length > 0 ? 1 : 0) != 0);
        InventoryMessage result = new InventoryMessage(txns[0].getParams());
        for (Transaction tx : txns) {
            result.addTransaction(tx);
        }
        return result;
    }
}

