/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.kits;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.litecoinj.core.AbstractBlockChain;
import org.litecoinj.core.BlockChain;
import org.litecoinj.core.CheckpointManager;
import org.litecoinj.core.Context;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.PeerAddress;
import org.litecoinj.core.PeerGroup;
import org.litecoinj.core.TransactionBroadcaster;
import org.litecoinj.core.Utils;
import org.litecoinj.core.listeners.DownloadProgressTracker;
import org.litecoinj.net.discovery.DnsDiscovery;
import org.litecoinj.net.discovery.PeerDiscovery;
import org.litecoinj.protocols.channels.StoredPaymentChannelClientStates;
import org.litecoinj.protocols.channels.StoredPaymentChannelServerStates;
import org.litecoinj.store.BlockStore;
import org.litecoinj.store.BlockStoreException;
import org.litecoinj.store.SPVBlockStore;
import org.litecoinj.wallet.DeterministicSeed;
import org.litecoinj.wallet.KeyChainGroup;
import org.litecoinj.wallet.Protos;
import org.litecoinj.wallet.Wallet;
import org.litecoinj.wallet.WalletExtension;
import org.litecoinj.wallet.WalletProtobufSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletAppKit
extends AbstractIdleService {
    protected static final Logger log = LoggerFactory.getLogger(WalletAppKit.class);
    protected final String filePrefix;
    protected final NetworkParameters params;
    protected volatile BlockChain vChain;
    protected volatile BlockStore vStore;
    protected volatile Wallet vWallet;
    protected volatile PeerGroup vPeerGroup;
    protected final File directory;
    protected volatile File vWalletFile;
    protected boolean useAutoSave = true;
    protected PeerAddress[] peerAddresses;
    protected DownloadProgressTracker downloadListener;
    protected boolean autoStop = true;
    protected InputStream checkpoints;
    protected boolean blockingStartup = true;
    protected String userAgent;
    protected String version;
    protected WalletProtobufSerializer.WalletFactory walletFactory;
    @Nullable
    protected DeterministicSeed restoreFromSeed;
    @Nullable
    protected PeerDiscovery discovery;
    protected volatile Context context;

    public WalletAppKit(NetworkParameters params, File directory, String filePrefix) {
        this(new Context(params), directory, filePrefix);
    }

    public WalletAppKit(Context context, File directory, String filePrefix) {
        this.context = context;
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)context.getParams());
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
        this.filePrefix = (String)Preconditions.checkNotNull((Object)filePrefix);
    }

    public WalletAppKit setPeerNodes(PeerAddress ... addresses) {
        Preconditions.checkState((this.state() == Service.State.NEW ? 1 : 0) != 0, (Object)"Cannot call after startup");
        this.peerAddresses = addresses;
        return this;
    }

    public WalletAppKit connectToLocalHost() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return this.setPeerNodes(new PeerAddress(this.params, localHost, this.params.getPort()));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public WalletAppKit setAutoSave(boolean value) {
        Preconditions.checkState((this.state() == Service.State.NEW ? 1 : 0) != 0, (Object)"Cannot call after startup");
        this.useAutoSave = value;
        return this;
    }

    public WalletAppKit setDownloadListener(DownloadProgressTracker listener) {
        this.downloadListener = listener;
        return this;
    }

    public WalletAppKit setAutoStop(boolean autoStop) {
        this.autoStop = autoStop;
        return this;
    }

    public WalletAppKit setCheckpoints(InputStream checkpoints) {
        if (this.checkpoints != null) {
            Utils.closeUnchecked(this.checkpoints);
        }
        this.checkpoints = (InputStream)Preconditions.checkNotNull((Object)checkpoints);
        return this;
    }

    public WalletAppKit setBlockingStartup(boolean blockingStartup) {
        this.blockingStartup = blockingStartup;
        return this;
    }

    public WalletAppKit setUserAgent(String userAgent, String version) {
        this.userAgent = (String)Preconditions.checkNotNull((Object)userAgent);
        this.version = (String)Preconditions.checkNotNull((Object)version);
        return this;
    }

    public WalletAppKit setWalletFactory(WalletProtobufSerializer.WalletFactory walletFactory) {
        this.walletFactory = walletFactory;
        return this;
    }

    public WalletAppKit restoreWalletFromSeed(DeterministicSeed seed) {
        this.restoreFromSeed = seed;
        return this;
    }

    public WalletAppKit setDiscovery(@Nullable PeerDiscovery discovery) {
        this.discovery = discovery;
        return this;
    }

    protected List<WalletExtension> provideWalletExtensions() throws Exception {
        return ImmutableList.of();
    }

    protected BlockStore provideBlockStore(File file) throws BlockStoreException {
        return new SPVBlockStore(this.params, file);
    }

    protected void onSetupCompleted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChainFileLocked() throws IOException {
        try (RandomAccessFile file2 = null;){
            File file = new File(this.directory, this.filePrefix + ".spvchain");
            if (!file.exists()) {
                boolean bl = false;
                return bl;
            }
            if (file.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            file2 = new RandomAccessFile(file, "rw");
            FileLock lock = file2.getChannel().tryLock();
            if (lock == null) {
                boolean bl = true;
                return bl;
            }
            lock.release();
            boolean bl = false;
            return bl;
        }
    }

    protected void startUp() throws Exception {
        Context.propagate(this.context);
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Could not create directory " + this.directory.getAbsolutePath());
        }
        log.info("Starting up with directory = {}", (Object)this.directory);
        try {
            File chainFile = new File(this.directory, this.filePrefix + ".spvchain");
            boolean chainFileExists = chainFile.exists();
            this.vWalletFile = new File(this.directory, this.filePrefix + ".wallet");
            boolean shouldReplayWallet = this.vWalletFile.exists() && !chainFileExists || this.restoreFromSeed != null;
            this.vWallet = this.createOrLoadWallet(shouldReplayWallet);
            this.vStore = this.provideBlockStore(chainFile);
            if (!chainFileExists || this.restoreFromSeed != null) {
                if (this.checkpoints == null && !Utils.isAndroidRuntime()) {
                    this.checkpoints = CheckpointManager.openStream(this.params);
                }
                if (this.checkpoints != null) {
                    long time;
                    if (this.restoreFromSeed != null) {
                        time = this.restoreFromSeed.getCreationTimeSeconds();
                        if (chainFileExists) {
                            log.info("Deleting the chain file in preparation from restore.");
                            this.vStore.close();
                            if (!chainFile.delete()) {
                                throw new IOException("Failed to delete chain file in preparation for restore.");
                            }
                            this.vStore = new SPVBlockStore(this.params, chainFile);
                        }
                    } else {
                        time = this.vWallet.getEarliestKeyCreationTime();
                    }
                    if (time > 0L) {
                        CheckpointManager.checkpoint(this.params, this.checkpoints, this.vStore, time);
                    } else {
                        log.warn("Creating a new uncheckpointed block store due to a wallet with a creation time of zero: this will result in a very slow chain sync");
                    }
                } else if (chainFileExists) {
                    log.info("Deleting the chain file in preparation from restore.");
                    this.vStore.close();
                    if (!chainFile.delete()) {
                        throw new IOException("Failed to delete chain file in preparation for restore.");
                    }
                    this.vStore = new SPVBlockStore(this.params, chainFile);
                }
            }
            this.vChain = new BlockChain(this.params, this.vStore);
            this.vPeerGroup = this.createPeerGroup();
            if (this.userAgent != null) {
                this.vPeerGroup.setUserAgent(this.userAgent, this.version);
            }
            if (this.peerAddresses != null) {
                for (PeerAddress addr : this.peerAddresses) {
                    this.vPeerGroup.addAddress(addr);
                }
                this.vPeerGroup.setMaxConnections(this.peerAddresses.length);
                this.peerAddresses = null;
            } else if (!this.params.getId().equals("org.litecoin.regtest")) {
                this.vPeerGroup.addPeerDiscovery(this.discovery != null ? this.discovery : new DnsDiscovery(this.params));
            }
            this.vChain.addWallet(this.vWallet);
            this.vPeerGroup.addWallet(this.vWallet);
            this.onSetupCompleted();
            if (this.blockingStartup) {
                this.vPeerGroup.start();
                this.installShutdownHook();
                this.completeExtensionInitiations(this.vPeerGroup);
                DownloadProgressTracker listener = new DownloadProgressTracker();
                this.vPeerGroup.startBlockChainDownload(listener);
                listener.await();
            } else {
                Futures.addCallback((ListenableFuture)this.vPeerGroup.startAsync(), (FutureCallback)new FutureCallback(){

                    public void onSuccess(@Nullable Object result) {
                        WalletAppKit.this.completeExtensionInitiations(WalletAppKit.this.vPeerGroup);
                        DownloadProgressTracker l = WalletAppKit.this.downloadListener == null ? new DownloadProgressTracker() : WalletAppKit.this.downloadListener;
                        WalletAppKit.this.vPeerGroup.startBlockChainDownload(l);
                    }

                    public void onFailure(Throwable t) {
                        throw new RuntimeException(t);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
        }
        catch (BlockStoreException e) {
            throw new IOException(e);
        }
    }

    private Wallet createOrLoadWallet(boolean shouldReplayWallet) throws Exception {
        Wallet wallet;
        this.maybeMoveOldWalletOutOfTheWay();
        if (this.vWalletFile.exists()) {
            wallet = this.loadWallet(shouldReplayWallet);
        } else {
            wallet = this.createWallet();
            wallet.freshReceiveKey();
            for (WalletExtension e : this.provideWalletExtensions()) {
                wallet.addExtension(e);
            }
            wallet.saveToFile(this.vWalletFile);
            wallet = this.loadWallet(false);
        }
        if (this.useAutoSave) {
            this.setupAutoSave(wallet);
        }
        return wallet;
    }

    protected void setupAutoSave(Wallet wallet) {
        wallet.autosaveToFile(this.vWalletFile, 5L, TimeUnit.SECONDS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wallet loadWallet(boolean shouldReplayWallet) throws Exception {
        Wallet wallet;
        try (FileInputStream walletStream = new FileInputStream(this.vWalletFile);){
            List<WalletExtension> extensions = this.provideWalletExtensions();
            WalletExtension[] extArray = extensions.toArray(new WalletExtension[extensions.size()]);
            Protos.Wallet proto = WalletProtobufSerializer.parseToProto(walletStream);
            WalletProtobufSerializer serializer = this.walletFactory != null ? new WalletProtobufSerializer(this.walletFactory) : new WalletProtobufSerializer();
            wallet = serializer.readWallet(this.params, extArray, proto);
            if (shouldReplayWallet) {
                wallet.reset();
            }
        }
        return wallet;
    }

    protected Wallet createWallet() {
        KeyChainGroup kcg = this.restoreFromSeed != null ? new KeyChainGroup(this.params, this.restoreFromSeed) : new KeyChainGroup(this.params);
        if (this.walletFactory != null) {
            return this.walletFactory.create(this.params, kcg);
        }
        return new Wallet(this.params, kcg);
    }

    private void maybeMoveOldWalletOutOfTheWay() {
        File newName;
        if (this.restoreFromSeed == null) {
            return;
        }
        if (!this.vWalletFile.exists()) {
            return;
        }
        int counter = 1;
        do {
            newName = new File(this.vWalletFile.getParent(), "Backup " + counter + " for " + this.vWalletFile.getName());
            ++counter;
        } while (newName.exists());
        log.info("Renaming old wallet file {} to {}", (Object)this.vWalletFile, (Object)newName);
        if (!this.vWalletFile.renameTo(newName)) {
            throw new RuntimeException("Failed to rename wallet for restore");
        }
    }

    private void completeExtensionInitiations(TransactionBroadcaster transactionBroadcaster) {
        StoredPaymentChannelServerStates serverStoredChannels;
        StoredPaymentChannelClientStates clientStoredChannels = (StoredPaymentChannelClientStates)this.vWallet.getExtensions().get(StoredPaymentChannelClientStates.class.getName());
        if (clientStoredChannels != null) {
            clientStoredChannels.setTransactionBroadcaster(transactionBroadcaster);
        }
        if ((serverStoredChannels = (StoredPaymentChannelServerStates)this.vWallet.getExtensions().get(StoredPaymentChannelServerStates.class.getName())) != null) {
            serverStoredChannels.setTransactionBroadcaster(transactionBroadcaster);
        }
    }

    protected PeerGroup createPeerGroup() throws TimeoutException {
        return new PeerGroup(this.params, (AbstractBlockChain)this.vChain);
    }

    private void installShutdownHook() {
        if (this.autoStop) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        WalletAppKit.this.stopAsync();
                        WalletAppKit.this.awaitTerminated();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    protected void shutDown() throws Exception {
        try {
            Context.propagate(this.context);
            this.vPeerGroup.stop();
            this.vWallet.saveToFile(this.vWalletFile);
            this.vStore.close();
            this.vPeerGroup = null;
            this.vWallet = null;
            this.vStore = null;
            this.vChain = null;
        }
        catch (BlockStoreException e) {
            throw new IOException(e);
        }
    }

    public NetworkParameters params() {
        return this.params;
    }

    public BlockChain chain() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vChain;
    }

    public BlockStore store() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vStore;
    }

    public Wallet wallet() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vWallet;
    }

    public PeerGroup peerGroup() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vPeerGroup;
    }

    public File directory() {
        return this.directory;
    }
}

