/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.net;

import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractTimeoutHandler {
    private TimerTask timeoutTask;
    private long timeoutMillis = 0L;
    private boolean timeoutEnabled = true;
    private static final Timer timeoutTimer = new Timer("AbstractTimeoutHandler timeouts", true);

    public final synchronized void setTimeoutEnabled(boolean timeoutEnabled) {
        this.timeoutEnabled = timeoutEnabled;
        this.resetTimeout();
    }

    public final synchronized void setSocketTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        this.resetTimeout();
    }

    protected synchronized void resetTimeout() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        if (this.timeoutMillis == 0L || !this.timeoutEnabled) {
            return;
        }
        this.timeoutTask = new TimerTask(){

            @Override
            public void run() {
                AbstractTimeoutHandler.this.timeoutOccurred();
            }
        };
        timeoutTimer.schedule(this.timeoutTask, this.timeoutMillis);
    }

    protected abstract void timeoutOccurred();
}

