/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.params;

import com.google.common.base.Preconditions;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.Utils;
import org.litecoinj.net.discovery.HttpDiscovery;
import org.litecoinj.params.AbstractBitcoinNetParams;

public class MainNetParams
extends AbstractBitcoinNetParams {
    private int p2shHeader2;
    public static final int MAINNET_MAJORITY_WINDOW = 1000;
    public static final int MAINNET_MAJORITY_REJECT_BLOCK_OUTDATED = 950;
    public static final int MAINNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 750;
    private static MainNetParams instance;

    public MainNetParams() {
        this.interval = 2016;
        this.targetTimespan = 302400;
        this.maxTarget = Utils.decodeCompactBits(504365055L);
        this.addressHeader = 48;
        this.dumpedPrivateKeyHeader = 128 + this.addressHeader;
        this.p2shHeader = 5;
        this.p2shHeader2 = 50;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader, this.p2shHeader2};
        this.port = 9333;
        this.packetMagic = 4223710939L;
        this.bip32HeaderPub = 27108450;
        this.bip32HeaderPriv = 27106558;
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.majorityWindow = 1000;
        this.genesisBlock.setDifficultyTarget(504365040L);
        this.genesisBlock.setTime(1317972665L);
        this.genesisBlock.setNonce(2084524493L);
        this.id = "org.litecoin.production";
        this.subsidyDecreaseBlockCount = 840000;
        this.spendableCoinbaseDepth = 100;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("12a765e31ffd4059bada1e25190f6e98c99d9714d334efa41a195a7e7e04bfe2"), (Object)genesisHash);
        this.checkpoints.put(1500, Sha256Hash.wrap("841a2965955dd288cfa707a755d05a54e45f8bd476835ec9af4402a2b59a2967"));
        this.checkpoints.put(4032, Sha256Hash.wrap("9ce90e427198fc0ef05e5905ce3503725b80e26afd35a987965fd7e3d9cf0846"));
        this.checkpoints.put(8064, Sha256Hash.wrap("eb984353fc5190f210651f150c40b8a4bab9eeeff0b729fcb3987da694430d70"));
        this.checkpoints.put(16128, Sha256Hash.wrap("602edf1859b7f9a6af809f1d9b0e6cb66fdc1d4d9dcd7a4bec03e12a1ccd153d"));
        this.checkpoints.put(23420, Sha256Hash.wrap("d80fdf9ca81afd0bd2b2a90ac3a9fe547da58f2530ec874e978fce0b5101b507"));
        this.checkpoints.put(50000, Sha256Hash.wrap("69dc37eb029b68f075a5012dcc0419c127672adb4f3a32882b2b3e71d07a20a6"));
        this.checkpoints.put(80000, Sha256Hash.wrap("4fcb7c02f676a300503f49c764a89955a8f920b46a8cbecb4867182ecdb2e90a"));
        this.checkpoints.put(120000, Sha256Hash.wrap("bd9d26924f05f6daa7f0155f32828ec89e8e29cee9e7121b026a7a3552ac6131"));
        this.checkpoints.put(161500, Sha256Hash.wrap("dbe89880474f4bb4f75c227c77ba1cdc024991123b28b8418dbbf7798471ff43"));
        this.checkpoints.put(179620, Sha256Hash.wrap("2ad9c65c990ac00426d18e446e0fd7be2ffa69e9a7dcb28358a50b2b78b9f709"));
        this.checkpoints.put(240000, Sha256Hash.wrap("7140d1c4b4c2157ca217ee7636f24c9c73db39c4590c4e6eab2e3ea1555088aa"));
        this.checkpoints.put(383640, Sha256Hash.wrap("2b6809f094a9215bafc65eb3f110a35127a34be94b7d0590a096c3f126c6f364"));
        this.checkpoints.put(409004, Sha256Hash.wrap("487518d663d9f1fa08611d9395ad74d982b667fbdc0e77e9cf39b4f1355908a3"));
        this.checkpoints.put(456000, Sha256Hash.wrap("bf34f71cc6366cd487930d06be22f897e34ca6a40501ac7d401be32456372004"));
        this.checkpoints.put(541794, Sha256Hash.wrap("1cbccbe6920e7c258bbce1f26211084efb19764aa3224bec3f4320d77d6a2fd2"));
        this.checkpoints.put(585010, Sha256Hash.wrap("ea9ea06840de20a18a66acb07c9102ee6374ad2cbafc71794e576354fea5df2d"));
        this.checkpoints.put(638902, Sha256Hash.wrap("15238656e8ec63d28de29a8c75fcf3a5819afc953dcd9cc45cecc53baec74f38"));
        this.dnsSeeds = new String[]{"seed-a.litecoin.loshan.co.uk", "dnsseed.thrasher.io", "dnsseed.litecointools.com", "dnsseed.litecoinpool.org", "dnsseed.koin-project.com"};
        this.httpSeeds = new HttpDiscovery.Details[0];
        this.addrSeeds = new int[0];
    }

    public static synchronized MainNetParams get() {
        if (instance == null) {
            instance = new MainNetParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "main";
    }
}

