/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.protocols.channels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.litecoinj.core.Coin;
import org.litecoinj.core.Context;
import org.litecoinj.core.ECKey;
import org.litecoinj.core.InsufficientMoneyException;
import org.litecoinj.core.NetworkParameters;
import org.litecoinj.core.Sha256Hash;
import org.litecoinj.core.Transaction;
import org.litecoinj.core.TransactionConfidence;
import org.litecoinj.core.TransactionOutput;
import org.litecoinj.core.VerificationException;
import org.litecoinj.crypto.TransactionSignature;
import org.litecoinj.protocols.channels.IPaymentChannelClient;
import org.litecoinj.protocols.channels.PaymentChannelClientState;
import org.litecoinj.protocols.channels.PaymentChannelV1ClientState;
import org.litecoinj.protocols.channels.StoredClientChannel;
import org.litecoinj.protocols.channels.StoredPaymentChannelClientStates;
import org.litecoinj.protocols.channels.ValueOutOfRangeException;
import org.litecoinj.script.Script;
import org.litecoinj.script.ScriptBuilder;
import org.litecoinj.wallet.AllowUnconfirmedCoinSelector;
import org.litecoinj.wallet.SendRequest;
import org.litecoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;

public class PaymentChannelV2ClientState
extends PaymentChannelClientState {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelV1ClientState.class);
    private final Coin totalValue;
    private final long expiryTime;
    @VisibleForTesting
    Transaction refundTx;
    private Coin refundFees;
    private Transaction contract;

    PaymentChannelV2ClientState(StoredClientChannel storedClientChannel, Wallet wallet) throws VerificationException {
        super(storedClientChannel, wallet);
        this.contract = (Transaction)Preconditions.checkNotNull((Object)storedClientChannel.contract);
        this.expiryTime = storedClientChannel.expiryTime;
        this.totalValue = this.contract.getOutput(0L).getValue();
        this.valueToMe = (Coin)Preconditions.checkNotNull((Object)storedClientChannel.valueToMe);
        this.refundTx = (Transaction)Preconditions.checkNotNull((Object)storedClientChannel.refund);
        this.refundFees = (Coin)Preconditions.checkNotNull((Object)storedClientChannel.refundFees);
        this.stateMachine.transition(PaymentChannelClientState.State.READY);
        this.initWalletListeners();
    }

    public PaymentChannelV2ClientState(Wallet wallet, ECKey myKey, ECKey serverMultisigKey, Coin value, long expiryTimeInSeconds) throws VerificationException {
        super(wallet, myKey, serverMultisigKey, value, expiryTimeInSeconds);
        Preconditions.checkArgument((value.signum() > 0 ? 1 : 0) != 0);
        this.initWalletListeners();
        this.valueToMe = this.totalValue = (Coin)Preconditions.checkNotNull((Object)value);
        this.expiryTime = expiryTimeInSeconds;
        this.stateMachine.transition(PaymentChannelClientState.State.NEW);
    }

    @Override
    protected Multimap<PaymentChannelClientState.State, PaymentChannelClientState.State> getStateTransitions() {
        ListMultimap result = MultimapBuilder.enumKeys(PaymentChannelClientState.State.class).arrayListValues().build();
        result.put((Object)PaymentChannelClientState.State.UNINITIALISED, (Object)PaymentChannelClientState.State.NEW);
        result.put((Object)PaymentChannelClientState.State.UNINITIALISED, (Object)PaymentChannelClientState.State.READY);
        result.put((Object)PaymentChannelClientState.State.NEW, (Object)PaymentChannelClientState.State.SAVE_STATE_IN_WALLET);
        result.put((Object)PaymentChannelClientState.State.SAVE_STATE_IN_WALLET, (Object)PaymentChannelClientState.State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER);
        result.put((Object)PaymentChannelClientState.State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER, (Object)PaymentChannelClientState.State.READY);
        result.put((Object)PaymentChannelClientState.State.READY, (Object)PaymentChannelClientState.State.EXPIRED);
        result.put((Object)PaymentChannelClientState.State.READY, (Object)PaymentChannelClientState.State.CLOSED);
        return result;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public synchronized void initiate(@Nullable KeyParameter userKey, IPaymentChannelClient.ClientChannelProperties clientChannelProperties) throws ValueOutOfRangeException, InsufficientMoneyException {
        Script redeemScript;
        NetworkParameters params = this.wallet.getParams();
        Transaction template = new Transaction(params);
        TransactionOutput transactionOutput = template.addOutput(this.totalValue, ScriptBuilder.createP2SHOutputScript(redeemScript = ScriptBuilder.createCLTVPaymentChannelOutput(BigInteger.valueOf(this.expiryTime), this.myKey, this.serverKey)));
        if (transactionOutput.isDust()) {
            throw new ValueOutOfRangeException("totalValue too small to use");
        }
        SendRequest req = SendRequest.forTx(template);
        req.coinSelector = AllowUnconfirmedCoinSelector.get();
        req.shuffleOutputs = false;
        req = clientChannelProperties.modifyContractSendRequest(req);
        if (userKey != null) {
            req.aesKey = userKey;
        }
        this.wallet.completeTx(req);
        Coin multisigFee = req.tx.getFee();
        this.contract = req.tx;
        this.refundTx = new Transaction(params);
        this.refundTx.addInput(this.contract.getOutput(0L)).setSequenceNumber(0xFFFFFFFEL);
        this.refundTx.setLockTime(this.expiryTime);
        if (Context.get().isEnsureMinRequiredFee()) {
            Coin valueAfterFee = this.totalValue.subtract(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE);
            if (Transaction.MIN_NONDUST_OUTPUT.compareTo(valueAfterFee) > 0) {
                throw new ValueOutOfRangeException("totalValue too small to use");
            }
            this.refundTx.addOutput(valueAfterFee, this.myKey.toAddress(params));
            this.refundFees = multisigFee.add(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE);
        } else {
            this.refundTx.addOutput(this.totalValue, this.myKey.toAddress(params));
            this.refundFees = multisigFee;
        }
        TransactionSignature refundSignature = this.refundTx.calculateSignature(0, this.myKey.maybeDecrypt(userKey), this.getSignedScript(), Transaction.SigHash.ALL, false);
        this.refundTx.getInput(0L).setScriptSig(ScriptBuilder.createCLTVPaymentChannelP2SHRefund(refundSignature, redeemScript));
        this.refundTx.getConfidence().setSource(TransactionConfidence.Source.SELF);
        log.info("initiated channel with contract {}", (Object)this.contract.getHashAsString());
        this.stateMachine.transition(PaymentChannelClientState.State.SAVE_STATE_IN_WALLET);
    }

    @Override
    protected synchronized Coin getValueToMe() {
        return this.valueToMe;
    }

    @Override
    protected long getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    public synchronized Transaction getContract() {
        Preconditions.checkState((this.contract != null ? 1 : 0) != 0);
        if (this.stateMachine.getState() == PaymentChannelClientState.State.PROVIDE_MULTISIG_CONTRACT_TO_SERVER) {
            this.stateMachine.transition(PaymentChannelClientState.State.READY);
        }
        return this.contract;
    }

    @Override
    protected synchronized Transaction getContractInternal() {
        return this.contract;
    }

    @Override
    protected synchronized Script getContractScript() {
        return this.contract.getOutput(0L).getScriptPubKey();
    }

    @Override
    protected Script getSignedScript() {
        return ScriptBuilder.createCLTVPaymentChannelOutput(BigInteger.valueOf(this.expiryTime), this.myKey, this.serverKey);
    }

    @Override
    public synchronized Coin getRefundTxFees() {
        Preconditions.checkState((this.getState().compareTo(PaymentChannelClientState.State.NEW) > 0 ? 1 : 0) != 0);
        return this.refundFees;
    }

    @Override
    @VisibleForTesting
    Transaction getRefundTransaction() {
        return this.refundTx;
    }

    @Override
    @VisibleForTesting
    synchronized void doStoreChannelInWallet(Sha256Hash id) {
        StoredPaymentChannelClientStates channels = (StoredPaymentChannelClientStates)this.wallet.getExtensions().get(StoredPaymentChannelClientStates.EXTENSION_ID);
        Preconditions.checkNotNull((Object)channels, (Object)"You have not added the StoredPaymentChannelClientStates extension to the wallet.");
        Preconditions.checkState((channels.getChannel(id, this.contract.getHash()) == null ? 1 : 0) != 0);
        this.storedChannel = new StoredClientChannel(this.getMajorVersion(), id, this.contract, this.refundTx, this.myKey, this.serverKey, this.valueToMe, this.refundFees, this.expiryTime, true);
        channels.putChannel(this.storedChannel);
    }

    @Override
    public Coin getTotalValue() {
        return this.totalValue;
    }
}

