/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.protocols.channels;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nullable;
import org.litecoinj.core.Coin;
import org.litecoinj.core.ECKey;
import org.litecoinj.core.Transaction;
import org.litecoinj.core.TransactionBroadcaster;
import org.litecoinj.core.TransactionOutput;
import org.litecoinj.core.VerificationException;
import org.litecoinj.protocols.channels.PaymentChannelServer;
import org.litecoinj.protocols.channels.PaymentChannelServerState;
import org.litecoinj.protocols.channels.PaymentChannelV1ServerState;
import org.litecoinj.protocols.channels.PaymentChannelV2ServerState;
import org.litecoinj.wallet.Wallet;

public class StoredServerChannel {
    int majorVersion;
    Coin bestValueToMe;
    byte[] bestValueSignature;
    long refundTransactionUnlockTimeSecs;
    Transaction contract;
    TransactionOutput clientOutput;
    ECKey myKey;
    ECKey clientKey;
    private PaymentChannelServer connectedHandler = null;
    PaymentChannelServerState state = null;

    StoredServerChannel(@Nullable PaymentChannelServerState state, int majorVersion, Transaction contract, TransactionOutput clientOutput, long refundTransactionUnlockTimeSecs, ECKey myKey, ECKey clientKey, Coin bestValueToMe, @Nullable byte[] bestValueSignature) {
        this.majorVersion = majorVersion;
        this.contract = contract;
        this.clientOutput = clientOutput;
        this.refundTransactionUnlockTimeSecs = refundTransactionUnlockTimeSecs;
        this.myKey = myKey;
        this.clientKey = clientKey;
        this.bestValueToMe = bestValueToMe;
        this.bestValueSignature = bestValueSignature;
        this.state = state;
    }

    synchronized void updateValueToMe(Coin newValue, byte[] newSignature) {
        this.bestValueToMe = newValue;
        this.bestValueSignature = newSignature;
    }

    synchronized PaymentChannelServer setConnectedHandler(PaymentChannelServer connectedHandler, boolean override) {
        if (this.connectedHandler != null && !override) {
            return this.connectedHandler;
        }
        this.connectedHandler = connectedHandler;
        return connectedHandler;
    }

    synchronized void clearConnectedHandler() {
        this.connectedHandler = null;
    }

    synchronized void closeConnectedHandler() {
        if (this.connectedHandler != null) {
            this.connectedHandler.close();
        }
    }

    public synchronized PaymentChannelServerState getOrCreateState(Wallet wallet, TransactionBroadcaster broadcaster) throws VerificationException {
        if (this.state == null) {
            switch (this.majorVersion) {
                case 1: {
                    this.state = new PaymentChannelV1ServerState(this, wallet, broadcaster);
                    break;
                }
                case 2: {
                    this.state = new PaymentChannelV2ServerState(this, wallet, broadcaster);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid version number found");
                }
            }
        }
        Preconditions.checkArgument((wallet == this.state.wallet ? 1 : 0) != 0);
        return this.state;
    }

    public synchronized String toString() {
        String newline = String.format(Locale.US, "%n", new Object[0]);
        return String.format(Locale.US, "Stored server channel (%s)%n    Version:       %d%n    Key:           %s%n    Value to me:   %s%n    Client output: %s%n    Refund unlock: %s (%d unix time)%n    Contract:    %s%n", this.connectedHandler != null ? "connected" : "disconnected", this.majorVersion, this.myKey, this.bestValueToMe, this.clientOutput, new Date(this.refundTransactionUnlockTimeSecs * 1000L), this.refundTransactionUnlockTimeSecs, this.contract.toString().replaceAll(newline, newline + "    "));
    }
}

