/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.wallet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.litecoinj.core.BloomFilter;
import org.litecoinj.core.ECKey;
import org.litecoinj.crypto.EncryptableItem;
import org.litecoinj.crypto.EncryptedData;
import org.litecoinj.crypto.KeyCrypter;
import org.litecoinj.crypto.KeyCrypterException;
import org.litecoinj.crypto.KeyCrypterScrypt;
import org.litecoinj.utils.ListenerRegistration;
import org.litecoinj.utils.Threading;
import org.litecoinj.wallet.EncryptableKeyChain;
import org.litecoinj.wallet.KeyChain;
import org.litecoinj.wallet.Protos;
import org.litecoinj.wallet.UnreadableWalletException;
import org.litecoinj.wallet.listeners.KeyChainEventListener;
import org.spongycastle.crypto.params.KeyParameter;

public class BasicKeyChain
implements EncryptableKeyChain {
    private final ReentrantLock lock = Threading.lock("BasicKeyChain");
    private final LinkedHashMap<ByteString, ECKey> hashToKeys;
    private final LinkedHashMap<ByteString, ECKey> pubkeyToKeys;
    @Nullable
    private final KeyCrypter keyCrypter;
    private boolean isWatching;
    private final CopyOnWriteArrayList<ListenerRegistration<KeyChainEventListener>> listeners;

    public BasicKeyChain() {
        this(null);
    }

    public BasicKeyChain(@Nullable KeyCrypter crypter) {
        this.keyCrypter = crypter;
        this.hashToKeys = new LinkedHashMap();
        this.pubkeyToKeys = new LinkedHashMap();
        this.listeners = new CopyOnWriteArrayList();
    }

    @Override
    @Nullable
    public KeyCrypter getKeyCrypter() {
        this.lock.lock();
        try {
            KeyCrypter keyCrypter = this.keyCrypter;
            return keyCrypter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ECKey getKey(@Nullable KeyChain.KeyPurpose ignored) {
        this.lock.lock();
        try {
            if (this.hashToKeys.isEmpty()) {
                Preconditions.checkState((this.keyCrypter == null ? 1 : 0) != 0);
                ECKey key = new ECKey();
                this.importKeyLocked(key);
                this.queueOnKeysAdded((List<ECKey>)ImmutableList.of((Object)key));
            }
            ECKey eCKey = this.hashToKeys.values().iterator().next();
            return eCKey;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ECKey> getKeys(@Nullable KeyChain.KeyPurpose purpose, int numberOfKeys) {
        Preconditions.checkArgument((numberOfKeys > 0 ? 1 : 0) != 0);
        this.lock.lock();
        try {
            if (this.hashToKeys.size() < numberOfKeys) {
                Preconditions.checkState((this.keyCrypter == null ? 1 : 0) != 0);
                ArrayList<ECKey> keys = new ArrayList<ECKey>();
                for (int i = 0; i < numberOfKeys - this.hashToKeys.size(); ++i) {
                    keys.add(new ECKey());
                }
                ImmutableList immutableKeys = ImmutableList.copyOf(keys);
                this.importKeysLocked((List<ECKey>)immutableKeys);
                this.queueOnKeysAdded((List<ECKey>)immutableKeys);
            }
            ArrayList<ECKey> keysToReturn = new ArrayList<ECKey>();
            for (int count = 0; this.hashToKeys.values().iterator().hasNext() && numberOfKeys != count; ++count) {
                keysToReturn.add(this.hashToKeys.values().iterator().next());
            }
            ArrayList<ECKey> arrayList = keysToReturn;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ECKey> getKeys() {
        this.lock.lock();
        try {
            ArrayList<ECKey> arrayList = new ArrayList<ECKey>(this.hashToKeys.values());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int importKeys(ECKey ... keys) {
        return this.importKeys((List<? extends ECKey>)ImmutableList.copyOf((Object[])keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importKeys(List<? extends ECKey> keys) {
        this.lock.lock();
        try {
            for (ECKey eCKey : keys) {
                this.checkKeyEncryptionStateMatches(eCKey);
            }
            ArrayList<ECKey> actuallyAdded = new ArrayList<ECKey>(keys.size());
            for (ECKey eCKey : keys) {
                if (this.hasKey(eCKey)) continue;
                actuallyAdded.add(eCKey);
                this.importKeyLocked(eCKey);
            }
            if (actuallyAdded.size() > 0) {
                this.queueOnKeysAdded(actuallyAdded);
            }
            int n = actuallyAdded.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkKeyEncryptionStateMatches(ECKey key) {
        if (this.keyCrypter == null && key.isEncrypted()) {
            throw new KeyCrypterException("Key is encrypted but chain is not");
        }
        if (this.keyCrypter != null && !key.isEncrypted()) {
            throw new KeyCrypterException("Key is not encrypted but chain is");
        }
        if (this.keyCrypter != null && key.getKeyCrypter() != null && !key.getKeyCrypter().equals(this.keyCrypter)) {
            throw new KeyCrypterException("Key encrypted under different parameters to chain");
        }
    }

    private void importKeyLocked(ECKey key) {
        if (this.hashToKeys.isEmpty()) {
            this.isWatching = key.isWatching();
        } else {
            if (key.isWatching() && !this.isWatching) {
                throw new IllegalArgumentException("Key is watching but chain is not");
            }
            if (!key.isWatching() && this.isWatching) {
                throw new IllegalArgumentException("Key is not watching but chain is");
            }
        }
        ECKey previousKey = this.pubkeyToKeys.put(ByteString.copyFrom((byte[])key.getPubKey()), key);
        this.hashToKeys.put(ByteString.copyFrom((byte[])key.getPubKeyHash()), key);
        Preconditions.checkState((previousKey == null ? 1 : 0) != 0);
    }

    private void importKeysLocked(List<ECKey> keys) {
        for (ECKey key : keys) {
            this.importKeyLocked(key);
        }
    }

    public void importKey(ECKey key) {
        this.lock.lock();
        try {
            this.checkKeyEncryptionStateMatches(key);
            if (this.hasKey(key)) {
                return;
            }
            this.importKeyLocked(key);
            this.queueOnKeysAdded((List<ECKey>)ImmutableList.of((Object)key));
        }
        finally {
            this.lock.unlock();
        }
    }

    public ECKey findKeyFromPubHash(byte[] pubkeyHash) {
        this.lock.lock();
        try {
            ECKey eCKey = this.hashToKeys.get(ByteString.copyFrom((byte[])pubkeyHash));
            return eCKey;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ECKey findKeyFromPubKey(byte[] pubkey) {
        this.lock.lock();
        try {
            ECKey eCKey = this.pubkeyToKeys.get(ByteString.copyFrom((byte[])pubkey));
            return eCKey;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasKey(ECKey key) {
        return this.findKeyFromPubKey(key.getPubKey()) != null;
    }

    @Override
    public int numKeys() {
        return this.pubkeyToKeys.size();
    }

    public State isWatching() {
        this.lock.lock();
        try {
            if (this.hashToKeys.isEmpty()) {
                State state = State.EMPTY;
                return state;
            }
            State state = this.isWatching ? State.WATCHING : State.REGULAR;
            return state;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(ECKey key) {
        this.lock.lock();
        try {
            boolean a = this.hashToKeys.remove(ByteString.copyFrom((byte[])key.getPubKeyHash())) != null;
            boolean b = this.pubkeyToKeys.remove(ByteString.copyFrom((byte[])key.getPubKey())) != null;
            Preconditions.checkState((a == b ? 1 : 0) != 0);
            boolean bl = a;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEarliestKeyCreationTime() {
        this.lock.lock();
        try {
            long time = Long.MAX_VALUE;
            for (ECKey key : this.hashToKeys.values()) {
                time = Math.min(key.getCreationTimeSeconds(), time);
            }
            long l = time;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ListenerRegistration<KeyChainEventListener>> getListeners() {
        return new ArrayList<ListenerRegistration<KeyChainEventListener>>(this.listeners);
    }

    Map<ECKey, Protos.Key.Builder> serializeToEditableProtobufs() {
        LinkedHashMap<ECKey, Protos.Key.Builder> result = new LinkedHashMap<ECKey, Protos.Key.Builder>();
        for (ECKey ecKey : this.hashToKeys.values()) {
            Protos.Key.Builder protoKey = BasicKeyChain.serializeEncryptableItem(ecKey);
            protoKey.setPublicKey(ByteString.copyFrom((byte[])ecKey.getPubKey()));
            result.put(ecKey, protoKey);
        }
        return result;
    }

    @Override
    public List<Protos.Key> serializeToProtobuf() {
        Collection<Protos.Key.Builder> builders = this.serializeToEditableProtobufs().values();
        ArrayList<Protos.Key> result = new ArrayList<Protos.Key>(builders.size());
        for (Protos.Key.Builder builder : builders) {
            result.add(builder.build());
        }
        return result;
    }

    static Protos.Key.Builder serializeEncryptableItem(EncryptableItem item) {
        Protos.Key.Builder proto = Protos.Key.newBuilder();
        proto.setCreationTimestamp(item.getCreationTimeSeconds() * 1000L);
        if (item.isEncrypted() && item.getEncryptedData() != null) {
            EncryptedData data = item.getEncryptedData();
            proto.getEncryptedDataBuilder().setEncryptedPrivateKey(ByteString.copyFrom((byte[])data.encryptedBytes)).setInitialisationVector(ByteString.copyFrom((byte[])data.initialisationVector));
            Preconditions.checkState((item.getEncryptionType() == Protos.Wallet.EncryptionType.ENCRYPTED_SCRYPT_AES ? 1 : 0) != 0);
            proto.setType(Protos.Key.Type.ENCRYPTED_SCRYPT_AES);
        } else {
            byte[] secret = item.getSecretBytes();
            if (secret != null) {
                proto.setSecretBytes(ByteString.copyFrom((byte[])secret));
            }
            proto.setType(Protos.Key.Type.ORIGINAL);
        }
        return proto;
    }

    public static BasicKeyChain fromProtobufUnencrypted(List<Protos.Key> keys) throws UnreadableWalletException {
        BasicKeyChain chain = new BasicKeyChain();
        chain.deserializeFromProtobuf(keys);
        return chain;
    }

    public static BasicKeyChain fromProtobufEncrypted(List<Protos.Key> keys, KeyCrypter crypter) throws UnreadableWalletException {
        BasicKeyChain chain = new BasicKeyChain((KeyCrypter)Preconditions.checkNotNull((Object)crypter));
        chain.deserializeFromProtobuf(keys);
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserializeFromProtobuf(List<Protos.Key> keys) throws UnreadableWalletException {
        this.lock.lock();
        try {
            Preconditions.checkState((boolean)this.hashToKeys.isEmpty(), (Object)"Tried to deserialize into a non-empty chain");
            for (Protos.Key key : keys) {
                ECKey ecKey;
                byte[] priv;
                if (key.getType() != Protos.Key.Type.ORIGINAL && key.getType() != Protos.Key.Type.ENCRYPTED_SCRYPT_AES) continue;
                boolean encrypted = key.getType() == Protos.Key.Type.ENCRYPTED_SCRYPT_AES;
                byte[] byArray = priv = key.hasSecretBytes() ? key.getSecretBytes().toByteArray() : null;
                if (!key.hasPublicKey()) {
                    throw new UnreadableWalletException("Public key missing");
                }
                byte[] pub = key.getPublicKey().toByteArray();
                if (encrypted) {
                    Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"This wallet is encrypted but encrypt() was not called prior to deserialization");
                    if (!key.hasEncryptedData()) {
                        throw new UnreadableWalletException("Encrypted private key data missing");
                    }
                    Protos.EncryptedData proto = key.getEncryptedData();
                    EncryptedData e = new EncryptedData(proto.getInitialisationVector().toByteArray(), proto.getEncryptedPrivateKey().toByteArray());
                    ecKey = ECKey.fromEncrypted(e, this.keyCrypter, pub);
                } else {
                    ecKey = priv != null ? ECKey.fromPrivateAndPrecalculatedPublic(priv, pub) : ECKey.fromPublicOnly(pub);
                }
                ecKey.setCreationTimeSeconds(key.getCreationTimestamp() / 1000L);
                this.importKeyLocked(ecKey);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addEventListener(KeyChainEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    @Override
    public void addEventListener(KeyChainEventListener listener, Executor executor) {
        this.listeners.add(new ListenerRegistration<KeyChainEventListener>(listener, executor));
    }

    @Override
    public boolean removeEventListener(KeyChainEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.listeners);
    }

    private void queueOnKeysAdded(final List<ECKey> keys) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<KeyChainEventListener> registration : this.listeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((KeyChainEventListener)registration.listener).onKeysAdded(keys);
                }
            });
        }
    }

    @Override
    public BasicKeyChain toEncrypted(CharSequence password) {
        Preconditions.checkNotNull((Object)password);
        Preconditions.checkArgument((password.length() > 0 ? 1 : 0) != 0);
        KeyCrypterScrypt scrypt = new KeyCrypterScrypt();
        KeyParameter derivedKey = scrypt.deriveKey(password);
        return this.toEncrypted(scrypt, derivedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicKeyChain toEncrypted(KeyCrypter keyCrypter, KeyParameter aesKey) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)keyCrypter);
            Preconditions.checkState((this.keyCrypter == null ? 1 : 0) != 0, (Object)"Key chain is already encrypted");
            BasicKeyChain encrypted = new BasicKeyChain(keyCrypter);
            for (ECKey key : this.hashToKeys.values()) {
                ECKey encryptedKey;
                if (!ECKey.encryptionIsReversible(key, encryptedKey = key.encrypt(keyCrypter, aesKey), keyCrypter, aesKey)) {
                    throw new KeyCrypterException("The key " + key.toString() + " cannot be successfully decrypted after encryption so aborting wallet encryption.");
                }
                encrypted.importKeyLocked(encryptedKey);
            }
            BasicKeyChain basicKeyChain = encrypted;
            return basicKeyChain;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public BasicKeyChain toDecrypted(CharSequence password) {
        Preconditions.checkNotNull((Object)this.keyCrypter, (Object)"Wallet is already decrypted");
        KeyParameter aesKey = this.keyCrypter.deriveKey(password);
        return this.toDecrypted(aesKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicKeyChain toDecrypted(KeyParameter aesKey) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Wallet is already decrypted");
            if (this.numKeys() > 0 && !this.checkAESKey(aesKey)) {
                throw new KeyCrypterException("Password/key was incorrect.");
            }
            BasicKeyChain decrypted = new BasicKeyChain();
            for (ECKey key : this.hashToKeys.values()) {
                decrypted.importKeyLocked(key.decrypt(aesKey));
            }
            BasicKeyChain basicKeyChain = decrypted;
            return basicKeyChain;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean checkPassword(CharSequence password) {
        Preconditions.checkNotNull((Object)password);
        Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Key chain not encrypted");
        return this.checkAESKey(this.keyCrypter.deriveKey(password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAESKey(KeyParameter aesKey) {
        this.lock.lock();
        try {
            if (this.hashToKeys.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Key chain is not encrypted");
            ECKey first = null;
            for (ECKey key : this.hashToKeys.values()) {
                if (!key.isEncrypted()) continue;
                first = key;
                break;
            }
            Preconditions.checkState((first != null ? 1 : 0) != 0, (Object)"No encrypted keys in the wallet");
            try {
                ECKey rebornKey = first.decrypt(aesKey);
                boolean bl = Arrays.equals(first.getPubKey(), rebornKey.getPubKey());
                return bl;
            }
            catch (KeyCrypterException e) {
                boolean bl = false;
                this.lock.unlock();
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BloomFilter getFilter(int size, double falsePositiveRate, long tweak) {
        this.lock.lock();
        try {
            BloomFilter filter = new BloomFilter(size, falsePositiveRate, tweak);
            for (ECKey key : this.hashToKeys.values()) {
                filter.insert(key);
            }
            BloomFilter bloomFilter = filter;
            return bloomFilter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int numBloomFilterEntries() {
        return this.numKeys() * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ECKey findOldestKeyAfter(long timeSecs) {
        this.lock.lock();
        try {
            ECKey oldest = null;
            for (ECKey key : this.hashToKeys.values()) {
                long keyTime = key.getCreationTimeSeconds();
                if (keyTime <= timeSecs || oldest != null && oldest.getCreationTimeSeconds() <= keyTime) continue;
                oldest = key;
            }
            Iterator<ECKey> iterator = oldest;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ECKey> findKeysBefore(long timeSecs) {
        this.lock.lock();
        try {
            LinkedList results = Lists.newLinkedList();
            for (ECKey key : this.hashToKeys.values()) {
                long keyTime = key.getCreationTimeSeconds();
                if (keyTime >= timeSecs) continue;
                results.add(key);
            }
            LinkedList linkedList = results;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static enum State {
        EMPTY,
        WATCHING,
        REGULAR;

    }
}

