/*
 * Decompiled with CFR 0.152.
 */
package org.litecoinj.wallet;

import org.litecoinj.crypto.DeterministicKey;
import org.litecoinj.crypto.HDUtils;
import org.litecoinj.crypto.KeyCrypter;
import org.litecoinj.wallet.DeterministicKeyChain;
import org.litecoinj.wallet.DeterministicSeed;
import org.litecoinj.wallet.KeyChainFactory;
import org.litecoinj.wallet.MarriedKeyChain;
import org.litecoinj.wallet.Protos;
import org.litecoinj.wallet.UnreadableWalletException;

public class DefaultKeyChainFactory
implements KeyChainFactory {
    @Override
    public DeterministicKeyChain makeKeyChain(Protos.Key key, Protos.Key firstSubKey, DeterministicSeed seed, KeyCrypter crypter, boolean isMarried) {
        DeterministicKeyChain chain = isMarried ? new MarriedKeyChain(seed, crypter) : new DeterministicKeyChain(seed, crypter);
        return chain;
    }

    @Override
    public DeterministicKeyChain makeWatchingKeyChain(Protos.Key key, Protos.Key firstSubKey, DeterministicKey accountKey, boolean isFollowingKey, boolean isMarried) throws UnreadableWalletException {
        if (!accountKey.getPath().equals(DeterministicKeyChain.ACCOUNT_ZERO_PATH)) {
            throw new UnreadableWalletException("Expecting account key but found key with path: " + HDUtils.formatPath(accountKey.getPath()));
        }
        DeterministicKeyChain chain = isMarried ? new MarriedKeyChain(accountKey) : new DeterministicKeyChain(accountKey, isFollowingKey);
        return chain;
    }
}

