/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.filter;

import com.aqmd.netty.annotation.HawkFilterValue;
import com.aqmd.netty.annotation.HawkMethodHandler;
import com.aqmd.netty.common.constant.NettyResponseCode;
import com.aqmd.netty.entity.RequestPacket;
import com.aqmd.netty.entity.ResponsePacket;
import com.aqmd.netty.exception.NettyException;
import com.aqmd.netty.filter.FilterChain;
import com.aqmd.netty.filter.HFilter;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;

public class DefaultFilterChain
implements FilterChain {
    private List<HawkFilterValue> filters = new ArrayList<HawkFilterValue>();
    private HawkMethodHandler handler;
    private int _iter = 0;
    private boolean handlerExecFlag = false;

    public DefaultFilterChain(TreeSet<HawkFilterValue> treeFilters, HawkMethodHandler handler) {
        this.handler = handler;
        for (HawkFilterValue filterValue : treeFilters) {
            this.filters.add(filterValue);
        }
    }

    @Override
    public void doFilter(RequestPacket request, ResponsePacket response, ChannelHandlerContext ctx) {
        if (CollectionUtils.isEmpty(this.filters)) {
            if (this.handler == null) {
                throw new NettyException(NettyResponseCode.NO_HANDLER_ERROR.getResponseCode() + "~" + NettyResponseCode.NO_HANDLER_ERROR.getResponseMessage());
            }
            this.handler.doInvoke(request, response, ctx);
            this.handlerExecFlag = true;
            return;
        }
        try {
            while (this._iter < this.filters.size()) {
                HawkFilterValue filterValue = this.filters.get(this._iter);
                if (filterValue.getHfilter().isMatch(request)) {
                    ++this._iter;
                    HFilter hFilter = filterValue.getHfilter();
                    hFilter.doFilter(request, response, ctx, this);
                    break;
                }
                ++this._iter;
            }
            if (this._iter == this.filters.size() && !this.handlerExecFlag) {
                this.handler.doInvoke(request, response, ctx);
                this.handlerExecFlag = true;
            }
        }
        catch (IOException e) {
            throw new NettyException(NettyResponseCode.FILTER_IO_ERROR.getResponseCode() + "~" + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NettyException(NettyResponseCode.UNKNOW_ERROR.getResponseCode() + "~" + NettyResponseCode.UNKNOW_ERROR.getResponseMessage());
        }
    }
}

