/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.filter;

import com.aqmd.netty.annotation.HawkFilter;
import com.aqmd.netty.entity.RequestPacket;
import com.aqmd.netty.entity.ResponsePacket;
import com.aqmd.netty.exception.NettyException;
import com.aqmd.netty.filter.FilterChain;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;

public abstract class HFilter {
    public abstract void init() throws NettyException;

    public abstract void doFilter(RequestPacket var1, ResponsePacket var2, ChannelHandlerContext var3, FilterChain var4) throws IOException, NettyException;

    public abstract void destroy();

    protected String buildExceptionMsg(int code, String message) {
        return code + "~" + message;
    }

    public boolean isMatch(RequestPacket req) {
        HawkFilter hawkFilter = this.getClass().getAnnotation(HawkFilter.class);
        for (int cmd : hawkFilter.ignoreCmds()) {
            if (cmd != req.getCmd()) continue;
            return false;
        }
        for (int cmd : hawkFilter.cmds()) {
            if (cmd != req.getCmd()) continue;
            return true;
        }
        return true;
    }
}

