/*
 * Decompiled with CFR 0.152.
 */
package com.spark.blockchain.rpcclient;

import com.spark.blockchain.rpcclient.BitcoinException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface Bitcoin {
    public void addNode(String var1, AddNoteCmd var2) throws BitcoinException;

    public String createRawTransaction(List<TxInput> var1, List<TxOutput> var2) throws BitcoinException;

    public RawTransaction decodeRawTransaction(String var1) throws BitcoinException;

    public String dumpPrivKey(String var1) throws BitcoinException;

    public String getAccount(String var1) throws BitcoinException;

    public String getAccountAddress(String var1) throws BitcoinException;

    public List<String> getAddressesByAccount(String var1) throws BitcoinException;

    public double getBalance() throws BitcoinException;

    public double getBalance(String var1) throws BitcoinException;

    public double getBalance(String var1, int var2) throws BitcoinException;

    public Block getBlock(String var1) throws BitcoinException;

    public int getBlockCount() throws BitcoinException;

    public String getBlockHash(int var1) throws BitcoinException;

    public int getConnectionCount() throws BitcoinException;

    public double getDifficulty() throws BitcoinException;

    public boolean getGenerate() throws BitcoinException;

    public double getHashesPerSec() throws BitcoinException;

    public Info getInfo() throws BitcoinException;

    public MiningInfo getMiningInfo() throws BitcoinException;

    public String getNewAddress() throws BitcoinException;

    public String getNewAddress(String var1) throws BitcoinException;

    public PeerInfo getPeerInfo() throws BitcoinException;

    public String getRawTransactionHex(String var1) throws BitcoinException;

    public RawTransaction getRawTransaction(String var1) throws BitcoinException;

    public double getReceivedByAccount(String var1) throws BitcoinException;

    public double getReceivedByAccount(String var1, int var2) throws BitcoinException;

    public double getReceivedByAddress(String var1) throws BitcoinException;

    public double getReceivedByAddress(String var1, int var2) throws BitcoinException;

    public RawTransaction getTransaction(String var1) throws BitcoinException;

    public TxOutSetInfo getTxOutSetInfo() throws BitcoinException;

    public Work getWork() throws BitcoinException;

    public void importPrivKey(String var1) throws BitcoinException;

    public void importPrivKey(String var1, String var2) throws BitcoinException;

    public void importPrivKey(String var1, String var2, boolean var3) throws BitcoinException;

    public Map<String, Number> listAccounts() throws BitcoinException;

    public Map<String, Number> listAccounts(int var1) throws BitcoinException;

    public List<ReceivedAddress> listReceivedByAccount() throws BitcoinException;

    public List<ReceivedAddress> listReceivedByAccount(int var1) throws BitcoinException;

    public List<ReceivedAddress> listReceivedByAccount(int var1, boolean var2) throws BitcoinException;

    public List<ReceivedAddress> listReceivedByAddress() throws BitcoinException;

    public List<ReceivedAddress> listReceivedByAddress(int var1) throws BitcoinException;

    public List<ReceivedAddress> listReceivedByAddress(int var1, boolean var2) throws BitcoinException;

    public TransactionsSinceBlock listSinceBlock() throws BitcoinException;

    public TransactionsSinceBlock listSinceBlock(String var1) throws BitcoinException;

    public TransactionsSinceBlock listSinceBlock(String var1, int var2) throws BitcoinException;

    public List<Transaction> listTransactions() throws BitcoinException;

    public List<Transaction> listTransactions(String var1) throws BitcoinException;

    public List<Transaction> listTransactions(String var1, int var2) throws BitcoinException;

    public List<Transaction> listTransactions(String var1, int var2, int var3) throws BitcoinException;

    public List<Unspent> listUnspent() throws BitcoinException;

    public List<Unspent> listUnspent(int var1) throws BitcoinException;

    public List<Unspent> listUnspent(int var1, int var2) throws BitcoinException;

    public List<Unspent> listUnspent(int var1, int var2, String ... var3) throws BitcoinException;

    public String sendFrom(String var1, String var2, double var3) throws BitcoinException;

    public String sendFrom(String var1, String var2, double var3, int var5) throws BitcoinException;

    public String sendFrom(String var1, String var2, double var3, int var5, String var6) throws BitcoinException;

    public String sendFrom(String var1, String var2, double var3, int var5, String var6, String var7) throws BitcoinException;

    public String sendMany(String var1, List<TxOutput> var2) throws BitcoinException;

    public String sendMany(String var1, List<TxOutput> var2, int var3) throws BitcoinException;

    public String sendMany(String var1, List<TxOutput> var2, int var3, String var4) throws BitcoinException;

    public String sendRawTransaction(String var1) throws BitcoinException;

    public String sendToAddress(String var1, double var2) throws BitcoinException;

    public String sendToAddress(String var1, double var2, String var4) throws BitcoinException;

    public Boolean setTxFee(double var1) throws BitcoinException;

    public String sendToAddress(String var1, double var2, String var4, String var5) throws BitcoinException;

    public String signMessage(String var1, String var2) throws BitcoinException;

    public String signRawTransaction(String var1) throws BitcoinException;

    public void stop() throws BitcoinException;

    public AddressValidationResult validateAddress(String var1) throws BitcoinException;

    public boolean verifyMessage(String var1, String var2, String var3) throws BitcoinException;

    public static interface AddressValidationResult {
        public boolean isValid();

        public String address();

        public boolean isMine();

        public boolean isScript();

        public String pubKey();

        public boolean isCompressed();

        public String account();
    }

    public static interface Unspent
    extends TxInput,
    TxOutput {
        @Override
        public String txid();

        @Override
        public int vout();

        @Override
        public String address();

        public String account();

        public String scriptPubKey();

        @Override
        public BigDecimal amount();

        public int confirmations();
    }

    public static interface TransactionsSinceBlock {
        public List<Transaction> transactions();

        public String lastBlock();
    }

    public static interface Transaction {
        public String account();

        public String address();

        public String category();

        public double amount();

        public double fee();

        public int confirmations();

        public String blockHash();

        public int blockIndex();

        public Date blockTime();

        public String txId();

        public Date time();

        public Date timeReceived();

        public String comment();

        public String commentTo();

        public RawTransaction raw();
    }

    public static interface ReceivedAddress {
        public String address();

        public String account();

        public double amount();

        public int confirmations();
    }

    public static interface Work {
        public String midstate();

        public String data();

        public String hash1();

        public String target();
    }

    public static interface TxOutSetInfo {
        public int height();

        public String bestBlock();

        public int transactions();

        public int txOuts();

        public int bytesSerialized();

        public String hashSerialized();

        public double totalAmount();
    }

    public static interface RawTransaction {
        public String hex();

        public String txId();

        public int version();

        public long lockTime();

        public List<In> vIn();

        public List<Out> vOut();

        public String blockHash();

        public int confirmations();

        public Date time();

        public Date blocktime();

        public static interface Out {
            public double value();

            public int n();

            public ScriptPubKey scriptPubKey();

            public TxInput toInput();

            public RawTransaction transaction();

            public static interface ScriptPubKey {
                public String asm();

                public String hex();

                public int reqSigs();

                public String type();

                public List<String> addresses();
            }
        }

        public static interface In
        extends TxInput {
            public Map<String, Object> scriptSig();

            public long sequence();

            public RawTransaction getTransaction();

            public Out getTransactionOutput();
        }
    }

    public static interface PeerInfo {
        public String addr();

        public String services();

        public int lastsend();

        public int lastrecv();

        public int bytessent();

        public int bytesrecv();

        public int blocksrequested();

        public Date conntime();

        public int version();

        public String subver();

        public boolean inbound();

        public int startingheight();

        public int banscore();
    }

    public static interface MiningInfo {
        public int blocks();

        public int currentblocksize();

        public int currentblocktx();

        public double difficulty();

        public String errors();

        public int genproclimit();

        public double networkhashps();

        public int pooledtx();

        public boolean testnet();

        public String chain();

        public boolean generate();
    }

    public static interface Info {
        public int version();

        public int protocolversion();

        public int walletversion();

        public double balance();

        public int blocks();

        public int timeoffset();

        public int connections();

        public String proxy();

        public double difficulty();

        public boolean testnet();

        public int keypoololdest();

        public int keypoolsize();

        public int unlocked_until();

        public double paytxfee();

        public double relayfee();

        public String errors();
    }

    public static interface Block {
        public String hash();

        public int confirmations();

        public int size();

        public int height();

        public int version();

        public String merkleRoot();

        public List<String> tx();

        public Date time();

        public long nonce();

        public String bits();

        public double difficulty();

        public String previousHash();

        public String nextHash();

        public Block previous() throws BitcoinException;

        public Block next() throws BitcoinException;
    }

    public static class BasicTxOutput
    implements TxOutput {
        public String address;
        public BigDecimal amount;

        public BasicTxOutput(String address, BigDecimal amount) {
            this.address = address;
            this.amount = amount;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public BigDecimal amount() {
            return this.amount;
        }
    }

    public static interface TxOutput {
        public String address();

        public BigDecimal amount();
    }

    public static class BasicTxInput
    implements TxInput {
        public String txid;
        public int vout;

        public BasicTxInput(String txid, int vout) {
            this.txid = txid;
            this.vout = vout;
        }

        @Override
        public String txid() {
            return this.txid;
        }

        @Override
        public int vout() {
            return this.vout;
        }
    }

    public static interface TxInput {
        public String txid();

        public int vout();
    }

    public static enum AddNoteCmd {
        add,
        remove,
        onetry;

    }
}

