/*
 * Decompiled with CFR 0.152.
 */
package com.spark.blockchain.rpcclient;

import com.spark.blockchain.rpcclient.Bitcoin;
import com.spark.blockchain.rpcclient.SimpleBitcoinPaymentListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ConfirmedPaymentListener
extends SimpleBitcoinPaymentListener {
    public int minConf;
    protected Set<String> processed = Collections.synchronizedSet(new HashSet());

    public ConfirmedPaymentListener(int minConf) {
        this.minConf = minConf;
    }

    public ConfirmedPaymentListener() {
        this(6);
    }

    protected boolean markProcess(String txId) {
        return this.processed.add(txId);
    }

    @Override
    public void transaction(Bitcoin.Transaction transaction) {
        if (transaction.confirmations() < this.minConf) {
            return;
        }
        if (!this.markProcess(transaction.txId() + "-" + transaction.address())) {
            return;
        }
        this.confirmed(transaction);
    }

    public abstract void confirmed(Bitcoin.Transaction var1);
}

