/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.LogEntry;
import sqlj.mesg.ProfilePrinterErrors;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.TypeInfo;
import sqlj.runtime.profile.util.CustomizerHarness;
import sqlj.runtime.profile.util.ProfileCustomizer;

public class ProfilePrinter
implements ProfileCustomizer {
    private PrintWriter m_out;
    private static final String m_banner = ProfilePrinterErrors.banner();

    public static void main(String[] stringArray) {
        System.exit(ProfilePrinter.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "-customizer=sqlj.runtime.profile.util.ProfilePrinter";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return CustomizerHarness.mainStatus(stringArray2);
    }

    @Override
    public boolean acceptsConnection(Connection connection) {
        return connection == null;
    }

    @Override
    public boolean customize(Profile profile, Connection connection, ErrorLog errorLog) {
        String string = errorLog.getFileName();
        errorLog.setFileName(null);
        PrintWriter printWriter = this.m_out;
        this.setOutput(new PrintLog(errorLog));
        this.print(profile);
        this.setOutput(printWriter);
        errorLog.setFileName(string);
        return false;
    }

    public ProfilePrinter() {
        this(new PrintWriter(System.out));
    }

    public ProfilePrinter(PrintWriter printWriter) {
        this.setOutput(printWriter);
    }

    private void banner() {
        this.m_out.println(m_banner);
    }

    public void setOutput(PrintWriter printWriter) {
        this.m_out = printWriter;
    }

    public void print(Profile profile) {
        this.banner();
        this.m_out.println(ProfilePrinterErrors.printing_profile((String)profile.getProfileName()));
        this.m_out.println(ProfilePrinterErrors.creation_time((long)profile.getTimestamp(), (Date)new Date(profile.getTimestamp())));
        this.m_out.println(ProfilePrinterErrors.context((String)profile.getContextName()));
        this.m_out.println(ProfilePrinterErrors.loader((String)(profile.getLoader() + "")));
        int n2 = 0;
        Enumeration enumeration = profile.getCustomizations();
        while (enumeration.hasMoreElements()) {
            ++n2;
            enumeration.nextElement();
        }
        this.m_out.println(ProfilePrinterErrors.customization_count((int)n2));
        enumeration = profile.getCustomizations();
        while (enumeration.hasMoreElements()) {
            this.m_out.println(enumeration.nextElement());
        }
        this.print(profile.getProfileData());
    }

    public void print(ProfileData profileData) {
        int n2 = profileData.size();
        this.m_out.println(ProfilePrinterErrors.source_file((String)(profileData.getSourceFile() + "")));
        this.m_out.println(ProfilePrinterErrors.entry_count((int)n2));
        this.banner();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.print(profileData, i2);
            this.banner();
        }
        this.m_out.flush();
    }

    public void print(ProfileData profileData, int n2) {
        EntryInfo entryInfo = profileData.getEntryInfo(n2);
        this.m_out.println(ProfilePrinterErrors.profile_entry((String)profileData.getProfile().getProfileName(), (int)n2));
        this.print(profileData, entryInfo);
    }

    public void print(ProfileData profileData, EntryInfo entryInfo) {
        int n2;
        this.m_out.println("#sql { " + entryInfo.getSQLString() + " };");
        this.m_out.println(ProfilePrinterErrors.line_number((int)entryInfo.getLineNumber()));
        this.m_out.println(ProfilePrinterErrors.stmt_and_exec_type((String)EntryInfo.statementTypeToString(entryInfo.getStatementType()), (String)EntryInfo.executeTypeToString(entryInfo.getExecuteType())));
        this.m_out.println(ProfilePrinterErrors.role((String)EntryInfo.roleToString(entryInfo.getRole())));
        this.printDescriptor(entryInfo.getDescriptor());
        int n3 = entryInfo.getParamCount();
        this.m_out.println(ProfilePrinterErrors.param_count((int)n3));
        for (n2 = 1; n2 <= n3; ++n2) {
            this.print(profileData, entryInfo.getParamInfo(n2), n2);
        }
        this.m_out.println(ProfilePrinterErrors.result_type((String)EntryInfo.resultSetTypeToString(entryInfo.getResultSetType())));
        this.m_out.println(ProfilePrinterErrors.result_name((String)(entryInfo.getResultSetName() + "")));
        n2 = entryInfo.getResultSetCount();
        this.m_out.println(ProfilePrinterErrors.result_count((int)n2));
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.print(profileData, entryInfo.getResultSetInfo(i2), i2);
        }
    }

    private void printDescriptor(Object object) {
        this.m_out.println(ProfilePrinterErrors.descriptor((String)(object + "")));
    }

    public void print(ProfileData profileData, TypeInfo typeInfo, int n2) {
        Profile profile = profileData.getProfile();
        this.m_out.println(ProfilePrinterErrors.type_info((int)n2, (String)TypeInfo.modeToString(typeInfo.getMode()), (String)typeInfo.getJavaTypeName(), (String)profile.getJavaType(typeInfo).getName()));
        this.m_out.println(ProfilePrinterErrors.type_info((String)TypeInfo.SQLTypeToString(typeInfo.getSQLType()), (String)(typeInfo.getName() + ""), (int)typeInfo.getMarkerIndex()));
        this.m_out.flush();
    }

    private static class PrintLog
    extends PrintWriter {
        private StringLog m_log;

        PrintLog(ErrorLog errorLog) {
            this(new StringLog(errorLog));
        }

        private PrintLog(StringLog stringLog) {
            super(stringLog);
            this.m_log = stringLog;
        }

        @Override
        public void println(String string) {
            super.print(string);
            this.m_log.addLogEntry();
        }
    }

    private static class StringLog
    extends StringWriter {
        private ErrorLog m_log;

        StringLog(ErrorLog errorLog) {
            this.m_log = errorLog;
        }

        public void addLogEntry() {
            this.m_log.addEntry((LogEntry)new SilentInfo(this.toString()));
            this.getBuffer().setLength(0);
        }
    }

    private static class SilentInfo
    extends Info {
        SilentInfo(Object object) {
            super(object);
            this.prefix = null;
        }
    }
}

