#ifndef __UISHADOW_H__
#define __UISHADOW_H__

#pragma once
#include <map>

namespace DuiLib
{

class UILIB_API CShadowUI
{
public:
	friend class CPaintManagerUI;

	CShadowUI(void);
	virtual ~CShadowUI(void);

public:
	// bShowΪʱŻᴴӰ
	void ShowShadow(bool bShow);	
	bool IsShowShadow() const;

	void DisableShadow(bool bDisable);
	bool IsDisableShadow() const;

	// 㷨Ӱĺ
	bool SetSize(int NewSize = 0);
	bool SetSharpness(unsigned int NewSharpness = 5);
	bool SetDarkness(unsigned int NewDarkness = 200);
	bool SetPosition(int NewXOffset = 5, int NewYOffset = 5);
	bool SetColor(COLORREF NewColor = 0);

	// ͼƬӰĺ
	bool SetImage(LPCTSTR szImage);
	bool SetShadowCorner(RECT rcCorner);	// ŹʽӰ
	
	// ԼӰʽƵ
	bool CopyShadow(CShadowUI* pShadow);

	//	Ӱ壬CPaintManagerUIԶ,ԼҪӰ
	void Create(CPaintManagerUI* pPaintManager);
protected:

	//	ʼעӰ
	static bool Initialize(HINSTANCE hInstance);

	// ѾӵĴӰ,ParentProc()ͨõӰ
	static std::map<HWND, CShadowUI *>& GetShadowMap();

	//	໯
	static LRESULT CALLBACK ParentProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

	// ıСƶػӰʱ
	void Update(HWND hParent);

	// ͨ㷨Ӱ
	void MakeShadow(UINT32 *pShadBits, HWND hParent, RECT *rcParent);

	// alphaԤֵ
	inline DWORD PreMultiply(COLORREF cl, unsigned char nAlpha)
	{
		return (GetRValue(cl) * (DWORD)nAlpha / 255) |
			(GetGValue(cl) * (DWORD)nAlpha / 255) << 8 |
			(GetBValue(cl) * (DWORD)nAlpha / 255) << 16 ;
	}

protected:
	enum ShadowStatus
	{
		SS_ENABLED = 1,				// Shadow is enabled, if not, the following one is always false
		SS_VISABLE = 1 << 1,		// Shadow window is visible
		SS_PARENTVISIBLE = 1<< 2	// Parent window is visible, if not, the above one is always false
	};

	
	static bool s_bHasInit;

	CPaintManagerUI	*m_pManager;		// CPaintManagerUIȡزԴ͸
	HWND			 m_hWnd;			// Ӱľ
	LONG_PTR		 m_OriParentProc;	// ໯
	BYTE			 m_Status;
	bool			 m_bIsImageMode;	// ǷΪͼƬӰģʽ
	bool			 m_bIsShowShadow;	// ǷҪʾӰ
	bool			m_bIsDisableShadow;
	// 㷨ӰԱ
	unsigned char m_nDarkness;	// Darkness, transparency of blurred area
	unsigned char m_nSharpness;	// Sharpness, width of blurred border of shadow window
	signed char m_nSize;	// Shadow window size, relative to parent window size

	// The X and Y offsets of shadow window,
	// relative to the parent window, at center of both windows (not top-left corner), signed
	signed char m_nxOffset;
	signed char m_nyOffset;

	// Restore last parent window size, used to determine the update strategy when parent window is resized
	LPARAM m_WndSize;

	// Set this to true if the shadow should not be update until next WM_PAINT is received
	bool m_bUpdate;

	COLORREF m_Color;	// Color of shadow

	// ͼƬӰԱ
	CDuiString	m_sShadowImage;
	RECT		m_rcShadowCorner;
};

}

#endif //__UISHADOW_H__