/*
	Apache License
	Version 2.0, January 2004
	http://www.apache.org/licenses/
	
	TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
	
	1. Definitions.
	
	"License" shall mean the terms and conditions for use, reproduction, and
	distribution as defined by Sections 1 through 9 of this document.
	
	"Licensor" shall mean the copyright owner or entity authorized by the copyright
	owner that is granting the License.
	
	"Legal Entity" shall mean the union of the acting entity and all other entities
	that control, are controlled by, or are under common control with that entity.
	For the purposes of this definition, "control" means (i) the power, direct or
	indirect, to cause the direction or management of such entity, whether by
	contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
	outstanding shares, or (iii) beneficial ownership of such entity.
	
	"You" (or "Your") shall mean an individual or Legal Entity exercising
	permissions granted by this License.
	
	"Source" form shall mean the preferred form for making modifications, including
	but not limited to software source code, documentation source, and configuration
	files.
	
	"Object" form shall mean any form resulting from mechanical transformation or
	translation of a Source form, including but not limited to compiled object code,
	generated documentation, and conversions to other media types.
	
	"Work" shall mean the work of authorship, whether in Source or Object form, made
	available under the License, as indicated by a copyright notice that is included
	in or attached to the work (an example is provided in the Appendix below).
	
	"Derivative Works" shall mean any work, whether in Source or Object form, that
	is based on (or derived from) the Work and for which the editorial revisions,
	annotations, elaborations, or other modifications represent, as a whole, an
	original work of authorship. For the purposes of this License, Derivative Works
	shall not include works that remain separable from, or merely link (or bind by
	name) to the interfaces of, the Work and Derivative Works thereof.
	
	"Contribution" shall mean any work of authorship, including the original version
	of the Work and any modifications or additions to that Work or Derivative Works
	thereof, that is intentionally submitted to Licensor for inclusion in the Work
	by the copyright owner or by an individual or Legal Entity authorized to submit
	on behalf of the copyright owner. For the purposes of this definition,
	"submitted" means any form of electronic, verbal, or written communication sent
	to the Licensor or its representatives, including but not limited to
	communication on electronic mailing lists, source code control systems, and
	issue tracking systems that are managed by, or on behalf of, the Licensor for
	the purpose of discussing and improving the Work, but excluding communication
	that is conspicuously marked or otherwise designated in writing by the copyright
	owner as "Not a Contribution."
	
	"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
	of whom a Contribution has been received by Licensor and subsequently
	incorporated within the Work.
	
	2. Grant of Copyright License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable copyright license to reproduce, prepare Derivative Works of,
	publicly display, publicly perform, sublicense, and distribute the Work and such
	Derivative Works in Source or Object form.
	
	3. Grant of Patent License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable (except as stated in this section) patent license to make, have
	made, use, offer to sell, sell, import, and otherwise transfer the Work, where
	such license applies only to those patent claims licensable by such Contributor
	that are necessarily infringed by their Contribution(s) alone or by combination
	of their Contribution(s) with the Work to which such Contribution(s) was
	submitted. If You institute patent litigation against any entity (including a
	cross-claim or counterclaim in a lawsuit) alleging that the Work or a
	Contribution incorporated within the Work constitutes direct or contributory
	patent infringement, then any patent licenses granted to You under this License
	for that Work shall terminate as of the date such litigation is filed.
	
	4. Redistribution.
	
	You may reproduce and distribute copies of the Work or Derivative Works thereof
	in any medium, with or without modifications, and in Source or Object form,
	provided that You meet the following conditions:
	
	You must give any other recipients of the Work or Derivative Works a copy of
	this License; and
	You must cause any modified files to carry prominent notices stating that You
	changed the files; and
	You must retain, in the Source form of any Derivative Works that You distribute,
	all copyright, patent, trademark, and attribution notices from the Source form
	of the Work, excluding those notices that do not pertain to any part of the
	Derivative Works; and
	If the Work includes a "NOTICE" text file as part of its distribution, then any
	Derivative Works that You distribute must include a readable copy of the
	attribution notices contained within such NOTICE file, excluding those notices
	that do not pertain to any part of the Derivative Works, in at least one of the
	following places: within a NOTICE text file distributed as part of the
	Derivative Works; within the Source form or documentation, if provided along
	with the Derivative Works; or, within a display generated by the Derivative
	Works, if and wherever such third-party notices normally appear. The contents of
	the NOTICE file are for informational purposes only and do not modify the
	License. You may add Your own attribution notices within Derivative Works that
	You distribute, alongside or as an addendum to the NOTICE text from the Work,
	provided that such additional attribution notices cannot be construed as
	modifying the License.
	You may add Your own copyright statement to Your modifications and may provide
	additional or different license terms and conditions for use, reproduction, or
	distribution of Your modifications, or for any such Derivative Works as a whole,
	provided Your use, reproduction, and distribution of the Work otherwise complies
	with the conditions stated in this License.
	
	5. Submission of Contributions.
	
	Unless You explicitly state otherwise, any Contribution intentionally submitted
	for inclusion in the Work by You to the Licensor shall be under the terms and
	conditions of this License, without any additional terms or conditions.
	Notwithstanding the above, nothing herein shall supersede or modify the terms of
	any separate license agreement you may have executed with Licensor regarding
	such Contributions.
	
	6. Trademarks.
	
	This License does not grant permission to use the trade names, trademarks,
	service marks, or product names of the Licensor, except as required for
	reasonable and customary use in describing the origin of the Work and
	reproducing the content of the NOTICE file.
	
	7. Disclaimer of Warranty.
	
	Unless required by applicable law or agreed to in writing, Licensor provides the
	Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
	including, without limitation, any warranties or conditions of TITLE,
	NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
	solely responsible for determining the appropriateness of using or
	redistributing the Work and assume any risks associated with Your exercise of
	permissions under this License.
	
	8. Limitation of Liability.
	
	In no event and under no legal theory, whether in tort (including negligence),
	contract, or otherwise, unless required by applicable law (such as deliberate
	and grossly negligent acts) or agreed to in writing, shall any Contributor be
	liable to You for damages, including any direct, indirect, special, incidental,
	or consequential damages of any character arising as a result of this License or
	out of the use or inability to use the Work (including but not limited to
	damages for loss of goodwill, work stoppage, computer failure or malfunction, or
	any and all other commercial damages or losses), even if such Contributor has
	been advised of the possibility of such damages.
	
	9. Accepting Warranty or Additional Liability.
	
	While redistributing the Work or Derivative Works thereof, You may choose to
	offer, and charge a fee for, acceptance of support, warranty, indemnity, or
	other liability obligations and/or rights consistent with this License. However,
	in accepting such obligations, You may act only on Your own behalf and on Your
	sole responsibility, not on behalf of any other Contributor, and only if You
	agree to indemnify, defend, and hold each Contributor harmless for any liability
	incurred by, or claims asserted against, such Contributor by reason of your
	accepting any such warranty or additional liability.
	
	END OF TERMS AND CONDITIONS
	
	APPENDIX: How to apply the Apache License to your work
	
	To apply the Apache License to your work, attach the following boilerplate
	notice, with the fields enclosed by brackets "{}" replaced with your own
	identifying information. (Don't include the brackets!) The text should be
	enclosed in the appropriate comment syntax for the file format. We also
	recommend that a file or class name and description of purpose be included on
	the same "printed page" as the copyright notice for easier identification within
	third-party archives.
	
	   Copyright 2020 t-io
	
	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at
	
	     http://www.apache.org/licenses/LICENSE-2.0
	
	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
*/
package org.tio.utils.zk;

import java.io.File;
import java.nio.file.Files;
import java.util.List;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.CuratorFrameworkFactory.Builder;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.RetryForever;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException.NodeExistsException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.hutool.StrUtil;

/**
 * @author tanyaowu 
 * 2017年9月19日 下午3:06:34
 */
public class Zk {
	private static Logger log = LoggerFactory.getLogger(Zk.class);

	/**
	 * 
	 * @author: tanyaowu
	 */
	public Zk() {
	}

	private static final String CHARSET = "utf-8";

	public static CuratorFramework zkclient = null;
	//		static String nameSpace = "php";
	//	static {
	//		String zkhost = "192.168.1.41:2181";//AppConfig.getInstance().getString("zk.address", null);//"192.168.1.41:2181";//ZK host
	//		zkhost = AppConfig.getInstance().getString("zk.address", null);
	//
	//		if (StrUtil.isBlank(zkhost)) {
	//			log.error("请配置好zookeeper地址:{}", "zk.address");
	//
	//		}
	//
	//		RetryPolicy rp = new ExponentialBackoffRetry(500, Integer.MAX_VALUE);//Retry mechanism
	//		Builder builder = CuratorFrameworkFactory.builder().connectString(zkhost).connectionTimeoutMs(5000).sessionTimeoutMs(5000).retryPolicy(rp);
	//		//				builder.namespace(nameSpace);
	//		CuratorFramework zclient = builder.build();
	//		zkclient = zclient;
	//		zkclient.start();// Implemented in the front
	//		//				zkclient.newNamespaceAwareEnsurePath(nameSpace);
	//
	//	}

	/**
	 * 
	 * @param address
	 * @param clientDecorator
	 * @author tanyaowu
	 * @throws Exception
	 */
	public static void init(String address, ClientDecorator clientDecorator) throws Exception {
		//		String zkhost = "192.168.1.41:2181";//AppConfig.getInstance().getString("zk.address", null);//"192.168.1.41:2181";//ZK host
		//		zkhost = AppConfig.getInstance().getString("zk.address", null);

		if (StrUtil.isBlank(address)) {
			log.error("zk address is null");
			throw new RuntimeException("zk address is null");
		}

		//		RetryPolicy rp = new ExponentialBackoffRetry(500, Integer.MAX_VALUE);//Retry mechanism
		RetryPolicy rp = new RetryForever(500);
		Builder builder = CuratorFrameworkFactory.builder().connectString(address).connectionTimeoutMs(15 * 1000).sessionTimeoutMs(60 * 1000).retryPolicy(rp);
		//				builder.namespace(nameSpace);
		zkclient = builder.build();

		if (clientDecorator != null) {
			clientDecorator.decorate(zkclient);
		}

		//		zkclient.start();
	}

	/**
	 * Start the client. Most mutator methods will not work until the client is started
	 * @author tanyaowu
	 */
	public static void start() {
		Zk.zkclient.start();
	}

	/**
	 * 
	 * @param path
	 * @param content
	 * @param createMode
	 * @throws Exception
	 */
	public static void createOrUpdate(String path, String content, CreateMode createMode) throws Exception {
		if (content != null) {
			createOrUpdate(path, content.getBytes(CHARSET), createMode);
			return;
		}
		createOrUpdate(path, (byte[]) null, createMode);
	}

	/**
	 * 
	 * @param path
	 * @param content
	 * @param createMode
	 * @throws Exception
	 */
	public static void createOrUpdate(String path, byte[] content, CreateMode createMode) throws Exception {
		if (!createMode.isSequential()) {
			if (exists(path)) {
				log.info("节点已经存在:{}", path);
				if (content != null) {
					setData(path, content);
				}
				return;
			}
		}

		try {
			zkclient.create().creatingParentsIfNeeded().withMode(createMode).forPath(path, content);
		} catch (NodeExistsException e) {
			//			node exists skip it
			//			log.error(e.toString(), e);
		}

		return;
	}

	public static void createContainers(String path) throws Exception {
		zkclient.createContainers(path);
	}

	/**
	 * 
	 * @param path
	 * @throws Exception
	 */
	public static void delete(String path) throws Exception {
		zkclient.delete().guaranteed().deletingChildrenIfNeeded().forPath(path);
		log.info("{} deleted", path);
	}

	/**
	 * 
	 * @param path
	 * @return
	 * @throws Exception
	 */
	public static boolean exists(String path) throws Exception {
		Stat stat = zkclient.checkExists().forPath(path);
		if (stat == null) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * 
	 * @param path
	 * @return
	 * @throws Exception
	 */
	public static byte[] getBytes(String path) throws Exception {
		return zkclient.getData().forPath(path);
	}

	/**
	 * 
	 * @param path
	 * @param charset
	 * @return
	 * @throws Exception
	 */
	public static String getString(String path, String charset) throws Exception {
		byte[] bs = getBytes(path);
		if (bs != null && bs.length > 0) {
			return new String(bs, charset);
		}
		return null;
	}

	public static String getString(String path) throws Exception {
		return getString(path, "utf-8");
	}

	/**
	 * 
	 * @param path
	 * @return
	 * @throws Exception
	 */
	public static List<String> getChildren(String path) throws Exception {
		List<String> paths = zkclient.getChildren().forPath(path);
		return paths;
	}

	/**
	 * 
	 * @param path
	 * @param localpath
	 * @param createMode
	 * @throws Exception
	 */
	public static void upload(String path, String localpath, CreateMode createMode) throws Exception {
		byte[] bs = Files.readAllBytes(new File(localpath).toPath());
		setData(path, bs);
	}

	/**
	 * 
	 * @param path
	 * @param bs
	 * @throws Exception
	 */
	public static void setData(String path, byte[] bs) throws Exception {
		if (bs != null) {
			if (Zk.exists(path)) {
				zkclient.setData().forPath(path, bs);
			} else {
				try {
					zkclient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL).forPath(path, bs);
				} catch (NodeExistsException e) {
					//节点已经存在, skip it
					//log.error(e.toString(), e);
				}
			}
		}
	}

	/**
	 * 
	 * @param path
	 * @param content
	 * @throws Exception
	 */
	public static void setData(String path, String content) throws Exception {
		if (false == StrUtil.isBlank(content)) {
			setData(path, content.getBytes(CHARSET));
		}
	}

	/**
	 * 
	 * @param path
	 * @param pathChildrenCacheListener
	 * @throws Exception
	 */
	@SuppressWarnings("resource")
	public static void addPathChildrenCacheListener(String path, PathChildrenCacheListener pathChildrenCacheListener) throws Exception {
		PathChildrenCache cache = new PathChildrenCache(zkclient, path, true);
		cache.start();

		//		System.out.println("监听开始/zk........");
		//		PathChildrenCacheListener plis = new PathChildrenCacheListener()
		//		{
		//
		//			@Override
		//			public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception
		//			{
		//				switch (event.getType())
		//				{
		//				case CHILD_ADDED:
		//				{
		//					System.out.println("Node added: " + ZKPaths.getNodeFromPath(event.getData().getPath()));
		//					break;
		//				}
		//
		//				case CHILD_UPDATED:
		//				{
		//					System.out.println("Node changed: " + ZKPaths.getNodeFromPath(event.getData().getPath()));
		//					break;
		//				}
		//
		//				case CHILD_REMOVED:
		//				{
		//					System.out.println("Node removed: " + ZKPaths.getNodeFromPath(event.getData().getPath()));
		//					break;
		//				}
		//				}
		//
		//			}
		//		};
		//		//注册监听 
		cache.getListenable().addListener(pathChildrenCacheListener);

	}

}
