Plotting Data (2D)
==================

The `plot` module is used to read input data from CSV or GeoJSON files and draw a
2D plot from it. The layout and styling of the plot is fully customizable
using the options described below.


### User Guide

<ul>
  <li><a href="/getting-started">Getting Started</a></li>
  <li><a href="/plot/usage">List of <code>plot</code> statements</a></li>
  <!--
  <li><a href="/plot/usage">Drawing line charts</a></li>
  <li><a href="/plot/usage">Drawing point &amp; scatter charts</a></li>
  <li><a href="/plot/usage">Drawing barcharts</a></li>
  <li><a href="/plot/usage">Drawing error bars</a></li>
  <li><a href="/plot/usage">Drawing heatmaps</a></li>
  <li><a href="/plot/usage">Drawing vector fields</a></li>
  <li><a href="/plot/usage">Adding axes</a></li>
  <li><a href="/plot/usage">Adding a legend</a></li>
  <li><a href="/plot/usage">Adding grid lines</a></li>
  -->
</ul>


### Reference

This section contains a lists of all available commands and options for the `plot`
module. Please follow the respective links for more details on the individual
topics.


##### Geometry Commands

<ul>
  <li><a href="/plot/areas"><code>areas:</code> Area Charts</a></li>
  <li><a href="/plot/bars"><code>bars:</code> Bars</a></li>
  <li><a href="/plot/errorbars"><code>errorbars:</code> Error Bars</a></li>
  <li><a href="/plot/labels"><code>labels:</code> Text Labels</a></li>
  <li><a href="/plot/lines"><code>lines:</code> Lines</a></li>
  <li><a href="/plot/points"><code>points:</code> Point &amp; Scatterplots</a></li>
  <li><a href="/plot/polygons"><code>polygons:</code> Polygons</a></li>
  <li><a href="/plot/rectangles"><code>rectangles:</code> Tiles &amp; Rectangles</a></li>
  <li><a href="/plot/vectors"><code>vectors:</code> Vector Fields</a></li>
</ul>

##### Layout Commands

<ul>
  <li><a href="/plot/axes"><code>axes:</code> Add axes</a></li>
  <li><a href="/plot/axis"><code>axis:</code> Add a single axis</a></li>
  <li><a href="/plot/grid"><code>grid:</code> Add grid lines</a></li>
  <li><a href="/plot/legend"><code>legend:</code> Add a legend</a></li>
</ul>

##### Styling Options

<ul>
  <li><a href="/plot/color-maps">Color Maps</a></li>
  <li><a href="/plot/number-format">Number Formatters</a></li>
  <li><a href="/plot/scale-types">Scale Types</a></li>
  <li><a href="/plot/scale-layout">Scale Layout</a></li>
  <li><a href="/marker-shapes">Marker Shapes</a></li>
</ul>

##### General Options

<ul>
  <li><a href="/colors">Colors</a></li>
  <li><a href="/typographic">Typographic Units</a></li>
  <li><a href="/fonts">Fonts</a></li>
</ul>
