/**
 * This file is part of the "clip" project
 *   Copyright (c) 2018 Paul Asmuth
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "style_util.h"

#include <functional>

namespace clip {

bool style_is_visible(const draw_style::compound& style) {
  return
      style.fill_solid.size() > 0 ||
      style.fill_hatch.size() > 0 ||
      style.stroke_solid.size() > 0 ||
      style.stroke_dash.size() > 0;
}

} // namespace clip

