<?php
/* +----------------------------------------------------------------------+
   | Copyright (c) 2018-2019 YmPay                                        |
   |              <530759076@qq.com>                                      |
   +----------------------------------------------------------------------+*/
namespace App\Http\Controllers\Api;
use Illuminate\Support\Facades\Redis;
use Vinkla\Hashids\Facades\Hashids;
use App\Http\Models\PaymentModel;
use App\Http\Models\OrderModel;
use App\Http\Models\PollingModel;
use App\Http\Models\DiepollingpaymentModel;
use App\Http\Models\LivepollingpaymentModel;
use App\Http\Models\MemberpaymentModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use GatewayClient\Gateway;
use Log;
use Illuminate\Contracts\Support\JsonableInterface;
use App\Http\Controllers\Common\Order_Redis;
class AppController extends Controller {
    public function __construct(){
       
    }
    /****APP登录接口****/
    public function login(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['username'])) {
                    if (!empty($postdata['password'])) {
                        if ($postdata['type'] == 'merchant' || $postdata['type'] == 'polling') {
                            if ($postdata['type'] == 'merchant') {
                                if (checkphone($postdata['username'])) {
                                    $info = DB::table('member')->where('phone', $postdata['username'])->first();
                                    if ($info) {
                                        if (ypass($postdata['password'], $info->password)) {
                                            if ($info->status != 1) {
                                                $json['status'] = 101;
                                                $json['msg'] = "当前码商已被冻结,如有疑问请咨询客服";
                                            } else if ($info->price <= 0) {
                                                $json['status'] = 101;
                                                $json['msg'] = "当前码商余额不足,请到平台充值后再登录";
                                            } else {
                                                //查询是否拥有收款账户
                                                $first = DB::table('member_polling')->where('member_id', $info->Id)->first();
                                                if ($first) {
                                                    $json['status'] = 100;
                                                    $json['data'] = apiencode(array(
                                                        'merchant_uid' => Hashids::encode($info->Id)
                                                    ));
                                                    $json['msg'] = "验证成功";
                                                } else {
                                                    $json['status'] = 101;
                                                    $json['msg'] = "请先在平台添加收款账号后再进行登录哦";
                                                }
                                            }
                                        } else {
                                            $json['status'] = 101;
                                            $json['msg'] = "输入密码不正确";
                                        }
                                    } else {
                                        $json['status'] = 101;
                                        $json['msg'] = "当前码商不存在";
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "请输入正确的手机号";
                                }
                            } else {
                                if (!empty($postdata['token'])) {
                                    if (!empty($postdata['device'])) {
                                        $info = DB::table('member_polling')->where('username', $postdata['username'])->first();
                                        if ($info) {
                                            if (!ypass($postdata['password'], $info->password)) {
                                                $json['status'] = 101;
                                                $json['msg'] = "输入密码不正确";
                                            } else if($info->loop == 2){
                                                $json['status'] = 101;
                                                $json['msg'] = "当前账户已关闭轮训状态,请打开后再登录";
                                            } else {
                                                $userinfo = DB::table('member')->where('Id', $info->member_id)->first();
                                                if ($userinfo->status != 1) {
                                                    $json['status'] = 101;
                                                    $json['msg'] = "当前码商已被冻结,如有疑问请咨询客服";
                                                } else if ($userinfo->price <= 0) {
                                                    $json['status'] = 101;
                                                    $json['msg'] = "当前码商余额不足,请到平台充值后再登录";
                                                } else {
                                                    //查询当前收款账号已开通通道 并轮循查每个通道收款金额以及成功订单数;
                                                    if ($info->type == 1) {
                                                        $payment = new DiepollingpaymentModel;
                                                        $redis_map[] = ['qrcode','!=',2];
                                                    } else {
                                                        $payment = new LivepollingpaymentModel;
                                                    }
                                                    $list = $payment->where('polling_id', $info->Id)->select('passageway_id', 'key', 'today_money','gateway_state')->with(['payment' => function ($query) {
                                                        $query->select('Id', 'name');
                                                    }
                                                    ])->get();
                                                    if ($list->isNotEmpty()) {
                                                        $list = $list->toarray();
                                                        //先操作该账号token以及device,以及在线状态;
                                                        if ($postdata['token'] != $info->token || $postdata['device'] != $info->device) {
                                                            $updata['token'] = $postdata['token'];
                                                            $updata['device'] = $postdata['device'];
                                                        }
                                                        $updata['login_time'] = time();
                                                        $upipdata = loginip($arr->getClientIp());
                                                        if ($upipdata) {
                                                            $updata['region_id'] = $upipdata['proCode'];
                                                            $updata['city_id'] = $upipdata['cityCode'];
                                                            $updata['address'] = $upipdata['addr'];
                                                        }
                                                        $updata['ip'] = $arr->getClientIp();
                                                        $updata['status'] = 1;
                                                        $status = DB::table('member_polling')->where('Id', $info->Id)->update($updata);
                                                        if ($postdata['token'] != $info->token || $postdata['device'] != $info->device && !empty($info->token)) {
                                                                //判断平台出码方式
                                                                $admin_site=DB::table('admin_site')->first();
                                                                $Order_Redis = new Order_Redis;
                                                                /****删除支付宝二维码****/
										                        $Order_Redis->delete($admin_site->payment_type,'alipay',$info->type,array('polling_id'=>$info->Id));
										                        /****删除支付宝H5二维码****/
										                        $Order_Redis->delete($admin_site->payment_type,'aliwap',$info->type,array('polling_id'=>$info->Id));
										                        /****删除微信二维码****/
										                        $Order_Redis->delete($admin_site->payment_type,'wechat',$info->type,array('polling_id'=>$info->Id));
										                        /****删除银联二维码****/
										                        $Order_Redis->delete($admin_site->payment_type,'unionpay',$info->type,array('polling_id'=>$info->Id));
                                                                //添加所有网关在线,二维码不为空的通道到Redis
                                                                $redis_map['polling_id'] = $info->Id;
                                                                $redis_map['gateway_state'] = 1;
                                                                $order_redis_list = $payment->where($redis_map)->with('user','payment','merchant')->get();
                                                                if ($order_redis_list->isNotEmpty()){
                                                                    $typename = $info->type == 1 ? 'die' : 'live';
                                                                    $order_redis_list = $order_redis_list->toarray();
                                                                    if($admin_site->payment_type = 1){
                                                                        foreach ($order_redis_list as $v) {
                                                                            $v = (array)$v;
                                                                            if(stristr($v['payment']['paytype'],'alipay') !== false){
                                                                                //添加顺序列表
                                                                                Redis::rpush('sort_alipay_'.$typename,json_encode($v));
                                                                            }
                                                                            if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                                                                //添加顺序列表
                                                                                Redis::rpush('sort_aliwap_'.$typename,json_encode($v));
                                                                            }
                                                                            if(stristr($v['payment']['paytype'],'wechat') !== false){
                                                                                //添加顺序列表
                                                                                Redis::rpush('sort_wechat_'.$typename,json_encode($v));
                                                                            }
                                                                            if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                                                                //添加顺序列表
                                                                                Redis::rpush('sort_unionpay_'.$typename,json_encode($v));
                                                                            }
                                                                        }
                                                                    }else{
                                                                        //添加所有在线通道到随机
                                                                        foreach ($order_redis_list as $v) {
                                                                            $v = (array)$v;
                                                                            if(stristr($v['payment']['paytype'],'alipay') !== false){
                                                                                //添加随机列表
                                                                                Redis::sadd('random_alipay_'.$typename,json_encode($v));
                                                                            }
                                                                            if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                                                                //添加随机列表
                                                                                Redis::sadd('random_aliwap_'.$typename,json_encode($v));
                                                                            }
                                                                            if(stristr($v['payment']['paytype'],'wechat') !== false){
                                                                                //添加随机列表
                                                                                Redis::sadd('random_wechat_'.$typename,json_encode($v));
                                                                            }
                                                                            if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                                                                //添加随机列表
                                                                                Redis::sadd('random_unionpay_'.$typename,json_encode($v));
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                Gateway::bindUid($updata['token'], $updata['device']);
                                                                if (!empty($info->token) && $postdata['token'] != $info->token) {
                                                                    if (Gateway::isOnline($info->token)) {
                                                                        //推送掉线消息
                                                                        $content['type'] = "loseuser";
                                                                        $content['msg'] = "当前账户已在别处登录或被强制下线";
                                                                        Gateway::sendToClient($info->token, json_encode($content));
                                                                    }
                                                                }
                                                            }
                                                        if (!isset($json)) {
                                                            //遍历查询当天收款
                                                            foreach ($list as $k => $v) {
                                                                $v = (array)$v;
                                                                $v['channel_code'] = $v['passageway_id'];
                                                                $v['channel_key'] = $v['key'];
                                                                $v['channel_name'] = $v['payment']['name'];
                                                                $v['channel_img'] = 'http://' . $_SERVER['HTTP_HOST'] . "/merchants/icon/" . $v['passageway_id'] . ".png";
                                                                $map[$k]['status'] = 2;
                                                                $map[$k]['polling_passageway_key'] = $v['key'];
                                                                $map[$k][] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
                                                                $map[$k][] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
                                                                /****该通道今日收款金额****/
                                                                $v['order_today_money'] = number_format(OrderModel::where($map[$k])->sum('order_price') , 2, ".", "");
                                                                /****该通道今日收款订单数****/
                                                                $v['order_today_count'] = OrderModel::where($map[$k])->count();
                                                                /***删除无需返回对象****/
                                                                unset($v['passageway_id']);
                                                                unset($v['key']);
                                                                unset($v['payment']);
                                                                $lists[] = $v;
                                                            }
                                                            $json['status'] = 100;
                                                            $json['data'] = apiencode(array(
                                                                'polling_id' => Hashids::encode($info->Id) ,
                                                                'merchant_uid' => Hashids::encode($userinfo->Id) ,
                                                                'merchant_amount' => $userinfo->price,
                                                                'ip' => $arr->getClientIp() ,
                                                                'passageway_type' => $info->type,
                                                                'passageway_list' => $lists
                                                            ));
                                                            $json['msg'] = "验证成功";
                                                        }
                                                    } else {
                                                        $json['status'] = 101;
                                                        $json['msg'] = "请先在平台给该收款账号添加通道后再进行登录哦";
                                                    }
                                                }
                                            }
                                        } else {
                                            $json['status'] = 101;
                                            $json['msg'] = "当前收款账号不存在";
                                        }
                                    } else {
                                        $json['status'] = 101;
                                        $json['msg'] = "设备唯一ID为空,如有问题请咨询客服";
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "与服务器通信失败,获取token错误";
                                }
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "登录方式错误";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "请输入密码";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "请输入登录账号";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return response()->json($json);
    }
    /****APP商户登录后获取收款账号列表****/
    public function pollinglist(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if ($postdata['action'] == 'list') {
                    if (!empty($postdata['merchant_uid'])) {
                        if (!empty($postdata['page'])) {
                            //获取所有收款账号
                            if (Hashids::decode($postdata['merchant_uid']) [0]) {
                                 $map['member_id'] = Hashids::decode($postdata['merchant_uid']) [0];
                                if (!empty($postdata['search']) && !is_null($postdata['search'])) {
                                    $map[] = ["username","like", "%".$postdata['search']."%"];
                                }
                                $list = DB::table('member_polling')->where($map)->select('Id', 'username', 'remarks', 'type', 'login_time')->get();
                                if (!$list->isEmpty()) {
                                    $list = $list->toarray();
                                    $listpage = getpage($list, 10, $postdata['page']);
                                    if ($listpage['total'] >= 1) {
                                        $listdata = $listpage['data'];
                                        foreach ($listdata as $v) {
                                            $v = (array)$v;
                                            $v['login_time'] = !empty($v['login_time']) ? date('Y-m-d H:i', $v['login_time']) : "无";
                                            $v['polling_id'] = Hashids::encode($v['Id']);
                                            unset($v['Id']);
                                            $json['data']['polling_list'][] = $v;
                                        }
                                        $json['data']['total'] = $listpage['total'];
                                        $json['data']['last_page'] = $listpage['last_page'];
                                        $json['data']['current_page'] = $listpage['current_page'];
                                        $json['data'] = apiencode($json['data']);
                                        $json['status'] = 100;
                                        $json['msg'] = "验证成功";
                                    } else {
                                        $json['status'] = 101;
                                        $json['msg'] = "当前无数据啦";
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "请先在平台添加收款账号后再进行登录哦";
                                }
                            } else {
                                $json['status'] = 101;
                                $json['msg'] = "Uid错误";
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "页数有误";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "码商Uid有误";
                    }
                } else if ($postdata['action'] == 'login') {
                    if (!empty($postdata['polling_id'])) {
                        if (!empty($postdata['device'])) {
                            if (!empty($postdata['token'])) {
                                if (Hashids::decode($postdata['polling_id']) [0]) {
                                    $info = DB::table('member_polling')->where('Id', Hashids::decode($postdata['polling_id']) [0])->first();
                                    if ($info) {
                                        if($info->loop == 2){
                                            $json['status'] = 101;
                                            $json['msg'] = "当前账户已关闭轮训状态,请打开后再登录";
                                        }else{
                                            $userinfo = DB::table('member')->where('Id', $info->member_id)->first();
                                            //查询当前收款账号已开通通道 并轮循查每个通道收款金额以及成功订单数;
                                            if ($info->type == 1) {
                                                $payment = new DiepollingpaymentModel;
                                                $redis_map[] = ['qrcode','!=',2];
                                            } else {
                                                $payment = new LivepollingpaymentModel;
                                            }
                                            $list = $payment->where('polling_id', $info->Id)->select('passageway_id', 'key', 'today_money','gateway_state')->with(['payment' => function ($query) {
                                                $query->select('Id', 'name');
                                            }
                                            ])->get();
                                            if ($list->isNotEmpty()) {
                                                $list = $list->toarray();
                                                //再操作该账号token以及device,以及在线状态;
                                                if ($postdata['token'] != $info->token || $postdata['device'] != $info->device) {
                                                    $updata['token'] = $postdata['token'];
                                                    $updata['device'] = $postdata['device'];
                                                }
                                               $updata['login_time'] = time();
                                               $upipdata = loginip($arr->getClientIp());
                                               if ($upipdata) {
                                                 $updata['region_id'] = $upipdata['proCode'];
                                                 $updata['city_id'] = $upipdata['cityCode'];
                                                 $updata['address'] = $upipdata['addr'];
                                               }
                                                $updata['ip'] = $arr->getClientIp();
                                                $updata['status'] = 1;
                                                $status = DB::table('member_polling')->where('Id', $info->Id)->update($updata);
                                                if (!$status) {
                                                    $json['status'] = 101;
                                                    $json['msg'] = "平台繁忙,请重新提交";
                                                } else {
                                                    if ($postdata['token'] != $info->token || $postdata['device'] != $info->device && !empty($info->token)) {
                                                        //判断平台出码方式
                                                        $admin_site=DB::table('admin_site')->first();
                                                        $Order_Redis = new Order_Redis;
                                                        /****删除支付宝二维码****/
								                        $Order_Redis->delete($admin_site->payment_type,'alipay',$info->type,array('polling_id'=>$info->Id));
								                        /****删除支付宝H5二维码****/
								                        $Order_Redis->delete($admin_site->payment_type,'aliwap',$info->type,array('polling_id'=>$info->Id));
								                        /****删除微信二维码****/
								                        $Order_Redis->delete($admin_site->payment_type,'wechat',$info->type,array('polling_id'=>$info->Id));
								                        /****删除银联二维码****/
								                        $Order_Redis->delete($admin_site->payment_type,'unionpay',$info->type,array('polling_id'=>$info->Id));
                                                        //添加所有网关在线,二维码不为空的通道到Redis
                                                        $redis_map['polling_id'] = $info->Id;
                                                        $redis_map['gateway_state'] = 1;
                                                        $order_redis_list = $payment->where($redis_map)->with('user','payment','merchant')->get();
                                                        if ($order_redis_list->isNotEmpty()){
                                                            $typename = $info->type == 1 ? 'die' : 'live';
                                                            $order_redis_list = $order_redis_list->toarray();
                                                            if($admin_site->payment_type = 1){
                                                                foreach ($order_redis_list as $v) {
                                                                    $v = (array)$v;
                                                                    if(stristr($v['payment']['paytype'],'alipay') !== false){
                                                                        //添加顺序列表
                                                                        Redis::rpush('sort_alipay_'.$typename,json_encode($v));
                                                                    }
                                                                    if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                                                        //添加顺序列表
                                                                        Redis::rpush('sort_aliwap_'.$typename,json_encode($v));
                                                                    }
                                                                    if(stristr($v['payment']['paytype'],'wechat') !== false){
                                                                        //添加顺序列表
                                                                        Redis::rpush('sort_wechat_'.$typename,json_encode($v));
                                                                    }
                                                                    if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                                                        //添加顺序列表
                                                                        Redis::rpush('sort_unionpay_'.$typename,json_encode($v));
                                                                    }
                                                                }
                                                            }else{
                                                                //添加所有在线通道到随机
                                                                foreach ($order_redis_list as $v) {
                                                                    $v = (array)$v;
                                                                    if(stristr($v['payment']['paytype'],'alipay') !== false){
                                                                        //添加随机列表
                                                                        Redis::sadd('random_alipay_'.$typename,json_encode($v));
                                                                    }
                                                                    if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                                                        //添加随机列表
                                                                        Redis::sadd('random_aliwap_'.$typename,json_encode($v));
                                                                    }
                                                                    if(stristr($v['payment']['paytype'],'wechat') !== false){
                                                                        //添加随机列表
                                                                        Redis::sadd('random_wechat_'.$typename,json_encode($v));
                                                                    }
                                                                    if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                                                        //添加随机列表
                                                                        Redis::sadd('random_unionpay_'.$typename,json_encode($v));
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        Gateway::bindUid($updata['token'], $updata['device']);
                                                        if (!empty($info->token) && $postdata['token'] != $info->token) {
                                                            if (Gateway::isOnline($info->token)) {
                                                                //推送掉线消息
                                                                $content['type'] = "loseuser";
                                                                $content['msg'] = "当前账户已在别处登录或被强制下线";
                                                                Gateway::sendToClient($info->token, json_encode($content));
                                                            }
                                                        }
                                                    }
                                                }
                                                if (!isset($json)) {
                                                    //遍历查询当天收款
                                                    foreach ($list as $k => $v) {
                                                        $v = (array)$v;
                                                        $v['channel_code'] = $v['passageway_id'];
                                                        $v['channel_key'] = $v['key'];
                                                        $v['channel_name'] = $v['payment']['name'];
                                                        $v['channel_img'] = 'http://' . $_SERVER['HTTP_HOST'] . "/merchants/icon/" . $v['passageway_id'] . ".png";
                                                        $map[$k]['status'] = 2;
                                                        $map[$k]['polling_passageway_key'] = $v['key'];
                                                        $map[$k][] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
                                                        $map[$k][] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
                                                        /****该通道今日收款金额****/
                                                        $v['order_today_money'] = number_format(OrderModel::where($map[$k])->sum('order_price') , 2, ".", "");
                                                        /****该通道今日收款订单数****/
                                                        $v['order_today_count'] = OrderModel::where($map[$k])->count();
                                                        /***删除无需返回对象****/
                                                        unset($v['passageway_id']);
                                                        unset($v['key']);
                                                        unset($v['payment']);
                                                        $lists[] = $v;
                                                    }
                                                    $json['status'] = 100;
                                                    $json['data'] = apiencode(array(
                                                        'merchant_uid' => Hashids::encode($userinfo->Id) ,
                                                        'merchant_amount' => $userinfo->price,
                                                        'ip' => $arr->getClientIp() ,
                                                        'passageway_type' => $info->type,
                                                        'passageway_list' => $lists
                                                    ));
                                                    $json['msg'] = "验证成功";
                                                }
                                            } else {
                                                $json['status'] = 101;
                                                $json['msg'] = "请先在平台给该收款账号添加通道后再进行登录哦";
                                            }
                                        }
                                    } else {
                                        $json['status'] = 101;
                                        $json['msg'] = "不存在当前收款账号";
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "Pollingid错误";
                                }
                            } else {
                                $json['status'] = 101;
                                $json['msg'] = "与服务器通信失败,获取token错误";
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "设备唯一ID为空,如有问题请咨询客服";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "Pollingid有误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "参数错误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
    /****APP商户余额明细****/
    public function merchant_amount_change(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['merchant_uid'])) {
                    if (!empty($postdata['page'])) {
                        if (Hashids::decode($postdata['merchant_uid']) [0]) {
                            $map['member_id'] = Hashids::decode($postdata['merchant_uid']) [0];
                            //查询所有
                            $list = DB::table('member_amount_change')->where($map)->select('type', 'amount', 'time')->orderBy('time','desc')->get();
                            if ($list->isNotEmpty()) {
                                $list = $list->toarray();
                                $listpage = getpage($list, 10, $postdata['page']);
                                if ($listpage['total'] >= 1) {
                                    $listdata = $listpage['data'];
                                    foreach ($listdata as $v) {
                                        $v = (array)$v;
                                        if($v['type'] == 1){
                                            $v['title'] = "出单扣除";
                                            $v['amount']= "-".$v['amount'];
                                        }else if($v['type'] == 2){
                                            $v['title'] = "余额充值";
                                            $v['amount']= "+".$v['amount'];
                                        }else if($v['type'] == 3){
                                            $v['title'] = "冻结扣除(余额不足)";
                                            $v['amount']= "-".$v['amount'];
                                        }else{
                                            $v['title'] = "平台扣款";
                                            $v['amount']= "-".$v['amount'];
                                        }
                                        $v['time'] = date('Y-m-d H:i', $v['time']);
                                        unset($v['type']);
                                        $json['data']['amount_change_list'][] = $v;
                                    }
                                    $json['data']['total'] = $listpage['total'];
                                    $json['data']['last_page'] = $listpage['last_page'];
                                    $json['data']['current_page'] = $listpage['current_page'];
                                    $json['data'] = apiencode($json['data']);
                                    $json['status'] = 100;
                                    $json['msg'] = "验证成功";
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "当前没有记录啦";
                                }
                            } else {
                                $json['status'] = 101;
                                $json['msg'] = "当前没有记录哦";
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "Uid有误";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "页数有误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "Uid错误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
    /****APP查询码商余额****/
    public function amount_loading(Request $arr){
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['polling_id'])) {
                    if (Hashids::decode($postdata['polling_id']) [0]) {
                        //获取当前码商余额
                        $info = PollingModel::where('Id', Hashids::decode($postdata['polling_id']) [0])->with('merchant')->first();
                        if($info){
                            $info = $info->toarray();
                            $json['status'] = 100;
                            $json['data'] = apiencode(array(
                                                'merchant_amount' => $info['merchant']['price'],
                                                'ip' => $arr->getClientIp()
                                            ));
                        }else{
                            $json['status'] = 101;
                            $json['msg'] = "当前码商不存在";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "Pollingid错误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "Pollingid有误";
                }
            }else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
    /***APP固码接收通知****/
    public function dienotice(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['polling_id'])) {
                    if (Hashids::decode($postdata['polling_id']) [0]) {
                        //先获取通道ID以及金额
                        $arrz = getapiarr($postdata);
                        if ($arrz) {
                            $arrz['polling_id'] = Hashids::decode($postdata['polling_id']) [0];
                            try {
                                if (Redis::exists(md5(json_encode($arrz)))) {
                                    $orderinfo = json_decode(Redis::get(md5(json_encode($arrz))) , true);
                                    $polinfo = PollingModel::where('Id',$arrz['polling_id'])->first();
                                    $admin_site = DB::table('admin_site')->first();
                                    $order_redis = new Order_Redis;
                                    if($orderinfo['order_price'] == $arrz['order_price'] && $orderinfo['polling_user'] == $polinfo->username){
	                                    //先获取该码商信息
	                                    $merchant = DB::table('member')->where('Id',$orderinfo['member_id'])->first();
	                                    /****记录订单信息******/
	                                    Log::channel('order_success')->info("apiorder_id :{$orderinfo['apiorder_id']} - notice:".json_encode($postdata)." - Redis :".json_encode($arrz)."\r\n");
	                                    /***删除Redis订单,并添加到Redis回调中****/
	                                    $postarr['form']['user_id'] = $orderinfo['user_id'];
	                                    $postarr['form']['order_id'] = $orderinfo['order_id'];
	                                    $postarr['form']['apiorder_id'] = $orderinfo['apiorder_id'];
	                                    $postarr['form']['amount'] = $orderinfo['order_money'];
	                                    $postarr['form']['amount_actual'] = $orderinfo['order_price'];
	                                    $postarr['form']['paytype'] = $orderinfo['type'];
	                                    if (isset($orderinfo['remarks'])) {
	                                        $postarr['form']['remarks'] = $orderinfo['remarks'];
	                                    }
	                                    $postarr['form']['success_time'] = time();
	                                    $postarr['form']['sign'] = getsign($postarr['form'], $orderinfo['user_token']);
	                                    $postarr['notify_url'] = $orderinfo['notify_url'];
	                                    $postarr['number_notice'] = 0;
	                                    //服务器处理该订单
	                                    $status = OrderModel::where(array(
	                                    	'apiorder_id'=> $orderinfo['apiorder_id'],
	                                    	'polling_user'=> $polinfo->username,
	                                    	'order_price' => $arrz['order_price']
	                                    	))->update(array(
	                                        'status' => 2,
	                                        'com_time' => time()
	                                    ));
	                                    if ($status) {
	                                        //删除金额池
	                                        Redis::lrem('amountpool', 1, json_encode(array(
	                                            'passageway_id' => $orderinfo['passageway_id'],
	                                            'polling_user' => $orderinfo['polling_user'],
	                                            'order_price' => $orderinfo['order_price'],
	                                            'exptime' => $orderinfo['com_time']
	                                        )));
	                                        //添加到Redis回调列表
		                                    $redis_status = Redis::rpush('ordernotice', json_encode($postarr));
		                                    //删除Redis订单
		                                    Redis::del(md5(json_encode($arrz)));
	                                        /***先处理商户余额以及添加余额明细****/
	                                        $change_data['type'] = 1;
	                                        $change_data['user_id'] = $orderinfo['user_id'];
	                                        $change_data['amount'] = $orderinfo['order_price'] - $orderinfo['order_service'] - $orderinfo['software_service'];
	                                        $change_data['time'] = time();
	                                        //先获取商户原余额
	                                        $price = DB::table('user')->where('Id', $change_data['user_id'])->first()->price;
	                                        $change_data['user_price'] = $price + $change_data['amount'];
	                                        //再给商户加余额
	                                        $status = DB::table('user')->where('Id', $change_data['user_id'])->update(array(
	                                            'price' => $change_data['user_price']
	                                        ));
	                                        if (!$status) {
	                                            //记录加余额失败用户
	                                            $amount_error_a['form']['apiorder_id'] = $orderinfo['apiorder_id'];
	                                            $amount_error_a['form']['user_id'] = $change_data['user_id'];
	                                            $amount_error_a['form']['amount'] = $change_data['amount'];
	                                            $amount_error_a['type'] = 1001;
	                                            Redis::rpush('order_amount_error',json_encode($amount_error_a));
	                                        }
	                                        //添加商户余额明细
	                                        $addstatus = DB::table('user_amount_change')->insert($change_data);
	                                        if (!$addstatus) {
	                                        	//记录加余额明细失败用户
	                                            $amount_error_b['form'] = $change_data;
	                                            $amount_error_b['type'] = 1002;
	                                            Redis::rpush('order_amount_error',json_encode($amount_error_b));
	                                        }
	                                        /***再次处理码商余额以及添加余额明细****/
	                                        $change_datas['type'] = 1;
	                                        $change_datas['member_id'] = $orderinfo['member_id'];
	                                        $change_datas['amount'] = number_format($orderinfo['order_price'] - $orderinfo['order_service'] - $orderinfo['software_service'] + $orderinfo['passageway_service'],3,".","");
	                                        $change_datas['time'] = $change_data['time'];
	                                        //先获取码商原余额
	                                        $price = $merchant->price;
	                                        if($price >= $change_datas['amount']){
	                                            $change_datas['member_price'] = $price - $change_datas['amount'];
	                                            $merchant_updata['price'] = $change_datas['member_price'];
	                                        }else{
	                                            //码商余额清0再扣除冻结金额
	                                            $change_datas['member_price'] = 0;
	                                            $merchant_updata['price'] = 0;
	                                            $merchant_updata['frozen_amount'] = $merchant->frozen_amount-($change_datas['amount']-$price);
	                                            //额外加码商冻结余额明细
	                                            $change_dataf['type'] = 3;
	                                            $change_dataf['member_id'] = $orderinfo['member_id'];
	                                            $change_dataf['amount'] =$change_datas['amount']-$price;
	                                            $change_dataf['member_price'] = 0;
	                                            $change_dataf['time'] = $change_data['time'];
	                                        }
	                                        
	                                        //给码商扣除余额
	                                        $merchantstatus = DB::table('member')->where('Id', $change_datas['member_id'])->update($merchant_updata);
	                                        if (!$merchantstatus) {
	                                        	 //记录扣余额失败码商
	                                            $amount_error_c['form']['apiorder_id'] = $orderinfo['apiorder_id'];
	                                            $amount_error_c['form']['member_id'] = $change_datas['member_id'];
	                                            $amount_error_c['form']['amount'] = $change_datas['amount'];
	                                            $amount_error_c['type'] = 2001;
	                                             Redis::rpush('order_amount_error',json_encode($amount_error_c));
	                                        }
	                                        //添加码商余额明细
	                                        $memberamountadd = DB::table('member_amount_change')->insert($change_datas);
	                                        if (!$memberamountadd) {
	                                           //记录加余额明细失败码商
	                                            $amount_error_d['form'] = $change_datas;
	                                            $amount_error_d['type'] = 2002;
	                                            Redis::rpush('order_amount_error',json_encode($amount_error_d));
	                                        }
	                                        //存在余额不足时
	                                        if(isset($change_dataf)){
	                                            //添加冻结余额明细
	                                            $memberfrozen_amountadd = DB::table('member_amount_change')->insert($change_dataf);
	                                            if (!$memberfrozen_amountadd) {
	                                                //记录加冻结余额明细失败码商
	                                                $amount_error_f['form'] = $change_dataf;
	                                            	$amount_error_f['type'] = 2003;
	                                            	Redis::rpush('order_amount_error',json_encode($amount_error_f));
	                                            }
	                                            //发送通知踢下线
	                                            $content['type'] = "loseuser";
	                                            $content['msg'] = "当前账户余额不足,已自动下线";
	                                            $polling = DB::table('member_polling')->where('Id',$arrz['polling_id'])->first();
	                                            if($polling){
	                                            	//清除该账号二维码
	                                            	$redis_data['polling_id']= $polling->Id;
							                        /****删除支付宝二维码****/
							                        $order_redis->delete($admin_site->payment_type,'alipay',1,$redis_data);
							                        /****删除支付宝H5二维码****/
							                        $order_redis->delete($admin_site->payment_type,'aliwap',1,$redis_data);
							                        /****删除微信二维码****/
							                        $order_redis->delete($admin_site->payment_type,'wechat',1,$redis_data);
							                        /****删除银联二维码****/
							                        $order_redis->delete($admin_site->payment_type,'unionpay',1,$redis_data);
	                                                Gateway::sendToClient($polling->token,json_encode($content));
	                                            }
	                                        }
	                                        //清除该二维码
                                            $order_redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$orderinfo['polling_passageway_key']));
                                            $order_redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$orderinfo['polling_passageway_key']));
                                            $order_redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$orderinfo['polling_passageway_key']));
                                            $order_redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$orderinfo['polling_passageway_key']));
                                            //清除该二维码出码记录
                                            $order_redis->query_delete('alipay',1,$orderinfo['polling_passageway_key']);
                                            $order_redis->query_delete('aliwap',1,$orderinfo['polling_passageway_key']);
                                            $order_redis->query_delete('wechat',1,$orderinfo['polling_passageway_key']);
                                            $order_redis->query_delete('unionpay',1,$orderinfo['polling_passageway_key']);
                                            //添加该二维码
                                            $payment_die  = DiepollingpaymentModel::where('key',$orderinfo['polling_passageway_key'])->with('user','payment', 'merchant')->first();
                                            if($payment_die->merchant->price > 1 && $payment_die->merchant->frozen_amount >=0 && $payment_die->user->status == 1 && $payment_die->user->loop == 1 && $payment_die->gateway_state ==1){
						                        if($admin_site->payment_type == 1){
	                                                if(stristr($payment_die->payment->paytype,'alipay') !== false){
	                                                    Redis::rpush('sort_alipay_die',json_encode($payment_die));
	                                                }
	                                                if(stristr($payment_die->payment->paytype,'aliwap') !== false){
	                                                    Redis::rpush('sort_aliwap_die',json_encode($payment_die));
	                                                }
	                                                if(stristr($payment_die->payment->paytype,'wechat') !== false){
	                                                    Redis::rpush('sort_wechat_die',json_encode($payment_die));
	                                                }
	                                                if(stristr($payment_die->payment->paytype,'unionpay') !== false){
	                                                    Redis::rpush('sort_unionpay_die',json_encode($payment_die));
	                                                }
	                                            }else{
	                                                if(stristr($payment_die->payment->paytype,'alipay') !== false){
	                                                    Redis::sadd('random_alipay_die',json_encode($payment_die));
	                                                }
	                                                if(stristr($payment_die->payment->paytype,'aliwap') !== false){
	                                                    Redis::sadd('random_aliwap_die',json_encode($payment_die));
	                                                }
	                                                if(stristr($payment_die->payment->paytype,'wechat') !== false){
	                                                    Redis::sadd('random_wechat_die',json_encode($payment_die));
	                                                }
	                                                if(stristr($payment_die->payment->paytype,'unionpay') !== false){
	                                                    Redis::sadd('random_unionpay_die',json_encode($payment_die));
	                                                }
	                                            }
						                    }
	                                        /****任务下发后判断当前通道是否限额****/
	                                        $dieinfo = DiepollingpaymentModel::where('key', $orderinfo['polling_passageway_key'])->with('merchant', 'payment')->first()->toarray();
	                                        $Order_Redis = new Order_Redis;
	                                        $admin_site = DB::table('admin_site')->first();
	                                        //该通道的二维码池Redis参数
	                                        $redis_data['key'] = $dieinfo['key'];
	                                        if ($dieinfo['today_money'] != 0) {
	                                            //获取当天交易订单额
	                                            $map['status'] = 2;
	                                            $map['polling_passageway_key'] = $dieinfo['key'];
	                                            $map[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
	                                            $map[] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
	                                            $today_money = OrderModel::where($map)->sum('order_price');
	                                            if ($today_money >= $dieinfo['today_money']) {
	                                                $Order_Redis->delete($admin_site->payment_type,$orderinfo['paytype'],1,$redis_data);
	                                                //关闭该通道网关
	                                                DiepollingpaymentModel::where('key', $dieinfo['key'])->update(array(
	                                                    'gateway_state' => 2
	                                                ));
	                                                $json['msg'] = date('Y-m-d H:i:s') . "- {$orderinfo['apiorder_id']} -订单处理成功," . $dieinfo['payment']['name'] . "通道已达到当日限额,已自动关闭网关,如还想继续使用,请到平台修改当日限额后再开启网关";
	                                            }
	                                        } else if ($dieinfo['total_money'] != 0) {
	                                            //获取总交易订单额
	                                            $map['status'] = 2;
	                                            $map['polling_passageway_key'] = $dieinfo['key'];
	                                            $total_money = OrderModel::where($map)->sum('order_price');
	                                            if ($total_money >= $dieinfo['total_money']) {
	                                                $Order_Redis->delete($admin_site->payment_type,$orderinfo['paytype'],1,$redis_data);
	                                                //暂停该通道
	                                                DiepollingpaymentModel::where('key', $dieinfo['key'])->update(array(
	                                                    'gateway_state' => 2
	                                                ));
	                                                $json['msg'] = date('Y-m-d H:i:s') . "- {$orderinfo['apiorder_id']} -订单处理成功," . $dieinfo['payment']['name'] . "通道已达到总限额,已自动关闭网关,如还想继续使用,请到平台修改总限额后再开启网关";
	                                            }
	                                        } else {
	                                            $json['msg'] = date('Y-m-d H:i:s') . "- {$orderinfo['apiorder_id']} -订单处理成功";
	                                        }
	                                        //修改后再查询可用通道
	                                        $list = DiepollingpaymentModel::where('polling_id', $dieinfo['polling_id'])->select('passageway_id', 'key', 'today_money','gateway_state')->with(['payment' => function ($query) {
	                                            $query->select('Id', 'name');
	                                        }
	                                        ])->get()->toarray();
	                                        //然后遍历查询当天收款
	                                        foreach ($list as $k => $v) {
	                                            $v = (array)$v;
	                                            $v['channel_code'] = $v['passageway_id'];
	                                            $v['channel_name'] = $v['payment']['name'];
	                                            $v['channel_img'] = 'http://' . $_SERVER['HTTP_HOST'] . "/merchants/icon/" . $v['passageway_id'] . ".png";
	                                            $map[$k]['status'] = 2;
	                                            $map[$k]['polling_passageway_key'] = $v['key'];
	                                            $map[$k][] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
	                                            $map[$k][] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
	                                            /****该通道今日收款金额****/
	                                            $v['order_today_money'] = number_format(OrderModel::where($map[$k])->sum('order_price') , 2, ".", "");
	                                            /****该通道今日收款订单数****/
	                                            $v['order_today_count'] = OrderModel::where($map[$k])->count();
	                                            /***删除无需返回对象****/
	                                            unset($v['passageway_id']);
	                                            unset($v['payment']);
	                                            $lists[] = $v;
	                                        }
	                                        $json['status'] = 100;
	                                        $json['data'] = apiencode(array(
	                                            'merchant_uid' => Hashids::encode($dieinfo['member_id']) ,
	                                            'merchant_amount' => $dieinfo['merchant']['price'],
	                                            'ip' => $arr->getClientIp() ,
	                                            'passageway_type' => 2,
	                                            'passageway_list' => $lists
	                                        ));
	                                    } else {
	                                        Log::channel('order')->info("error : apiorder_id:{$orderinfo['Id']} -" . json_encode($orderinfo) . "\r\n");
	                                        $json['status'] = 101;
	                                        $json['msg'] = "订单处理失败,如有疑问请咨询客服";
	                                    }
                                    } else {
	                                    $json['status'] = 101;
                                        $json['msg'] = "订单金额不一致";
	                                }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "该订单已过期或已成功支付,如有疑问请咨询客服";
                                }
                            }
                            catch(\Exception $e) {
                                Log::channel('order')->info("error : apiorder_id:{$orderinfo['Id']} -" . json_encode($orderinfo) . "\r\n");
                                $json['status'] = 101;
                                $json['msg'] = "订单处理出现异常,已添加到日志";
                            }
                        } else {
                        	 Log::channel('order')->info("error :" . json_encode($postdata) . "\r\n");
                            $json['status'] = 101;
                            $json['msg'] = "非订单,可忽略,监控状态正常";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "Pollingid错误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "Pollingid有误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
    /***APP活码接收二维码****/
    public function qrcode(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['order_id'])) {
                    if (!empty($postdata['channel_code'])) {
                        if (!empty($postdata['qrcode_url'])) {
                            if ($postdata['channel_code'] == 909) {
                                $client = new Client();
                                $res = $client->request('get', $postdata['qrcode_url'], ['verify' => false, 'timeout' => 2]);
                                if ($res->getStatusCode() == 200) {
                                    $data = json_decode($res->getBody() , true);
                                    if ($data['code'] == '99') {
                                        preg_match("@】【(.*?)】不匹配@is", $getarr['desc'], $mid);
                                        preg_match("@merId=(.*?)&@is", $postdata['qrcode_url'], $mids);
                                        if (!empty($mid[1])) {
                                            if (!empty($mids[1])) {
                                                $qrdata['qrcode_url'] = str_replace("merId=" . $mids[1], "merId=" . $mid[1], $postdata['qrcode_url']);
                                            } else {
                                                $json['status'] = 101;
                                                $json['msg'] = "二维码通信规则有误";
                                            }
                                        } else {
                                            $json['status'] = 101;
                                            $json['msg'] = "二维码通信规则有误";
                                        }
                                    } else {
                                        $qrdata['qrcode_url'] = $data['codeUrl'];
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "二维码通信失败";
                                }
                            }else {
                                $qrdata['qrcode_url'] = $postdata['qrcode_url'];
                            }
                            if (!isset($json)) {
                                /***判断Redis是否存在此订单***/
                                if (Redis::exists(md5($postdata['order_id']))) {
                                    $orderinfo = json_decode(Redis::get(md5($postdata['order_id'])) , true);
                                    if (!isset($orderinfo['qrcode_url'])) {
                                        $orderinfo['qrcode_url'] = $qrdata['qrcode_url'];
                                        $redis_status = Redis::setex(md5($postdata['order_id']) , Redis::TTL(md5($postdata['order_id'])) , json_encode($orderinfo));
                                        $status = OrderModel::where('apiorder_id', $postdata['order_id'])->update($qrdata);
                                        if ($redis_status || $status) {
                                            $json['status'] = 100;
                                            $json['msg'] = "二维码接收成功";
                                        } else {
                                            $json['status'] = 101;
                                            $json['msg'] = "二维码接收错误,如有疑问请咨询客服";
                                        }
                                    } else {
                                        $json['status'] = 101;
                                        $json['msg'] = "该订单已上传过二维码";
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "该订单已过期或已成功支付";
                                }
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "二维码错误";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "通道代码错误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "订单号错误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
    /***APP固码上传二维码****/
    public function dieqrcode(Request $arr){
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
              if (!empty($postdata['polling_id'])) {
                    if (Hashids::decode($postdata['polling_id']) [0]) {
                        if (!empty($postdata['channel_key'])) {
                            if (!empty($postdata['qrcode'])) {
                               //查询该通道是否为804
                                $payment = DiepollingpaymentModel::where('key',$postdata['channel_key'])->with('user','payment','merchant')->first();
                                if($payment){
                                    if($payment->passageway_id != 804){
                                        $arrqr['passageway_id'] = $payment->passageway_id;
                                        $arrqr['qrcode'] = $postdata['qrcode'];
                                        if(checkqrcode($arrqr)){
                                            //查询平台是否存在该二维码
                                            $map[]=['qrcode','like','%'.$postdata['qrcode'].'%'];
                                            $qrinfo=DB::table('member_diepolling_payment')->where($map)->first();
                                            if(!$qrinfo || $qrinfo->key == $postdata['channel_key']){
                                                $status = DB::table('member_diepolling_payment')->where('Id',$payment->Id)->update(array('qrcode'=>$postdata['qrcode']));
                                                if($status){
                                                    if($payment->gateway_state == 1  && $payment->merchant->frozen_amount >=0 && $payment->merchant->price > 1 && $payment->user->loop == 1){
                                                        //判断平台出码方式
                                                        $admin_site=DB::table('admin_site')->first();
                                                        $order_redis = new Order_Redis;
                                                        //清除该通道二维码
	                                                    $order_redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$postdata['channel_key']));
	                                                    $order_redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$postdata['channel_key']));
	                                                    $order_redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$postdata['channel_key']));
	                                                    $order_redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$postdata['channel_key']));
                                                        if($admin_site->payment_type == 1){
                                                            if(stristr($payment->payment->paytype,'alipay') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::rpush('sort_alipay_die',json_encode($payment));
                                                            }
                                                            if(stristr($payment->payment->paytype,'aliwap') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::rpush('sort_aliwap_die',json_encode($payment));
                                                            }
                                                            if(stristr($payment->payment->paytype,'wechat') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::rpush('sort_wechat_die',json_encode($payment));
                                                            }
                                                            if(stristr($payment->payment->paytype,'unionpay') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::rpush('sort_unionpay_die',json_encode($payment));
                                                            }
                                                        }else{
                                                            if(stristr($payment->payment->paytype,'alipay') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::sadd('random_alipay_die',json_encode($payment));
                                                            }
                                                            if(stristr($payment->payment->paytype,'aliwap') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::sadd('random_aliwap_die',json_encode($payment));
                                                            }
                                                            if(stristr($payment->payment->paytype,'wechat') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::sadd('random_wechat_die',json_encode($payment));
                                                            }
                                                            if(stristr($payment->payment->paytype,'unionpay') !== false){
                                                                $payment->qrcode = $postdata['qrcode'];
                                                                Redis::sadd('random_unionpay_die',json_encode($payment));
                                                            }
                                                        }
                                                    }
                                                    $json['status'] = 100;
                                                    $json['msg'] = "上传成功!";
                                                }else{
                                                    $json['status'] = 101;
                                                    $json['msg'] = "当前二维码无更改,上传失败";
                                                }
                                            }else{
                                                $json['status'] = 101;
                                                $json['msg'] = "平台已拥有该二维码,如有疑问请咨询客服";
                                            }
                                        }else{
                                            $json['status'] = 101;
                                            $json['msg']= "当前二维码错误,如有疑问请咨询客服";
                                        }
                                    }else{
                                        $json['status'] = 101;
                                        $json['msg'] = "当前通道不支持操作二维码";
                                    }
                                }else{
                                    $json['status'] = 101;
                                    $json['msg'] = "当前收款账号不存在该通道";
                                }
                            } else {
                                $json['status'] = 101;
                                $json['msg'] = "二维码有误";
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "通道代码有误";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "Pollingid错误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "Pollingid有误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
    /***APP活码接收成功支付回调****/
    public function success(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['order_id'])) {
                    if (!empty($postdata['channel_code'])) {
                        if (!empty($postdata['money'])) {
                            try {
                                /***判断Redis是否存在此订单***/
                                if (Redis::exists(md5($postdata['order_id']))) {
                                    $orderinfo = json_decode(Redis::get(md5($postdata['order_id'])) , true);
                                    $polinfo = PollingModel::where('username',$orderinfo['polling_user'])->first();
                                    $admin_site = DB::table('admin_site')->first();
                                    $order_redis = new Order_Redis;
                                    if ($orderinfo['order_price'] == $postdata['money'] / 100) {
                                        if ($orderinfo['passageway_id'] == $postdata['channel_code']) {
                                            /****记录订单信息******/
                                            Log::channel('order_success')->info("apiorder_id :{$orderinfo['apiorder_id']} - notice:".json_encode($postdata)." - Redis :".json_encode($postdata['order_id'])."\r\n");
                                            //先获取该码商信息
                                            $merchant = DB::table('member')->where('Id',$orderinfo['member_id'])->first();
                                            /***删除Redis订单,并添加到Redis回调中****/
                                            $postarr['form']['user_id'] = $orderinfo['user_id'];
                                            $postarr['form']['order_id'] = $orderinfo['order_id'];
                                            $postarr['form']['apiorder_id'] = $orderinfo['apiorder_id'];
                                            $postarr['form']['amount'] = $orderinfo['order_money'];
                                            $postarr['form']['amount_actual'] = $orderinfo['order_price'];
                                            $postarr['form']['paytype'] = $orderinfo['type'];
                                            if (isset($orderinfo['remarks'])) {
                                                $postarr['form']['remarks'] = $orderinfo['remarks'];
                                            }
                                            $postarr['form']['success_time'] = time();
                                            $postarr['form']['sign'] = getsign($postarr['form'], $orderinfo['user_token']);
                                            $postarr['notify_url'] = $orderinfo['notify_url'];
                                            $postarr['number_notice'] = 0;
                                            //服务器处理该订单
                                            $status = OrderModel::where(array(
                                            	'apiorder_id' => $postdata['order_id'],
                                            	'polling_user' => $polinfo->username,
                                            	'order_price' => $postdata['money'] / 100
                                            	))->update(array(
                                                'status' => 2,
                                                'com_time' => time()
                                            ));
                                            if ($status) {
                                                //删除金额池
                                                Redis::lrem('amountpool', 1, json_encode(array(
                                                    'passageway_id' => $orderinfo['passageway_id'],
                                                    'polling_user' => $orderinfo['polling_user'],
                                                    'order_price' => $orderinfo['order_price'],
                                                    'exptime' => $orderinfo['com_time']
                                                )));
                                                //添加到Redis回调列表
			                                    $redis_status = Redis::rpush('ordernotice', json_encode($postarr));
			                                    //删除Redis订单
			                                    Redis::del(md5($postdata['order_id']));
                                                /***先处理商户余额以及添加余额明细****/
                                                $change_data['type'] = 1;
                                                $change_data['user_id'] = $orderinfo['user_id'];
                                                $change_data['amount'] = $orderinfo['order_price'] - $orderinfo['order_service'] - $orderinfo['software_service'];
                                                $change_data['time'] = time();
                                                //先获取商户原余额
                                                $price = DB::table('user')->where('Id', $change_data['user_id'])->first()->price;
                                                $change_data['user_price'] = $price + $change_data['amount'];
                                                //再给商户加余额
                                                $status = DB::table('user')->where('Id', $change_data['user_id'])->update(array(
                                                    'price' => $change_data['user_price']
                                                ));
                                                if (!$status) {
                                                     //记录加余额失败用户
		                                            $amount_error_a['form']['apiorder_id'] = $orderinfo['apiorder_id'];
		                                            $amount_error_a['form']['user_id'] = $change_data['user_id'];
		                                            $amount_error_a['form']['amount'] = $change_data['amount'];
		                                            $amount_error_a['type'] = 1001;
		                                            Redis::rpush('order_amount_error',json_encode($amount_error_a));
                                                }
                                                //添加商户余额明细
                                                $addstatus = DB::table('user_amount_change')->insert($change_data);
                                                if (!$addstatus) {
                                                    //记录加余额明细失败用户
		                                            $amount_error_b['form'] = $change_data;
		                                            $amount_error_b['type'] = 1002;
		                                            Redis::rpush('order_amount_error',json_encode($amount_error_b));
                                                }
                                                /***再次处理码商余额以及添加余额明细****/
                                                $change_datas['type'] = 1;
                                                $change_datas['member_id'] = $orderinfo['member_id'];
                                                $change_datas['amount'] = number_format($orderinfo['order_price'] - $orderinfo['order_service'] - $orderinfo['software_service'] + $orderinfo['passageway_service'],3,".","");
                                                $change_datas['time'] = $change_data['time'];
                                                //先获取码商原余额
                                                $price = $merchant->price;
                                                if($price >= $change_datas['amount']){
                                                    $change_datas['member_price'] = $price - $change_datas['amount'];
                                                    $merchant_updata['price'] = $change_datas['member_price'];
                                                }else{
                                                    //码商余额清0再扣除冻结金额
                                                    $change_datas['member_price'] = 0;
                                                    $merchant_updata['price'] = 0;
                                                    $merchant_updata['frozen_amount'] = $merchant->frozen_amount-($change_datas['amount']-$price);
                                                    //额外加码商冻结余额明细
                                                    $change_dataf['type'] = 3;
                                                    $change_dataf['member_id'] = $orderinfo['member_id'];
                                                    $change_dataf['amount'] =$change_datas['amount']-$price;
                                                    $change_dataf['member_price'] = 0;
                                                    $change_dataf['time'] = $change_data['time'];
                                                }
                                                //再给码商扣除余额
                                                $merchantstatus = DB::table('member')->where('Id', $change_datas['member_id'])->update($merchant_updata);
                                                if (!$merchantstatus) {
                                                     //记录扣余额失败码商
		                                            $amount_error_c['form']['apiorder_id'] = $orderinfo['apiorder_id'];
		                                            $amount_error_c['form']['member_id'] = $change_datas['member_id'];
		                                            $amount_error_c['form']['amount'] = $change_datas['amount'];
		                                            $amount_error_c['type'] = 2001;
		                                             Redis::rpush('order_amount_error',json_encode($amount_error_c));
                                                }
                                                //添加码商余额明细
                                                $memberamountadd = DB::table('member_amount_change')->insert($change_datas);
                                                if (!$memberamountadd) {
                                                    //记录加余额明细失败码商
		                                            $amount_error_d['form'] = $change_datas;
		                                            $amount_error_d['type'] = 2002;
		                                            Redis::rpush('order_amount_error',json_encode($amount_error_d));
                                                }
                                                //存在余额不足时
                                                if(isset($change_dataf)){
                                                    //添加冻结余额明细
                                                    $memberfrozen_amountadd = DB::table('member_amount_change')->insert($change_dataf);
                                                    if (!$memberfrozen_amountadd) {
                                                        //记录加冻结余额明细失败码商
		                                                $amount_error_f['form'] = $change_dataf;
		                                            	$amount_error_f['type'] = 2003;
		                                            	Redis::rpush('order_amount_error',json_encode($amount_error_f));
                                                    }
                                                    //发送通知踢下线
                                                    $content['type'] = "loseuser";
                                                    $content['msg'] = "当前账户已在别处登录或被强制下线";
                                                    $polling = DB::table('member_polling')->where('username',$orderinfo['polling_user'])->first();
                                                    if($polling){
                                                    	//清除该账号二维码
		                                            	$redis_data['polling_id']= $polling->Id;
								                        /****删除支付宝二维码****/
								                        $order_redis->delete($admin_site->payment_type,'alipay',2,$redis_data);
								                        /****删除支付宝H5二维码****/
								                        $order_redis->delete($admin_site->payment_type,'aliwap',2,$redis_data);
								                        /****删除微信二维码****/
								                        $order_redis->delete($admin_site->payment_type,'wechat',2,$redis_data);
								                        /****删除银联二维码****/
								                        $order_redis->delete($admin_site->payment_type,'unionpay',2,$redis_data);
                                                        Gateway::sendToClient($polling->token,json_encode($content));
                                                    }
                                                }
                                                //清除该二维码
	                                            $order_redis->delete($admin_site->payment_type,'alipay',2,array('key'=>$orderinfo['polling_passageway_key']));
	                                            $order_redis->delete($admin_site->payment_type,'aliwap',2,array('key'=>$orderinfo['polling_passageway_key']));
	                                            $order_redis->delete($admin_site->payment_type,'wechat',2,array('key'=>$orderinfo['polling_passageway_key']));
	                                            $order_redis->delete($admin_site->payment_type,'unionpay',2,array('key'=>$orderinfo['polling_passageway_key']));
	                                            //清除该二维码出码记录
	                                            $order_redis->query_delete('alipay',2,$orderinfo['polling_passageway_key']);
	                                            $order_redis->query_delete('aliwap',2,$orderinfo['polling_passageway_key']);
	                                            $order_redis->query_delete('wechat',2,$orderinfo['polling_passageway_key']);
	                                            $order_redis->query_delete('unionpay',2,$orderinfo['polling_passageway_key']);
	                                            //添加该二维码
	                                            $payment_live  = LivepollingpaymentModel::where('key',$orderinfo['polling_passageway_key'])->with('user','payment','merchant')->first();
	                                            if($payment_live->merchant->price > 1 && $payment_live->merchant->frozen_amount >= 0 && $payment_live->user->status == 1 && $payment_live->user->loop == 1 && $payment_live->gateway_state ==1){
							                        if($admin_site->payment_type == 1){
		                                                if(stristr($payment_live->payment->paytype,'alipay') !== false){
		                                                    Redis::rpush('sort_alipay_live',json_encode($payment_live));
		                                                }
		                                                if(stristr($payment_live->payment->paytype,'aliwap') !== false){
		                                                    Redis::rpush('sort_aliwap_live',json_encode($payment_live));
		                                                }
		                                                if(stristr($payment_live->payment->paytype,'wechat') !== false){
		                                                    Redis::rpush('sort_wechat_live',json_encode($payment_live));
		                                                }
		                                                if(stristr($payment_live->payment->paytype,'unionpay') !== false){
		                                                    Redis::rpush('sort_unionpay_live',json_encode($payment_live));
		                                                }
		                                            }else{
		                                                if(stristr($payment_live->payment->paytype,'alipay') !== false){
		                                                    Redis::sadd('random_alipay_live',json_encode($payment_live));
		                                                }
		                                                if(stristr($payment_live->payment->paytype,'aliwap') !== false){
		                                                    Redis::sadd('random_aliwap_live',json_encode($payment_live));
		                                                }
		                                                if(stristr($payment_live->payment->paytype,'wechat') !== false){
		                                                    Redis::sadd('random_wechat_live',json_encode($payment_live));
		                                                }
		                                                if(stristr($payment_live->payment->paytype,'unionpay') !== false){
		                                                    Redis::sadd('random_unionpay_live',json_encode($payment_live));
		                                                }
		                                            }
							                    }
                                                /****任务下发后判断当前通道是否限额****/
                                                $liveinfo = LivepollingpaymentModel::where('key', $orderinfo['polling_passageway_key'])->with('merchant', 'payment')->first()->toarray();
                                                $Order_Redis = new Order_Redis;
                                                $admin_site = DB::table('admin_site')->first();
                                                //该通道的二维码池Redis参数
                                                $redis_data['key'] = $liveinfo['key'];
                                                if ($liveinfo['today_money'] != 0) {
                                                    //获取当天交易订单额
                                                    $map['status'] = 2;
                                                    $map['polling_passageway_key'] = $liveinfo['key'];
                                                    $map[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
                                                    $map[] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
                                                    $today_money = OrderModel::where($map)->sum('order_price');
                                                    if ($today_money >= $liveinfo['today_money']) {
                                                        //清除该通道二维码
                                                        $Order_Redis->delete($admin_site->payment_type,$orderinfo['paytype'],2,$redis_data);
                                                        //关闭该通道网关
                                                        LivepollingpaymentModel::where('key', $liveinfo['key'])->update(array(
                                                            'gateway_state' => 2
                                                        ));

                                                        $json['msg'] = date('Y-m-d H:i:s') . "- {$orderinfo['apiorder_id']} -订单处理成功," . $liveinfo['payment']['name'] . "通道已达到当日限额,已自动关闭网关,如还想继续使用,请到平台修改当日限额后再开启通道";
                                                    }
                                                } else if ($liveinfo['total_money'] != 0) {
                                                    //获取总交易订单额
                                                    $map['status'] = 2;
                                                    $map['polling_passageway_key'] = $liveinfo['key'];
                                                    $total_money = OrderModel::where($map)->sum('order_price');
                                                    if ($total_money >= $liveinfo['total_money']) {
                                                        //清除该通道二维码
                                                        $Order_Redis->delete($admin_site->payment_type,$orderinfo['paytype'],2,$redis_data);
                                                        //关闭该通道网关
                                                        LivepollingpaymentModel::where('key', $liveinfo['key'])->update(array(
                                                            'gateway_state' => 2
                                                        ));
                                                        $json['msg'] = date('Y-m-d H:i:s') . "- {$orderinfo['apiorder_id']} -订单处理成功," . $liveinfo['payment']['name'] . "通道已达到总限额,已自动关闭网关,如还想继续使用,请到平台修改总限额后再开启通道";
                                                    }
                                                } else {
                                                    $json['msg'] = date('Y-m-d H:i:s') . "- {$orderinfo['apiorder_id']} -订单处理成功";
                                                }
                                                //修改后再查询可用通道
                                                $list = LivepollingpaymentModel::where('polling_id', $liveinfo['polling_id'])->select('passageway_id', 'key', 'today_money','gateway_state')->with(['payment' => function ($query) {
                                                    $query->select('Id', 'name');
                                                }
                                                ])->get()->toarray();
                                                //然后遍历查询当天收款
                                                foreach ($list as $k => $v) {
                                                    $v = (array)$v;
                                                    $v['channel_code'] = $v['passageway_id'];
                                                    $v['channel_key'] = $v['key'];
                                                    $v['channel_name'] = $v['payment']['name'];
                                                    $v['channel_img'] = 'http://' . $_SERVER['HTTP_HOST'] . "/merchants/icon/" . $v['passageway_id'] . ".png";
                                                    $map[$k]['status'] = 2;
                                                    $map[$k]['polling_passageway_key'] = $v['key'];
                                                    $map[$k][] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
                                                    $map[$k][] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
                                                    /****该通道今日收款金额****/
                                                    $v['order_today_money'] = number_format(OrderModel::where($map[$k])->sum('order_price') , 2, ".", "");
                                                    /****该通道今日收款订单数****/
                                                    $v['order_today_count'] = OrderModel::where($map[$k])->count();
                                                    /***删除无需返回对象****/
                                                    unset($v['passageway_id']);
                                                    unset($v['payment']);
                                                    unset($v['key']);
                                                    $lists[] = $v;
                                                }
                                                $json['status'] = 100;
                                                $json['data'] = apiencode(array(
                                                    'merchant_uid' => Hashids::encode($liveinfo['member_id']) ,
                                                    'merchant_amount' => $liveinfo['merchant']['price'],
                                                    'ip' => $arr->getClientIp() ,
                                                    'passageway_type' => 2,
                                                    'passageway_list' => $lists
                                                ));
                                            } else {
                                                Log::channel('order')->info("error : apiorder_id:{$orderinfo['Id']} -" . json_encode($orderinfo) . "\r\n");
                                                $json['status'] = 101;
                                                $json['msg'] = "订单处理失败,如有疑问请咨询客服";
                                            }
                                        } else {
                                            $json['status'] = 101;
                                            $json['msg'] = "订单通道代码不一致";
                                        }
                                    } else {
                                        $json['status'] = 101;
                                        $json['msg'] = "订单支付金额与打款金额不一致";
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "该订单已处理成功或已过期,如有疑问请咨询客服";
                                }
                            }
                            catch(\Exception $e) {
                                Log::channel('order')->info("error : apiorder_id:{$orderinfo['apiorder_id']} - exception :".$e. json_encode($orderinfo) . "\r\n");
                                $json['status'] = 101;
                                $json['msg'] = "订单处理出现异常,已添加到日志";
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "金额错误";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "通道代码错误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "订单号错误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
    /***APP网关操作****/
    public function channel(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['polling_id'])) {
                    if (Hashids::decode($postdata['polling_id']) [0]) {
                        if (!empty($postdata['channel_key'])) {
                            if ($postdata['change'] == 'open' || $postdata['change'] == 'close') {
                                //首先查询该账号模式
                                $pollinginfo = DB::table('member_polling')->where('Id', Hashids::decode($postdata['polling_id']) [0])->first();
                                if ($pollinginfo) {
                                    if ($pollinginfo->type == 1) {
                                        $payment = new DiepollingpaymentModel;
                                        //查询当前二维码是否为空
                                        $info = $payment->where('key', $postdata['channel_key'])->first();
                                        if($info->qrcode == 2){
                                            $json['status'] = 101;
                                            $json['msg'] = "请先上传二维码后再开启网关哦";
                                        }
                                    } else {
                                        $payment = new LivepollingpaymentModel;
                                        $info = $payment->where('key', $postdata['channel_key'])->first();
                                    }
                                    if(!isset($json)){
                                        if ($postdata['change'] == 'open') {
                                            $updata['gateway_state'] = 1;
                                            $json['msg'] = "操作失败,该通道网关已开启过了哦";
                                        } else {
                                            $updata['gateway_state'] = 2;
                                            $json['msg'] = "操作失败,该通道网关已关闭过了哦";
                                        }
                                        $status = $payment->where('key', $postdata['channel_key'])->update($updata);
                                        if ($status) {
                                            //判断平台出码方式
                                            $admin_site=DB::table('admin_site')->first();
                                            $order_redis = new Order_Redis;
                                            //清除该通道二维码
                                            $order_redis->delete($admin_site->payment_type,'alipay',$pollinginfo->type,array('key'=>$postdata['channel_key']));
                                            $order_redis->delete($admin_site->payment_type,'aliwap',$pollinginfo->type,array('key'=>$postdata['channel_key']));
                                            $order_redis->delete($admin_site->payment_type,'wechat',$pollinginfo->type,array('key'=>$postdata['channel_key']));
                                            $order_redis->delete($admin_site->payment_type,'unionpay',$pollinginfo->type,array('key'=>$postdata['channel_key']));
                                            $order_redis_info = $payment->where(array('key'=>$postdata['channel_key']))->with('user','payment','merchant')->first();
                                            $typename = $pollinginfo->type == 1 ? 'die' : 'live';
                                            if($updata['gateway_state'] == 1 && $order_redis_info->merchant->price >1 && $order_redis_info->user->loop == 1 && $order_redis_info->merchant->frozen_amount >= 0){
                                            	//添加到Redis
                                                if($admin_site->payment_type == 1){
                                                    if(stristr($info->payment->paytype,'alipay') !== false){
                                                        Redis::rpush('sort_alipay_'.$typename,json_encode($order_redis_info));
                                                    }
                                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                                        Redis::rpush('sort_aliwap_'.$typename,json_encode($order_redis_info));
                                                    }
                                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                                        Redis::rpush('sort_wechat_'.$typename,json_encode($order_redis_info));
                                                    }
                                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                                        Redis::rpush('sort_unionpay_'.$typename,json_encode($order_redis_info));
                                                    }
                                                }else{
                                                    if(stristr($info->payment->paytype,'alipay') !== false){
                                                        Redis::sadd('random_alipay_'.$typename,json_encode($order_redis_info));
                                                    }
                                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                                        Redis::sadd('random_aliwap_'.$typename,json_encode($order_redis_info));
                                                    }
                                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                                        Redis::sadd('random_wechat_'.$typename,json_encode($order_redis_info));
                                                    }
                                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                                        Redis::sadd('random_unionpay_'.$typename,json_encode($order_redis_info));
                                                    }
                                                }
                                            }
                                            $json['status'] = 100;
                                            $json['msg'] = "操作成功";
                                        } else {
                                            $json['status'] = 101;
                                        }
                                    }
                                } else {
                                    $json['status'] = 101;
                                    $json['msg'] = "当前收款账号不存在";
                                }
                            } else {
                                $json['status'] = 101;
                                $json['msg'] = "操作代码有误";
                            }
                        } else {
                            $json['status'] = 101;
                            $json['msg'] = "通道代码有误";
                        }
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "Pollingid错误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "Pollingid有误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
      return $json;
    }
    /****APP退出登录****/
    public function loseapp(Request $arr) {
        if ($arr->filled('content')) {
            $postdata = apidecode($arr->input('content'));
            if ($postdata) {
                if (!empty($postdata['polling_id'])) {
                    if (Hashids::decode($postdata['polling_id']) [0]) {
                        $data['token'] = null;
                        $data['status'] = 2;
                        $status = PollingModel::where('Id', Hashids::decode($postdata['polling_id']) [0])->update($data);
                    	/****删除此账户所有二维码****/
                        $Order_Redis = new Order_Redis;
                        /****获取账户类型****/
                        $polling = PollingModel::where('Id', Hashids::decode($postdata['polling_id']) [0])->first();
                        $code_type = $polling->type;
                        $admin_site = DB::table('admin_site')->first();
                        $data['polling_id']= $polling->Id;
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',$code_type,$data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',$code_type,$data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',$code_type,$data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',$code_type,$data);
                        $json['status'] = 100;
                        $json['msg'] = "成功退出!";
                    } else {
                        $json['status'] = 101;
                        $json['msg'] = "Pollingid有误";
                    }
                } else {
                    $json['status'] = 101;
                    $json['msg'] = "Pollingid错误";
                }
            } else {
                $json['status'] = 101;
                $json['msg'] = "加密方式有误";
            }
        } else {
            $json['status'] = 101;
            $json['msg'] = "不安全的提交方式";
        }
        return $json;
    }
}

