<?php
namespace App\Http\Controllers\Common;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
class Alipay extends Controller {

	/**支付宝提现接口*/
    public function toTransfer($orderNo,$account,$amount,$payeeRealName)
    {    
        $payer_show_name = '用户提现';
        $remark = '支付宝提现';
        $aop = new \AopClient();
        $aop->gatewayUrl = 'https://openapi.alipay.com/gateway.do';
        $aop->appId = DB::table('admin_site')->first()->appid;
        $aop->rsaPrivateKey =DB::table('admin_site')->first()->rsaprivatekey;
        //此处无需公钥
        //$aop->alipayrsaPublicKey = "";
        $aop->apiVersion = '1.0';
        $aop->signType = 'RSA2';
        $aop->postCharset = 'UTF-8';
        $aop->format = 'json';
        $request = new \AlipayFundTransToaccountTransferRequest();
        $request->setBizContent("{" .
            "\"out_biz_no\":\"$orderNo\"," .
            "\"payee_type\":\"ALIPAY_LOGONID\"," .
            "\"payee_account\":\"$account\"," .
            "\"amount\":\"$amount\"," .
            "\"payee_real_name\":\"$payeeRealName\"," .
            "\"remark\":\"$remark\"" .
            "}");
        $result = $aop->execute($request);
        $responseNode = str_replace(".", "_", $request->getApiMethodName()) . "_response";
        $resultCode = $result->$responseNode->code;

        if(!empty($resultCode) && $resultCode == 10000){
            return array("code"=>$resultCode,"msg"=>"处理成功!","date"=>$result->$responseNode->pay_date);
        }else{
            return array("code"=>$resultCode,"msg"=>$result->$responseNode->sub_msg);
        }
        
    }
}