<?php
/* +----------------------------------------------------------------------+
   | Copyright (c) 2018-2019 YmPay                                        |
   |              <530759076@qq.com>                                      |
   +----------------------------------------------------------------------+*/
namespace App\Http\Controllers\Daili;
use Vinkla\Hashids\Facades\Hashids;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Models\OrderModel;
use App\Http\Models\DailiDrawingModel;
use App\Http\Models\MemberpaymentModel;
use App\Http\Models\PaymentModel;
use App\Http\Models\DiepollingpaymentModel;
use App\Http\Models\LivepollingpaymentModel;
use App\Http\Models\QrcodeErrorModel;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Common\Alipay;
use App\Http\Controllers\Common\Google;
use App\Http\Controllers\Common\Order_Redis;
use GatewayClient\Gateway;
use Illuminate\Support\Facades\Redis;
use QrCode;

class DailiController extends DailiCommonController{
	/****后台首页****/
	public function main(Request $arr){


	   		//if($arr->input('action') == 'text'){
	   			/***总成功订单量****/
	   			$json['data']['text']['order_success_num']=DB::table('order')->where('status',2)->whereIn('user_id',  $this->my_uids)->count();
	   			/***总成功订单额****/
	   			$json['data']['text']['order_success_money']=DB::table('order')->where('status',2)->whereIn('user_id', $this->my_uids)->sum('order_price');
	   			/***总商户数量*****/
	   			$json['data']['text']['member_num']= DB::table('daili')->whereIn('id',  $this->my_uids)->count();
	   			/***总码商数量****/
	   			//$json['data']['text']['merchant_num']=DB::table('member')->count();
	   			/****当月订单量****/
	   			$map[] = ['status', '=', 2];
					//$map[] = ['user_id', 'in', $this->my_uids];
					$map[] = ['in'=>['user_id' => $this->my_uids]];
	   			$map[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
	   			$map[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*30];
	   			$json['data']['text']['order_month_success_num']=DB::table('order')->where($map)->count();
	   			/****当日订单额****/
	   			$map2[] = ['status', '=', 2];
				//	$map2[] = ['user_id', 'in', $this->my_uids];
					//$map2[] = ['in'=>['user_id' => $this->my_uids]];
	   			$map2[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
	   			$map2[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))];
					//print_r($map2);exit;
	   			$json['data']['text']['order_day_success_money']=DB::table('order')->whereIn('user_id', $this->my_uids)->where($map2)->sum('order_price');


					//print_r($json['data']['text']['order_day_success_money']);exit;
	   			/****当日订单额占总额比例****/
	   			$json['data']['text']['order_day_success_money_comparison']=$json['data']['text']['order_success_money'] == 0 ? 0 : ceil($json['data']['text']['order_day_success_money']/$json['data']['text']['order_success_money']*100);
	   			/****上月订单量****/
	   			$map3[] = ['status', '=', 2];
				//	$map3[] = ['user_id', 'in', $this->my_uids];
					$map3[] = ['in'=>['user_id' => $this->my_uids]];
	   			$map3[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))-86400*30];
	   			$map3[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*60];
	   			$json['data']['text']['order_lastmonth_success_num']=DB::table('order')->where($map3)->count();

					///-----------
					$map_a[] = ['type', '=', 1];
				//	$map2[] = ['user_id', 'in', $this->my_uids];
					$map_a[] = ['in'=>['user_id' => $this->my_uids]];
	   			$map_a[]=['time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
	   			$map_a[]=['time','>=',strtotime(date('Y-m-d 00:00:00'))];
					$json['data']['text']['order_day_success_money_in']=DB::table('daili_amount_change')->where($map_a)->sum('amount');
	   			/****当月与上月对比同比***/
	   			if($json['data']['text']['order_lastmonth_success_num'] != 0){
                    if($json['data']['text']['order_lastmonth_success_num']>$json['data']['text']['order_month_success_num']){
                    $json['data']['text']['monthly_comparison']='-'.number_format(($json['data']['text']['order_lastmonth_success_num']-$json['data']['text']['order_month_success_num'])/$json['data']['text']['order_lastmonth_success_num']*100,2,".","").'%';
                    }else{
                        $json['data']['text']['monthly_comparison']='+'.number_format(($json['data']['text']['order_month_success_num']-$json['data']['text']['order_lastmonth_success_num'])/$json['data']['text']['order_lastmonth_success_num']*100,2,".","").'%';
                    }
          }else{
              $json['data']['text']['monthly_comparison']='+100%';
          }
          /***当月新增商户数量****/
					//$map4[] = ['Id', 'IN', $this->my_uids];
					$map4[] = ['in'=>['Id' => $this->my_uids]];
          $map4[]=['time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
					//print_r($map4);exit;
	   			$map4[]=['time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*30];

					//print_r($map4);exit;
	   			$json['data']['text']['member_regmonth_num']= DB::table('user')->where($map4)->count();
					//print_r($json['data']['text']['member_regmonth_num']);exit;
	   			/***当月新注册前3商户组*****/
	   			$json['data']['text']['member_regtop3']= DB::table('user')->where($map4)->orderBy('id','desc')->take(3)->select('Id','phone')->get()->toarray();
	   			/***当月新增码商数量****/
	   			//$json['data']['text']['merchant_regmonth_num']=DB::table('member')->where($map4)->count();
	   			/***当月新注册前3码商组*****/
	   			//$json['data']['text']['merchant_regtop3']=DB::table('member')->where($map4)->orderBy('id','desc')->take(3)->select('Id','phone')->get()->toarray();

	   		//}
			//print_r($this->dailiInfo);exit;
	   	return view('daili/main',['data' => $json['data']['text'], 'dailiInfo' => $this->dailiInfo]);
	}



	public function memberlist(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('field') && $arr->input('field')!='-1' && $arr->filled('value')){
					$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
				}
				if($arr->filled('type') && $arr->input('type')!= '-1' ){
					$map['type']=intval($arr->input('type'));
				}
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				if($arr->filled('status')){
					if($arr->input('status') == "全部"){
						$map[]=['status','!=',null];
					}else if($arr->input('status') == "正常"){
						$map[]=['status',1];
					}else{
						$map[]=['status',2];
					}
				}else{
					$map[]=['status','!=',null];
				}

				$map[] = ['daili_id', '=', $this->dailiInfo['Id']];
			   $listpage=DB::table('user')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
			   /****总码商个数****/
			   $json['data']['toptext']['user_count']=DB::table('user')->where('daili_id',  $this->dailiInfo['Id'])->count();
			   /****正常码商个数****/
			   $map2['status']=1;
				 $map2[] = ['daili_id', '=', $this->dailiInfo['Id']];
			   $json['data']['toptext']['user_normal']=DB::table('user')->where($map2)->count();
			   /****冻结码商个数****/
			   $map2['status']=2;
			   $json['data']['toptext']['user_frozen']=DB::table('user')->where($map2)->count();
			   /****总码商可用余额****/
			   $json['data']['toptext']['user_price']=number_format(DB::table('user')->where('daili_id',  $this->dailiInfo['Id'])->sum('price'),2,".","");
			   if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$v['order_service'] = $v['order_service']*100;
	       	  			$v['safety_service'] = $v['safety_service']*100;
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'passageway'){
				/****获取所有固码****/
				$json['data']['diepassageway']=DB::table('die_passageway')->where('status',1)->get()->toarray();
				/****获取所有活码****/
				$json['data']['livepassageway']=DB::table('live_passageway')->where('status',1)->get()->toarray();
			}else if($arr->input('action') == 'add'){
				$postdata = $arr->input('form');
				if(checkphone($postdata['phone'])){
					//查询是否存在该手机号商户
				   if(!DB::table('user')->where('phone',$postdata['phone'])->first()){
					if(checkpass($postdata['password'])){
						if((float)$postdata['order_service'] >= '0.01'){
							if((float)$postdata['safety_service'] >= '0.01'){
								if(!empty($postdata['diepassageway']) || !empty($postdata['livepassageway'])){
										$adddata['phone'] = $postdata['phone'];
										$adddata['password'] = xpass($postdata['password']);
										$ga = new Google;
										$adddata['safetycode'] = $ga->createSecret();
										$adddata['type'] = $postdata['type'];
										$adddata['price'] = intval($postdata['price']) <= 0 ? 0 : (float)$postdata['price'];
											$adddata['order_service'] = $postdata['order_service']/100;
										$adddata['safety_service'] = $postdata['safety_service']/100;
										$adddata['token'] = getusertoken();
										$adddata['time'] = time();
										$adddata['status'] = $postdata['status'];
										$adddata['daili_id'] = $this->dailiInfo['Id'];
										$adddata['daili_phone'] = $this->dailiInfo['phone'];
										$status = DB::table('user')->insertGetId($adddata);
										if($status){
											//添加支持商户通道
											if(!empty($postdata['diepassageway'])){
												if($postdata['diepassageway'] == '-1' || in_array('-1',$postdata['diepassageway'])){
													$payment=DB::table('die_passageway')->where('status',1)->select('Id')->get()->toarray();
													foreach ($payment as $v) {
														$v = (array)$v;
														$v['passageway_id'] =$v['Id'];
									                    $v['passageway_type'] = 1;
									                    $v['user_id'] = $status;
									                    unset($v['Id']);
									                    $addpayment[] = $v;
													}
												}else{
													foreach ($postdata['diepassageway'] as $v) {
														$addpayment[]=array('user_id'=>$status,'passageway_id'=>$v,'passageway_type'=>1);
													}
												}

											}
											if(!empty($postdata['livepassageway'])){
												if($postdata['livepassageway'] == '-1' || in_array('-1',$postdata['livepassageway'])){
													$payment=DB::table('live_passageway')->where('status',1)->select('Id')->get()->toarray();
													foreach ($payment as $v) {
														$v = (array)$v;
														$v['passageway_id'] =$v['Id'];
									                    $v['passageway_type'] = 2;
									                    $v['user_id'] = $status;
									                    unset($v['Id']);
									                    $addpayment[] = $v;
													}
												}else{
													foreach ($postdata['livepassageway'] as $v) {
														$addpayment[]=array('user_id'=>$status,'passageway_id'=>$v,'passageway_type'=>2);
													}
												}
											}
											$payment_status = DB::table('userpayment')->insert($addpayment);
											if($payment_status){
												$json['status']="ok";
												$json['msg']="商户添加成功,当前添加商户ID:{$status}";
											}else{
												$json['status']="ok";
												$json['msg']="商户添加成功,通道添加失败,添加商户ID:{$status}";
											}
										}else{
											$json['status'] = "error";
											$json['msg'] = "出现错误,商户添加失败";
										}
								}else{
									$json['status'] = "error";
									$json['msg'] = "请至少选择一个通道";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "通道费率不能低于0.01%哦";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "订单费率不能低于0.01%哦";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "密码不符合规则";
					}
				   }else{
				   		$json['status'] = "error";
						$json['msg'] = "当前手机号商户已存在";
				   }
				}else{
					$json['status'] = "error";
					$json['msg'] = "请输入正确的手机号";
				}
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				if((float)$data['order_service'] >= '0.01'){
					if((float)$data['safety_service'] >= '0.01'){
						if(!empty($data['phone'])){
							if(!checkphone($data['phone'])){
								$json['status'] = "error";
								$json['msg'] = "请填写正确的手机号";
							}else{
								if(!DB::table('user')->where('phone',$data['phone'])->first()){
									$updata['phone'] = $data['phone'];
								}else{
									$json['status'] = "error";
									$json['msg'] = "当前手机号商户已存在";
								}
							}
						}
						if(!empty($data['member_arr'])){
							$arr_id = explode(",",$data['member_arr']);
							if(is_array($arr_id)){
								foreach ($arr_id as $v){
									$merchant = DB::table('member')->where('Id',$v)->first();
									if(!$merchant){
										$json['status'] = "error";
										$json['msg'] = "未找到当前Id为".$v."的码商";break;
									}
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "请填写正确的格式的指定码商";
							}
						}
						if(!empty($data['password'])){
							if(!checkpass($data['password'])){
								$json['status'] = "error";
								$json['msg'] = "请填写6~20位的密码";
							}else{
								$updata['password'] = xpass($data['password']);
							}
						}
						if(!isset($json)){
							$updata['member_arr'] = $data['member_arr'];
							$updata['type'] = $data['type'];
							$updata['order_service'] = $data['order_service']/100;
							$updata['safety_service'] = $data['safety_service']/100;
							$updata['status'] = $data['status'];

							$status = DB::table('user')->where('Id',$data['Id'])->update($updata);
							if($status){
								$json['status'] = "ok";
								$json['msg'] = "修改成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "当前无更改,修改失败";
							}
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "单笔通道费率不能低于0.01%";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "单笔订单费率不能低于0.01%";
				}
			}else if($arr->input('action') == 'amount'){
				$data =$arr->input('form');
				if(!empty($data['Id'])){
					 $user = DB::table('user')->where('Id',$data['Id'])->first();
					if(!empty($data['price'])){
						if($data['price'] != 0){
							if($data['price'] < 0){
								$amount_change['type'] = 6;
								$amount_change['amount'] = abs($data['price']);
							}else{
								$amount_change['type'] = 5;
								$amount_change['amount'] = $data['price'];
							}
							$updata['price'] = $user->price+$data['price'];
							$status = DB::table('user')->where('Id',$data['Id'])->update($updata);
							if($status){
								//添加商户余额明细
								$amount_change['user_id'] = $data['Id'];
								$amount_change['user_price'] = $updata['price'];
								$amount_change['time'] = time();
								DB::table('user_amount_change')->insert($amount_change);
								$json['status'] = "ok";
								$json['msg'] = "充值成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "金额充值失败";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "充值金额不得为0";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请输入充值可用金额";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "提交参数错误";
				}
			}else if($arr->input('action') == 'login'){
				$data = $arr->input('form');
				//查询当前用户是否存在
				$user = DB::table('user')->where('Id',$data['Id'])->first();
				if($user){
					//设置ssession
					session()->put('user',(array)$user);
					$json['status'] = "ok";
					$json['url'] = 'http://'.config('route.domain.member');
					$json['msg'] = "验证成功";
				}else{
					$json['status']="error";
					$json['msg']="当前商户不存在";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							//查询当前商户是否存在资金明细
							if(DB::table('user_amount_change')->where('user_id',$v['Id'])->first()){
								$amount[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在登录日志
							if(DB::table('user_log')->where('user_id',$v['Id'])->first()){
								$loginlog[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在升级记录
							if(DB::table('user_upgradepay')->where('user_id',$v['Id'])->first()){
								$paylog[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在提现账户
							if(DB::table('user_cash_account')->where('user_id',$v['Id'])->first()){
								$cash[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在提现记录
							if(DB::table('user_drawing')->where('user_id',$v['Id'])->first()){
								$drawing[] =['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在APP支持通道
							if(DB::table('userpayment')->where('user_id',$v['Id'])->first()){
								$payment[] = ['user_id','=',$v['Id']];
							}
							$deldata[]=['Id','=',$v['Id']];
						}else{
							//查询当前商户是否存在资金明细
							if(DB::table('user_amount_change')->where('user_id',$v['Id'])->first()){
								$amount[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在登录日志
							if(DB::table('user_log')->where('user_id',$v['Id'])->first()){
								$loginlog[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在升级记录
							if(DB::table('user_upgradepay')->where('user_id',$v['Id'])->first()){
								$paylog[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在提现账户
							if(DB::table('user_cash_account')->where('user_id',$v['Id'])->first()){
								$cash[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在提现记录
							if(DB::table('user_drawing')->where('user_id',$v['Id'])->first()){
								$drawing[] =['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在APP支持通道
							if(DB::table('userpayment')->where('user_id',$v['Id'])->first()){
								$payment[] = ['user_id','=',$v['Id'],'or'];
							}
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
						//先删除各种数据
						if(isset($amount)){
							DB::table('user_amount_change')->where($amount)->delete();
						}
						if(isset($loginlog)){
							DB::table('user_log')->where($loginlog)->delete();
						}
						if(isset($paylog)){
							DB::table('user_upgradepay')->where($paylog)->delete();
						}
						if(isset($cash)){
							DB::table('user_cash_account')->where($cash)->delete();
						}
						if(isset($drawing)){
							DB::table('user_drawing')->where($drawing)->delete();
						}
						if(isset($payment)){
							DB::table('userpayment')->where($payment)->delete();
						}
						$num = DB::table('user')->where($deldata)->delete();
						if($num == 0){
							$json['status'] = "error";
							$json['msg'] = "删除失败,出现错误";
						}else{
							$json['status'] = "ok";
							$json['msg'] = "删除成功,共删除{$num}条";
						}
					}else{
						$json['status']="error";
						$json['msg']="提交出现错误,请刷新重试";
					}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('daili/memberlist');
	}

	/****后台商户登录记录****/
	public function member_loginlog(Request $arr){
		if($arr->isMethod('post')){
			//$map[] = ['user_id', 'in', $this->my_uids];
			$map[] = ['in'=>['user_id' => $this->my_uids]];
			if($arr->has('page')){
				  $data=$arr->all();
				if($arr->filled('user_id') && $arr->input('user_id')!= '-1'){
					$map['user_id']=$arr->input('user_id');
				}else{
					$map[]=['time','!=',null];
				}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('user_log')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					//$deldata[] = ['user_id', 'in', $this->my_uids];
					$deldata[] = ['in'=>['user_id' => $this->my_uids]];
					$num = DB::table('user_log')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('daili/member_loginlog');
	}
	/****后台商户加款记录****/
	public function member_amount_change(Request $arr){
		if($arr->isMethod('post')){
			//print_r($this->my_uids);exit;
			//$map[] = ['user_id', 'in', $this->my_uids];
			$map[] = ['in'=>['user_id' => $this->my_uids]];
			if($arr->has('page')){
				  $data=$arr->all();
				  $map[] = ['type','>=',5];
				if($arr->filled('user_id') && $arr->input('user_id')!= '-1'){
					$map['user_id']=$arr->input('user_id');
				}else{
					$map[]=['time','!=',null];
				}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('daili_amount_change')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if($v['type'] == 5){
	       	  				$v['type'] = "平台充值";
	       	  				$v['amount']= "+".$v['amount'];
	       	  			}else if($v['type'] == 6){
	       	  				$v['type'] = "平台扣款";
	       	  				$v['amount']= "-".$v['amount'];
	       	  			}
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					//$deldata[] = ['user_id', 'in', $this->my_uids];
					$deldata[] = ['in'=>['user_id' => $this->my_uids]];
					//$num = DB::table('daili_amount_change')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('daili/member_amount_change');
	}
	/****后台商户APP通道控制****/
	public function member_payment(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('user_id') && $arr->input('user_id')!= '-1' ){
					$map['user_id']=$arr->input('user_id');
				}else{
					$map[]=['status','!=',null];
				}
				if($arr->filled('passageway_type') && $arr->input('passageway_type')!= '-1' ){
					$map['passageway_type']=$arr->input('passageway_type');
				}
				if($arr->filled('passageway_id') && $arr->input('passageway_id')!= '-1' ){
					$map['passageway_id']=$arr->input('passageway_id');
				}

				$listpage=PaymentModel::where($map)->with('diepay','livepay')->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if(!empty($v['diepay'])){
	       	  				$v['passageway_name']=$v['diepay']['name'];
	       	  			}else{
	       	  				$v['passageway_name']=$v['livepay']['name'];
	       	  			}
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'add'){
				$postdata = $arr->input('form');
				try {

				if(!empty($postdata['passageway_id']) && !empty($postdata['passageway_type'])){
					//查询商户是否存在
					if(!empty($postdata['user_id'])){
						if( DB::table('daili')->where('Id',$postdata['user_id'])->first()){
							if($postdata['passageway_type'] != '-1'){
								if($postdata['passageway_id'] == '-1' || in_array("-1",$postdata['passageway_id'])){
									if($postdata['passageway_type'] == 1){
										$payment=DB::table('die_passageway')->where('status',1)->select('Id')->get()->toarray();
									}else{
										$payment=DB::table('live_passageway')->where('status',1)->select('Id')->get()->toarray();
									}
									foreach ($payment as $k => $v) {
										$v = (array)$v;
										$v['passageway_id'] =$v['Id'];
					                    $v['passageway_type'] = $postdata['passageway_type'];
					                    $v['user_id'] = $postdata['user_id'];
					                    unset($v['Id']);
					                    //查询该商户是否存在该通道
					                    if(!DB::table('dailipayment')->where(array(
					                    	'user_id'=>$postdata['user_id'],
					                    	'passageway_type'=>$postdata['passageway_type'],
					                    	'passageway_id'=>$v['passageway_id']))->first()){
					                    	$addpayment[] = $v;
					                    }

									}
								}else{
									//查询该商户是否存在该通道
									foreach ($postdata['passageway_id'] as $v) {
										if(!DB::table('dailipayment')->where(array(
				                    	'user_id'=>$postdata['user_id'],
				                    	'passageway_type'=>$postdata['passageway_type'],
				                    	'passageway_id'=>$v))->first()){
											$addpayment[] = array('user_id'=>$postdata['user_id'],'passageway_id'=>$v,'passageway_type'=>$postdata['passageway_type']);
				                    	}
									}
								}
								if(isset($addpayment)){
									$payment_status = DB::table('dailipayment')->insert($addpayment);
									if($payment_status){
										$json['status']="ok";
										$json['msg']="通道添加成功";
									}else{
										$json['status']="error";
										$json['msg']="通道添加失败";
									}
								}else{
									$json['status']="error";
									$json['msg']="当前商户无可添加通道哦";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "请先选择通道类型";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "不存在当前商户";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请填写商户ID编号";
					}
				}
				} catch (\Exception $e) {
					$json['status'] = "error";
					$json['msg'] = $e->getMessage();
				}
			}else if($arr->input('action') == 'lose' || $arr->input('action')=='open'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						if($k < 1){
							$upwhere[]=['Id','=',$v['Id']];
						}else{
							$upwhere[]=['Id','=',$v['Id'],'or'];
						}
					}
						$updata['status'] = $arr->input('action') == 'lose' ? 2 : 1;
						$num = DB::table('dailipayment')->where($upwhere)->update($updata);
						if($num == 0){
							$json['status'] = "error";
							$json['msg'] = $arr->input('action') == 'lose' ? "当前无APP通道开启" : "当前无通道无APP通道关闭";
						}else{
							$json['status'] = "ok";
							$json['msg'] = $arr->input('action') == 'lose' ? "成功暂停APP通道{$num}个" : "成功开启APP通道{$num}个";
						}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('dailipayment')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('daili/member_payment');
	}
	/****后台商户设置****/
	public function membersite(Request $arr){

		 if($arr->isMethod('post')){
		 	 if($arr->input('action') == 'ajax'){
		 	 	$json['data']['userform']=DB::table('admin_user_site')->first();
		 	 	if($json['data']['userform']->status == 1){
		 	 		$json['data']['userform']->status = true;
		 	 	}else{
		 	 		$json['data']['userform']->status = false;
		 	 	}
		 	 	$json['data']['userform']->order_service = $json['data']['userform']->order_service*100;
		 	 	$json['data']['userform']->safety_service = $json['data']['userform']->safety_service*100;
		 	 	$json['data']['userform']->cash_service = $json['data']['userform']->cash_service*100;
		 	 	$diepassageway=explode(",",$json['data']['userform']->diepassageway);
		 	 	foreach ($diepassageway as $v) {
				    $die[] = intval(trim($v));
				}
				$json['data']['userform']->diepassageway=$die;
		 	 	$livepassageway=explode(",",$json['data']['userform']->livepassageway);
		 	 	foreach ($livepassageway as $v) {
				    $live[] = intval(trim($v));
				}
				$json['data']['userform']->livepassageway=$live;

		 	 	$json['data']['userseniorform']=DB::table('admin_user_senior_site')->first();
		 	 	$json['data']['userseniorform']->order_service = $json['data']['userseniorform']->order_service*100;
		 	 	$json['data']['userseniorform']->safety_service = $json['data']['userseniorform']->safety_service*100;
		 	 	$json['data']['userseniorform']->cash_service = $json['data']['userseniorform']->cash_service*100;
		 	 	$json['data']['uservipform']=DB::table('admin_user_vip_site')->first();
		 	 	$json['data']['uservipform']->order_service = $json['data']['uservipform']->order_service*100;
		 	 	$json['data']['uservipform']->safety_service = $json['data']['uservipform']->safety_service*100;
		 	 	$json['data']['uservipform']->cash_service = $json['data']['uservipform']->cash_service*100;
		 	 }else if($arr->input('action')=='user' && $arr->filled('form')){
		 	 	$postdata=$arr->input('form');
		 	 	if(!empty($postdata['cash_min']) && (float)$postdata['cash_min'] >= 1){
		 	 		if(!empty($postdata['cash_service']) && (float)$postdata['cash_service'] >0){
		 	 			if(!empty($postdata['order_service']) && (float)$postdata['order_service'] >0){
		 	 				if(!empty($postdata['safety_service']) && (float)$postdata['safety_service'] >0){
		 	 					$postdata['cash_service'] =  $postdata['cash_service']/100;
		 	 					$postdata['order_service'] = $postdata['order_service']/100;
		 	 					$postdata['safety_service'] = $postdata['safety_service']/100;
		 	 					if(empty($postdata['cash_num'])){
		 	 						$postdata['cash_num']=0;
		 	 					}
		 	 					if(empty($postdata['cash_max'])){
		 	 						$postdata['cash_max']=0;
		 	 					}
		 	 					if(empty($postdata['order_everyday_money'])){
		 	 						$postdata['order_everyday_money']=0;
		 	 					}
		 	 					if($postdata['status']){
		 	 						$postdata['status']=1;
		 	 					}else{
		 	 						$postdata['status']=2;
		 	 					}
		 	 					if(!empty($postdata['diepassageway'])){
		 	 						$diepassageway='';
		 	 						foreach ($postdata['diepassageway'] as $v) {
			 	 						$diepassageway.=$v.',';
			 	 					}
			 	 					$postdata['diepassageway']=rtrim($diepassageway,",");
		 	 					}
		 	 					if(!empty($postdata['livepassageway']) || $postdata['livepassageway'] != "-1"){
		 	 						$livepassageway='';
		 	 						foreach ($postdata['livepassageway'] as $v) {
			 	 						$livepassageway.=$v.',';
			 	 					}
			 	 					$postdata['livepassageway']=rtrim($livepassageway,",");
		 	 					}
		 	 					$status = DB::table('admin_user_site')->update($postdata);
		 	 					if($status){
		 	 						$json['status']="ok";
		 	 						$json['msg']="保存成功";
		 	 					}else{
		 	 						$json['status']="error";
			 	 					$json['msg']="未更改参数,保存失败";
		 	 					}
		 	 				}else{
		 	 					$json['status']="error";
			 	 				$json['msg']="订单支付通道费率不能为0哦";
		 	 				}
		 	 			}else{
			 	 			$json['status']="error";
			 	 			$json['msg']="订单费率不能为0哦";
			 	 		}
		 	 		}else{
		 	 			$json['status']="error";
		 	 			$json['msg']="提现费率不能为0哦";
		 	 		}
		 	 	}else{
		 	 		$json['status']="error";
		 	 		$json['msg']="最低提现金额不能少于1元";
		 	 	}
		 	 }else if($arr->input('action')=='senior' && $arr->filled('form')){
		 	 	$postdata=$arr->input('form');
		 	 	if(!empty($postdata['cash_min']) && (float)$postdata['cash_min'] >= 1){
		 	 		if(!empty($postdata['cash_service']) && (float)$postdata['cash_service'] >0){
		 	 			if(!empty($postdata['order_service']) && (float)$postdata['order_service'] >0){
		 	 				if(!empty($postdata['safety_service']) && (float)$postdata['safety_service'] >0){
		 	 					$postdata['cash_service'] =  $postdata['cash_service']/100;
		 	 					$postdata['order_service'] = $postdata['order_service']/100;
		 	 					$postdata['safety_service'] = $postdata['safety_service']/100;
		 	 					if(empty($postdata['cash_num'])){
		 	 						$postdata['cash_num']=0;
		 	 					}
		 	 					if(empty($postdata['cash_max'])){
		 	 						$postdata['cash_max']=0;
		 	 					}
		 	 					if(empty($postdata['order_everyday_money'])){
		 	 						$postdata['order_everyday_money']=0;
		 	 					}
		 	 					$status = DB::table('admin_user_senior_site')->update($postdata);
		 	 					if($status){
		 	 						$json['status']="ok";
		 	 						$json['msg']="保存成功";
		 	 					}else{
		 	 						$json['status']="error";
			 	 					$json['msg']="未更改参数,保存失败";
		 	 					}
		 	 				}else{
		 	 					$json['status']="error";
		 	 					$json['msg']="订单支付通道费率不能为0哦";
		 	 				}
		 	 			}else{
		 	 				$json['status']="error";
		 	 				$json['msg']="订单费率不能为0哦";
		 	 			}
		 	 		}else{
		 	 			$json['status']="error";
		 	 			$json['msg']="提现费率不能为0哦";
		 	 		}
		 	 	}else{
		 	 		$json['status']="error";
		 	 		$json['msg']="最低提现金额不能少于1元";
		 	 	}
		 	 }else if($arr->input('action')=='vip' && $arr->filled('form')){
		 	 	$postdata=$arr->input('form');
		 	 	if(!empty($postdata['cash_min']) && (float)$postdata['cash_min'] >= 1){
		 	 		if(!empty($postdata['cash_service']) && (float)$postdata['cash_service'] >0){
		 	 			if(!empty($postdata['order_service']) && (float)$postdata['order_service'] >0){
		 	 				if(!empty($postdata['safety_service']) && (float)$postdata['safety_service'] >0){
		 	 					$postdata['cash_service'] =  $postdata['cash_service']/100;
		 	 					$postdata['order_service'] = $postdata['order_service']/100;
		 	 					$postdata['safety_service'] = $postdata['safety_service']/100;
		 	 					if(empty($postdata['cash_num'])){
		 	 						$postdata['cash_num']=0;
		 	 					}
		 	 					if(empty($postdata['cash_max'])){
		 	 						$postdata['cash_max']=0;
		 	 					}
		 	 					if(empty($postdata['order_everyday_money'])){
		 	 						$postdata['order_everyday_money']=0;
		 	 					}
		 	 					$status = DB::table('admin_user_vip_site')->update($postdata);
		 	 					if($status){
		 	 						$json['status']="ok";
		 	 						$json['msg']="保存成功";
		 	 					}else{
		 	 						$json['status']="error";
			 	 					$json['msg']="未更改参数,保存失败";
		 	 					}
		 	 				}else{
		 	 					$json['status']="error";
		 	 					$json['msg']="订单支付通道费率不能为0哦";
		 	 				}
		 	 			}else{
		 	 				$json['status']="error";
		 	 				$json['msg']="订单费率不能为0哦";
		 	 			}
		 	 		}else{
		 	 			$json['status']="error";
		 	 			$json['msg']="提现费率不能为0哦";
		 	 		}
		 	 	}else{
		 	 		$json['status']="error";
		 	 		$json['msg']="最低提现金额不能少于1元";
		 	 	}
		 	 }else{
		 	 	$json['status']="error";
		 	 	$json['msg']="不安全的提交方式";
		 	 }
		 	 return $json;
		 }
		 return view('daili/membersite');
	}

	/****后台订单记录****/
	public function order_record(Request $arr){


		//print_r($my_uids);exit;
		//$map[] = ['user_id','in', $this->my_uids];
		//$map[] = ['in'=>['user_id' => $this->my_uids]];
		if($arr->isMethod('post')){
			if($arr->has('page')){

			  	//搜索条件
			  	if($arr->has('order') && !is_null($arr->input('order')) && $arr->input('order')!= '-1' && !is_null($arr->input('value'))){
			  	   	if($arr->input('order')=='order_money' || $arr->input('order')=='order_price' || $arr->input('order')=='user_id' || $arr->input('order')=='member_id'){
			  	   		$map[]=[$arr->input('order'),'=',$arr->input('value')];
			  	   	}else{
			  	   		$map[]=[$arr->input('order'),'like','%'.$arr->input('value').'%'];
			  	   	}
			  	}

			  	if($arr->has('status') && !empty($arr->input('status')) && $arr->input('status')!='-1'){
			  		$map['status']=$arr->input('status');
			  	}else{
			  		$map[]=['status','!=',null];
			  	}
			  	if($arr->has('notice') && !empty($arr->input('notice')) && $arr->input('notice')!='-1'){
			  		$map['notice']=$arr->input('notice');
			  	}
			  	if($arr->has('code_type') && !empty($arr->input('code_type')) && $arr->input('code_type')!='-1'){
			  		$map['code_type']=$arr->input('code_type');
			  	}
			  	if($arr->has('passageway_id') && !empty($arr->input('passageway_id')) && $arr->input('passageway_id')!='-1'){
			  		$map['passageway_id']=$arr->input('passageway_id');
			  	}
			  	if($arr->has('paytype') && !empty($arr->input('paytype')) && $arr->input('paytype')!='-1'){
			  		$map['type']=$arr->input('paytype');
			  	}
			  	if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['sub_time','>=',strtotime($time[0])];
		       	  		$map[]=['sub_time','<',strtotime($time[1])];
					}
				}
			  	//条件结束
					//$map[] = ['user_id','in', $my_uids];
		  		$map2=$map;

		  		/****总提交金额****/
				//	$map2[] = ['user_id','in', $my_uids];
				//print_r($map2);exit;
		  		$json['data']['record_money']['totalmoney']=DB::table('order')->whereIn('user_id' , $this->my_uids)->where($map)->sum('order_money');
		  		$map2[] = ['status', '=', 2];
					//print_r($map2);exit;
		  		/****成功金额****/
		  		$json['data']['record_money']['successmoney']=DB::table('order')->whereIn('user_id' , $this->my_uids)->where($map2)->sum('order_price');
		  		/****商户收入****/
		  		$json['data']['record_money']['member_lncome']=number_format($json['data']['record_money']['successmoney']-DB::table('order')->whereIn('user_id' , $this->my_uids)->where($map2)->sum('order_service')-DB::table('order')->whereIn('user_id' , $this->my_uids)->where($map2)->sum('software_service'),3,".","");
		  		/****码商收入****/
		  		$json['data']['record_money']['merchant_lncome']=number_format(DB::table('order')->whereIn('user_id' , $this->my_uids)->where($map2)->sum('order_service')+DB::table('order')->whereIn('user_id' , $this->my_uids)->where($map2)->sum('software_service')-DB::table('order')->whereIn('user_id' , $this->my_uids)->where($map2)->sum('passageway_service'),3,".","");
					//$map[] = ['in'=>['user_id' => $this->my_uids]];
					$orderarr=OrderModel::where($map)->whereIn('user_id' , $this->my_uids)->with('livepassageway','diepassageway','livepollingpayment','diepollingpayment')->orderBy('id','desc')->paginate(15)->toarray();
			  	if(intval($orderarr['total']) >= 1){
			  	   $order=$orderarr['data'];
				  	foreach($order as $k => $v){
						$v=(array)$v;
						$v['time']=date('Y-m-d H:i:s',$v['sub_time']);
						if($v['type']== 'alipay') $v['type']="支付宝扫码";else if($v['type']=='aliwap') $v['type']="支付宝H5";else if($v['type']=='wechat') $v['type']="微信扫码";else $v['type']="银联扫码";
						if(!empty($v['livepassageway'])){
							$v['passageway']=$v['livepassageway']['name'];
						}else if(!empty($v['diepassageway'])){
							$v['passageway']=$v['diepassageway']['name'];
						}
						$orderlist[]=$v;
					}
				  	$json['data']['list']=$orderlist;
			  	}else{
			  		$json['data']['list']=[];
			  	}
			  	   $json['current_page']=$orderarr['current_page'];
				   $json['total']=$orderarr['total'];
			  	   $json['status']="ok";
		    }else if($arr->input('action') == 'amount'){
		    	//修改订单金额
		    	$data = $arr->input('form');
		    	if($data['order_price'] > '0.01'){
		    		//获取码商信息
		    		$merchant = DB::table('member')->where('Id',$data['member_id'])->first();
		    		//获取用户信息
		    		$userinfo = DB::table('daili')->where('Id',$data['user_id'])->first();

		    		$updata['order_price'] = $data['order_price'];
		    		$updata['order_service'] = number_format($updata['order_price']*$userinfo->order_service,3,".","");
		    		$updata['software_service'] = number_format($updata['order_price']*$userinfo->safety_service,3,".","");
		    		$updata['passageway_service'] = number_format($updata['order_price']*$merchant->service,3,".","");
		    		$updata['com_time'] = time();
		    		$updata['status'] = 2;
		    		//判断码商余额是否支持更改
		    		if($merchant->price >= number_format($updata['order_price'] - $updata['order_service'] - $updata['software_service'] + $updata['passageway_service'],3,".","")){
		    			$status = OrderModel::where('Id', $data['Id'])->update($updata);
		    			if($status){
		    				$order_redis = new Order_Redis;
		    				$admin_site = DB::table('admin_site')->first();
		    				//查询该订单
		    				$info = OrderModel::where('Id',$data['Id'])->with('user')->first()->toarray();
		    				//发送补发通知
	  			 			$postarr['form']['user_id'] = $info['user_id'];
  			 				$postarr['form']['order_id'] = $info['order_id'];
	                        $postarr['form']['apiorder_id'] = $info['apiorder_id'];
	                        $postarr['form']['amount'] = $info['order_money'];
	                        $postarr['form']['amount_actual'] = $info['order_price'];
	                        $postarr['form']['paytype'] = $info['type'];
	                        if ($info['remarks'] != "无") {
	                            $postarr['form']['remarks'] = $info['remarks'];
	                        }
	                        $postarr['form']['success_time'] =$info['com_time'];
	                        $postarr['form']['sign'] = getsign($postarr['form'],$info['user']['token']);
	                        $postarr['notify_url'] = $info['notify_url'];
	                        $postarr['number_notice'] = 2;
	                        //添加到Redis回调列表
	                        $redis_status = Redis::rpush('ordernotice',json_encode($postarr));
	                        if($redis_status){
	                        	/***先处理商户余额以及添加余额明细****/
                                $change_data['type'] = 1;
                                $change_data['user_id'] = $info['user_id'];
                                $change_data['amount'] = $info['order_price'] - $info['order_service'] - $info['software_service'];
                                $change_data['time'] = time();
                                $change_data['user_price'] = $userinfo->price + $change_data['amount'];
                                //再给商户加余额
                                $status = DB::table('daili')->where('Id', $change_data['user_id'])->update(array(
                                    'price' => $change_data['user_price']
                                ));
                                if (!$status) {
                                	//记录加余额失败用户
                                    $amount_error_a['form']['apiorder_id'] = $info['apiorder_id'];
                                    $amount_error_a['form']['user_id'] = $change_data['user_id'];
                                    $amount_error_a['form']['amount'] = $change_data['amount'];
                                    $amount_error_a['type'] = 1001;
                                    Redis::rpush('order_amount_error',json_encode($amount_error_a));
                                }
                                //添加商户余额明细
                                $addstatus = DB::table('daili_amount_change')->insert($change_data);
                                if (!$addstatus) {
                                    //记录加余额明细失败用户
                                    $amount_error_b['form'] = $change_data;
                                    $amount_error_b['type'] = 1002;
                                    Redis::rpush('order_amount_error',json_encode($amount_error_b));
                                }
                                /***再次处理码商余额以及添加余额明细****/
                                $change_datas['type'] = 1;
                                $change_datas['member_id'] = $info['member_id'];
                                $change_datas['amount'] = number_format($info['order_price'] - $info['order_service'] - $info['software_service'] + $info['passageway_service'],3,".","");
                                $change_datas['time'] = $change_data['time'];
                                $change_datas['member_price'] = $merchant->price - $change_datas['amount'];
                                //再给码商扣除余额
                                $merchantstatus = DB::table('member')->where('Id', $change_datas['member_id'])->update(array(
                                    'price' => $change_datas['member_price']
                                ));
                                if (!$merchantstatus) {
                                    //记录扣余额失败码商
                                    $amount_error_c['form']['apiorder_id'] = $info['apiorder_id'];
                                    $amount_error_c['form']['member_id'] = $change_datas['member_id'];
                                    $amount_error_c['form']['amount'] = $change_datas['amount'];
                                    $amount_error_c['type'] = 2001;
                                     Redis::rpush('order_amount_error',json_encode($amount_error_c));
                                }
                                //添加码商余额明细
                                $memberamountadd = DB::table('member_amount_change')->insert($change_datas);
                                if (!$memberamountadd) {
                                     //记录加余额明细失败码商
                                    $amount_error_d['form'] = $change_datas;
                                    $amount_error_d['type'] = 2002;
                                    Redis::rpush('order_amount_error',json_encode($amount_error_d));
                                }
                                //清除该二维码
                                $order_redis->delete($admin_site->payment_type,'alipay',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                $order_redis->delete($admin_site->payment_type,'aliwap',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                $order_redis->delete($admin_site->payment_type,'wechat',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                $order_redis->delete($admin_site->payment_type,'unionpay',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                //清除该二维码出码记录
	                            $order_redis->query_delete('alipay',$info['code_type'],$info['polling_passageway_key']);
	                            $order_redis->query_delete('aliwap',$info['code_type'],$info['polling_passageway_key']);
	                            $order_redis->query_delete('wechat',$info['code_type'],$info['polling_passageway_key']);
	                            $order_redis->query_delete('unionpay',$info['code_type'],$info['polling_passageway_key']);
	                            $payment = $info['code_type'] == 1 ? new DiepollingpaymentModel : new LivepollingpaymentModel;
	                            $typename = $info['code_type'] == 1 ? 'die' : 'live';
	                            $payment_info  = $payment->where('key',$info['polling_passageway_key'])->with('user','payment', 'merchant')->first();
	                            if($payment_info->merchant->price > 1 && $payment_info->merchant->frozen_amount >=0 && $payment_info->user->status == 1 && $payment_info->user->loop == 1 && $payment_info->gateway_state ==1){
			                        if($admin_site->payment_type == 1){
                                        if(stristr($payment_info->payment->paytype,'alipay') !== false){
                                            Redis::rpush('sort_alipay_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'aliwap') !== false){
                                            Redis::rpush('sort_aliwap_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'wechat') !== false){
                                            Redis::rpush('sort_wechat_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'unionpay') !== false){
                                            Redis::rpush('sort_unionpay_'.$typename,json_encode($payment_info));
                                        }
                                    }else{
                                        if(stristr($payment_info->payment->paytype,'alipay') !== false){
                                            Redis::sadd('random_alipay_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'aliwap') !== false){
                                            Redis::sadd('random_aliwap_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'wechat') !== false){
                                            Redis::sadd('random_wechat_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'unionpay') !== false){
                                            Redis::sadd('random_unionpay_'.$typename,json_encode($payment_info));
                                        }
                                    }
						        }
                                $json['status'] = "ok";
                                $json['msg'] = "订单修改成功,已自动补单";
	                        }
		    			}else{
		    				$json['status'] = "error";
		    				$json['msg'] = "当前无更改,修改失败";
		    			}
		    		}else{
		    			$json['status'] = "error";
		    			$json['msg'] = "当前码商可用余额不足";
		    		}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "订单实付不能小于0.01";
		    	}
		    }else if($arr->input('action') == 'notice'){
		    	//补发通知
		    	$data = $arr->input('form');
		    	if(is_array($data)){
		    		$num = 0;
		    		foreach ($data as $k => $v) {
		    			$infoarr[$k] = OrderModel::where('Id', $v)->with('user')->first()->toarray();
		  			 		if($infoarr[$k] && $infoarr[$k]['status'] == 2){
		  			 			//发送补发通知
		  			 			$postarr['form']['user_id'] = $infoarr[$k]['user_id'];
	  			 				$postarr['form']['order_id'] = $infoarr[$k]['order_id'];
		                        $postarr['form']['apiorder_id'] = $infoarr[$k]['apiorder_id'];
		                        $postarr['form']['amount'] = $infoarr[$k]['order_money'];
		                        $postarr['form']['amount_actual'] = $infoarr[$k]['order_price'];
		                        $postarr['form']['paytype'] = $infoarr[$k]['type'];
		                        if ($infoarr[$k]['remarks'] != "无") {
		                            $postarr['form']['remarks'] = $infoarr[$k]['remarks'];
		                        }
		                        $postarr['form']['success_time'] =$infoarr[$k]['com_time'];
		                        $postarr['form']['sign'] = getsign($postarr['form'],$infoarr[$k]['user']['token']);
		                        $postarr['notify_url'] = $infoarr[$k]['notify_url'];
		                        $postarr['number_notice'] = 2;
		                        //添加到Redis回调列表
		                        $redis_status = Redis::rpush('ordernotice',json_encode($postarr));
		                        if($redis_status){
		                        	$num++;
		                        }
		  			 		}
		    		}
		    		if($num!=0){
	  			 		$json['status']="ok";
	  			 		$json['msg']="成功补发通知{$num}个,已自动添加通知任务";
		  			}else{
		  				$json['status']="error";
		  				$json['msg']="操作失败,当前订单无订单支付成功";
		  			}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "不安全的提交方式";
		    	}
		    }else if($arr->input('action') == 'repair'){
		    	//补单
		    	$data = $arr->input('form');
		    	if(is_array($data)){
		    		$num = 0;
		    		foreach ($data as $k => $v) {
		    			$v = (array)$v;
		    			//查询码商余额及冻结金额
				  	    $merchant = DB::table('member')->where('Id',$v['member_id'])->first();
		  			 	if($merchant->price >= number_format($v['order_price'] - $v['order_service'] - $v['software_service'] + $v['passageway_service'],3,".","")){
		  			 		$infoarr[$k] = OrderModel::where('Id', $v)->with('user')->first()->toarray();
		  			 		if($infoarr[$k] && $infoarr[$k]['status'] != 2){
			  			 		$status = OrderModel::where('Id',$v['Id'])->update(array('status'=>2,'com_time'=>time()));
			  			 		if($status){
			  			 			$num++;
			  			 			//发送补发通知
			  			 			$postarr['form']['user_id'] = $infoarr[$k]['user_id'];
		  			 				$postarr['form']['order_id'] = $infoarr[$k]['order_id'];
			                        $postarr['form']['apiorder_id'] = $infoarr[$k]['apiorder_id'];
			                        $postarr['form']['amount'] = $infoarr[$k]['order_money'];
			                        $postarr['form']['amount_actual'] = $infoarr[$k]['order_price'];
			                        $postarr['form']['paytype'] = $infoarr[$k]['type'];
			                        if ($infoarr[$k]['remarks'] != "无") {
			                            $postarr['form']['remarks'] = $infoarr[$k]['remarks'];
			                        }
			                        $postarr['form']['success_time'] =$infoarr[$k]['com_time'];
			                        $postarr['form']['sign'] = getsign($postarr['form'],$infoarr[$k]['user']['token']);
			                        $postarr['notify_url'] = $infoarr[$k]['notify_url'];
			                        $postarr['number_notice'] = 2;
			                        //添加到Redis回调列表
			                        $redis_status = Redis::rpush('ordernotice',json_encode($postarr));
			                        if($redis_status){
			                        	/***先处理商户余额以及添加余额明细****/
                                        $change_data['type'] = 1;
                                        $change_data['user_id'] = $infoarr[$k]['user_id'];
                                        $change_data['amount'] = $infoarr[$k]['order_price'] - $infoarr[$k]['order_service'] - $infoarr[$k]['software_service'];
                                        $change_data['time'] = time();
                                        //先获取商户原余额
                                        $price = DB::table('daili')->where('Id', $infoarr[$k]['user_id'])->first()->price;
                                        $change_data['user_price'] = $price + $change_data['amount'];
                                        //再给商户加余额
                                        $status = DB::table('daili')->where('Id', $change_data['user_id'])->update(array(
                                            'price' => $change_data['user_price']
                                        ));
                                        if (!$status) {
                                           //记录加余额失败用户
		                                    $amount_error_a['form']['apiorder_id'] = $info['apiorder_id'];
		                                    $amount_error_a['form']['user_id'] = $change_data['user_id'];
		                                    $amount_error_a['form']['amount'] = $change_data['amount'];
		                                    $amount_error_a['type'] = 1001;
		                                    Redis::rpush('order_amount_error',json_encode($amount_error_a));
                                        }
                                        //添加商户余额明细
                                        $addstatus = DB::table('daili_amount_change')->insert($change_data);
                                        if (!$addstatus) {
                                            //记录加余额明细失败用户
		                                    $amount_error_b['form'] = $change_data;
		                                    $amount_error_b['type'] = 1002;
		                                    Redis::rpush('order_amount_error',json_encode($amount_error_b));
                                        }
                                        /***再次处理码商余额以及添加余额明细****/
                                        $change_datas['type'] = 1;
                                        $change_datas['member_id'] = $infoarr[$k]['member_id'];
                                        $change_datas['amount'] = number_format($infoarr[$k]['order_price'] - $infoarr[$k]['order_service'] - $infoarr[$k]['software_service'] + $v['passageway_service'],3,".","");
                                        $change_datas['time'] = $change_data['time'];
                                        //先获取码商原余额
                                        $price = DB::table('member')->where('Id', $infoarr[$k]['member_id'])->first()->price;
                                        $change_datas['member_price'] = $price - $change_datas['amount'];
                                        //再给码商扣除余额
                                        $merchantstatus = DB::table('member')->where('Id', $change_datas['member_id'])->update(array(
                                            'price' => $change_datas['member_price']
                                        ));
                                        if (!$merchantstatus) {
                                            //记录扣余额失败码商
		                                    $amount_error_c['form']['apiorder_id'] = $info['apiorder_id'];
		                                    $amount_error_c['form']['member_id'] = $change_datas['member_id'];
		                                    $amount_error_c['form']['amount'] = $change_datas['amount'];
		                                    $amount_error_c['type'] = 2001;
		                                     Redis::rpush('order_amount_error',json_encode($amount_error_c));
                                        }
                                        //添加码商余额明细
                                        $memberamountadd = DB::table('member_amount_change')->insert($change_datas);
                                        if (!$memberamountadd) {
                                            //记录加余额明细失败码商
		                                    $amount_error_d['form'] = $change_datas;
		                                    $amount_error_d['type'] = 2002;
		                                    Redis::rpush('order_amount_error',json_encode($amount_error_d));
                                        }
			                        }
			  			 		}
			  			 	}
		  			 	}else{
		  			 		break;
		  			 		return array('status'=>'error','msg'=>"当前码商可用余额不足,已成功补单{$num}个");
		  			 	}
		    		}
		    		if($num!=0){
	  			 		$json['status']="ok";
	  			 		$json['msg']="成功补单{$num}个,已自动添加通知任务";
		  			}else{
		  				$json['status']="error";
		  				$json['msg']="操作失败,当前订单已支付成功或码商可用余额不足";
		  			}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "请提交正确的方式";
		    	}
		    }else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($v['status'] != 1){
							if($k < 1){
								$deldata[]=['Id','=',$v['Id']];
							}else{
								$deldata[]=['Id','=',$v['Id'],'or'];
							}
						}
					}
					$num = DB::table('order')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,当前有订单正在交易";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
		    return $json;
		}
		return view('daili/order_record');
	}





	/****后台连续失败码队列****/
	public function code_error(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('field') && $arr->filled('value') && $arr->input('field')!= '-1'){
					$map[$arr->input('field')]=$arr->input('value');
				}else{
					$map[]=['time','!=',null];
				}
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=QrcodeErrorModel::where($map)->with(['diepay','livepay'])->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['payment_name'] = !empty($v['diepay']) ? $v['diepay']['name'] : $v['livepay']['name'];
	       	  			$v['qrcode'] = !empty($v['qrcode']) ? "data:image/png;base64,".base64_encode(QrCode::format('png')->size(100)->margin(0)->generate($v['qrcode'])) : '';
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('qrcode_error')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else if($arr->input('action') == 'open'){
				$data = $arr->input('form')[0];
				$payment = $data['code_type'] == 1 ? new DiepollingpaymentModel : new LivepollingpaymentModel;
				$status = $payment->where('key',$data['key'])->update(array('gateway_state'=>1));
				if($status){
					//判断平台出码方式
                    $admin_site=DB::table('admin_site')->first();
                    $order_redis = new Order_Redis;
                    $order_redis_info = $payment->where(array('key'=>$data['key']))->with('user','payment','merchant')->first();
                    $typename = $data['code_type'] == 1 ? 'die' : 'live';
                    if($order_redis_info->merchant->price >1 && $order_redis_info->user->loop == 1 && $order_redis_info->merchant->frozen_amount >= 0 && $order_redis_info->user->status == 1){
                    	//添加到Redis
                        if($admin_site->payment_type == 1){
                            if(stristr($order_redis_info->payment->paytype,'alipay') !== false){
                                Redis::rpush('sort_alipay_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'aliwap') !== false){
                                Redis::rpush('sort_aliwap_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'wechat') !== false){
                                Redis::rpush('sort_wechat_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'unionpay') !== false){
                                Redis::rpush('sort_unionpay_'.$typename,json_encode($order_redis_info));
                            }
                        }else{
                            if(stristr($order_redis_info->payment->paytype,'alipay') !== false){
                                Redis::sadd('random_alipay_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'aliwap') !== false){
                                Redis::sadd('random_aliwap_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'wechat') !== false){
                                Redis::sadd('random_wechat_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'unionpay') !== false){
                                Redis::sadd('random_unionpay_'.$typename,json_encode($order_redis_info));
                            }
                        }
                    }
                    $json['status'] = "ok";
                    $json['msg'] = "开启网关成功";
                    //删除当前记录
                    DB::table('qrcode_error')->where('Id',$data['Id'])->delete();
				}else{
					$json['status'] = "error";
                    $json['msg'] = "当前通道网关已开启过,请自行清除记录";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/code_error');
	}











	/****退出登录****/
	public function signout(Request $arr){
		session()->pull('daili');
		//跳转到登录页
        return redirect('/login');
	}

	/***修改密码****/
	public function change_password(Request $arr){
		if($arr->isMethod('post')){
		    if($arr->filled('form')){
		    	if(is_array($arr->input('form'))){
		    		$data = $arr->input('form');
		    		if(checkpass($data['password'])){
		    			if(!empty($data['repass'])){
		    				if(checkpass($data['repass'])){
		    					$info = DB::table('daili')->where('Id',session()->get('daili') ['Id'])->first();
		    					if($info->safety == 1){
		    						if(empty($data['code'])){
		    							$json['status']="error";
		    							$json['msg'] = "请输入谷歌验证码";
		    						}else{
		    							//验证谷歌验证码是否正确
										$ga = new Google;
										$checkResult = $ga->verifyCode($info->safetycode,trim($data['code']),2);
										if(!$checkResult){
											$json['status'] = "error";
											$json['msg'] = "当前谷歌验证码错误";
										}
		    						}
		    					}
		    					if(!isset($json)){
		    						if(ypass($data['password'],$info->password)){
		    							$updata['password'] = xpass(trim($data['password']));
				    					$status = DB::table('daili')->where('Id',session()->get('daili') ['Id'])->update($updata);
				    					if($status){
				    						$json['status'] = "ok";
				    						$json['msg'] = "修改密码成功";
				    					}else{
				    						$json['status'] = "error";
			    							$json['msg']  = "密码修改错误";
				    					}
			    					}else{
			    						$json['status'] = "error";
			    						$json['msg'] = "原密码不一致";
			    					}
		    					}
		    				}else{
		    					$json['status'] = "error";
		    					$json['msg']  = "新密码不符合规则";
		    				}
		    			}else{
		    				$json['status'] = "error";
		    				$json['msg'] = "请输入新密码";
		    			}
		    		}else{
		    			$json['status'] = "error";
		    			$json['msg'] = "原密码不符合规则";
		    		}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "不安全的提交方式";
		    	}
		    }
		    return $json;
		}
	    return view('daili/change_password');
	}
	/****余额提现****/
	public function withdraw(Request $arr) {

			if ($arr->isMethod('post')) {
					if ($arr->input('action') == 'withdraw') {
						//echo 1;exit;
							$userinfo = DB::table('daili')->where('id', session()->get('daili') ['Id'])->first();

							$site = DB::table('admin_user_vip_site')->first();

							$json['data']['price'] = $userinfo->price;
							$json['data']['cash_min'] = $site->cash_min;
							$json['data']['cashmoney'] = DB::table('daili_drawing')->where(array('status'=>2,'user_id'=>session()->get('daili') ['Id']))->sum('money');
							$bank = DB::table('daili_cash_account')->select('id', 'name', 'bank_type')->where('user_id', session()->get('daili') ['Id'])->get()->toarray();
							foreach ($bank as $v) {
									$v = (array)$v;
									$json['data']['account'][] = array(
											'label' => $v['name'] . '-' . $v['bank_type'],
											'value' => $v['id']
									);
							}
					} else if ($arr->input('action') == 'ajax' && $arr->filled('cash_account_id') && $arr->filled('money')) {
							$userinfo = DB::table('daili')->where('id', session()->get('daili') ['Id'])->first();
							if ($userinfo->price >= (float)$arr->input('money')) {
										$data = $arr->all();
									if($userinfo->safety == 1){
										 //验证谷歌验证码是否正确
											if(!empty($data['code'])){
													$ga = new Google;
													$checkResult = $ga->verifyCode($userinfo->safetycode,trim($data['code']),2);
													if(!$checkResult){
															$json['status'] = "error";
															$json['msg'] = "当前谷歌验证码错误";
													}
											}else{
													$json['status']= "error";
													$json['msg'] = "请输入谷歌验证码";
											}
									}
									if(!isset($json)){

													$site = DB::table('admin_user_vip_site')->first();

											if ((float)$arr->input('money') >= $site->cash_min) {
													if ((float)$arr->input('money') <= $site->cash_max || $site->cash_max == 0) {
															//查询当天已提现次数
															$map['user_id'] = $userinfo->Id;
															$map[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
															$map[] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
															$cashnum = DB::table('daili_drawing')->where($map)->count();
															if ($cashnum < $site->cash_num || $site->cash_num == 0) {
																	$adddata['user_id'] = $userinfo->Id;
																	$adddata['cash_account_id'] = $arr->input('cash_account_id');
																	$adddata['money'] = $arr->input('money');
																	$adddata['service'] = $arr->input('money') * $site->cash_service;
																	$adddata['sub_time'] = time();
																	$status = DB::table('daili_drawing')->insertGetId($adddata);
																	if ($status) {
																			$userstatus = DB::table('daili')->where('Id', $userinfo->Id)->update(array(
																					'price' => ($userinfo->price - $data['money'])
																			));
																			if ($userstatus) {
																					//添加资金明细
																					$amount_change['type'] = 2;
																					$amount_change['user_id'] = session()->get('daili') ['Id'];
																					$amount_change['amount'] = $data['money'];
																					$amount_change['user_price'] = $userinfo->price - $data['money'];
																					$amount_change['time'] = time();

																					DB::table('daili_amount_change')->insert($amount_change);

																					$json['status'] = "ok";
																					$json['msg'] = "申请提现成功,请等待客服处理";
																			} else {
																					DB::table('daili_drawing')->where('Id', $status)->delete();
																					$json['status'] = "error";
																					$json['msg'] = "平台繁忙,请重新申请";
																			}
																	} else {
																			$json['status'] = "error";
																			$json['msg'] = "平台繁忙,请重新申请";
																	}
															} else {
																	$json['status'] = "error";
																	$json['msg'] = "当前级别每日只可提现" . $site->cash_num . "次";
															}
													} else {
															$json['status'] = "error";
															$json['msg'] = "当前级别最多可提现" . $site->cash_max . "元";
													}
											} else {
													$json['status'] = "error";
													$json['msg'] = "当前级别最低提现" . $site->cash_min . "元";
											}
									}
							} else {
									$json['status'] = "error";
									$json['msg'] = "当前商户余额不足";
							}
					} else {
							$json['status'] = "error";
							$json['msg'] = "不安全的提交方式";
					}
					return $json;
			}
			return view('daili/withdraw');
	}
	/****提款记录****/
	public function settlement_records(Request $arr) {
			if ($arr->isMethod('post')) {
					if ($arr->has('page')) {
							$map['user_id'] = session()->get('daili') ['Id'];
							if ($arr->filled('time') && is_array($arr->input('time'))) {
									$time = $arr->input('time');
									if (!empty($time[0]) && !empty($time[1])) {
											$map[] = ['sub_time', '>=', strtotime($time[0]) ];
											$map[] = ['sub_time', '<', strtotime($time[1]) + 86400];
									}
							}
							$datapage = DailiDrawingModel::where($map)->with('bank')->orderBy('id', 'desc')->paginate(15)->toarray();
							if (intval($datapage['total']) >= 1) {
									$data = $datapage['data'];
									foreach ($data as $k => $v) {
											$v = (array)$v;
											if ($v['status'] == 1) {
													$v['sub_time'] = date('Y-m-d H:i', $v['sub_time']);
													$v['com_time'] = date('Y-m-d H:i', $v['com_time']);
											} else {
													$v['sub_time'] = date('Y-m-d H:i', $v['sub_time']);
													$v['com_time'] = "正在处理";
											}
											if (is_null($v['bank'])) {
													$v['bank']['name'] = "未知";
													$v['bank']['bank_type'] = '';
											}
											$json['data']['list'][] = $v;
									}
									/****成功金额****/
									$json['data']['success_money'] = DB::table('daili_drawing')->where($map)->where('status', 1)->sum('money');
									/****成功手续费****/
									$json['data']['success_service'] = DB::table('daili_drawing')->where($map)->where('status', 1)->sum('service');
									/****成功笔数****/
									$json['data']['success_count'] = DB::table('daili_drawing')->where($map)->where('status', 1)->count();
							} else {
									$json['data']['list'] = 0;
									$json['data']['success_money'] = 0;
									$json['data']['success_service'] = 0;
									$json['data']['success_count'] = 0;
							}
							$json['current_page'] = $datapage['current_page'];
							$json['total'] = $datapage['total'];
							$json['status'] = "ok";
					} else {
							$json['status'] = "error";
					}
					return $json;
			}
			return view('daili/settlement_records');
	}
	/****提款账户****/
	public function settlement_account(Request $arr) {
		//echo 1;exit;
			if ($arr->isMethod('post')) {
					if ($arr->has('page')) {
							$map['user_id'] = session()->get('daili') ['Id'];
							$datapage = DB::table('daili_cash_account')->where($map)->orderBy('id', 'desc')->paginate(15)->toarray();
							if (intval($datapage['total']) >= 1) {
									$json['data'] = $datapage['data'];
							} else {
									$json['data'] = 0;
							}
							$json['current_page'] = $datapage['current_page'];
							$json['total'] = $datapage['total'];
							$json['status'] = "ok";
					} else if ($arr->has('action')) {
							if ($arr->input('action') == 'add' || $arr->input('action') == 'edit') {
									$data = $arr->all();
									if ($data['bank_type']=="其它银行" || bank_chk($data)) {
											if (!empty($data['name'])) {
													$map2['user_id'] = session()->get('daili') ['Id'];
													$map2['bank_card'] = $data['bank_card'];
													$info = (array)DB::table('daili_cash_account')->where($map2)->first();
													if (!empty($info)) {
															$json['status'] = "error";
															$json['msg'] = "当前商户已存在该银行卡号";
													} else {
															unset($data['action']);
															if ($arr->input('action') == 'add') {
																	$data['user_id'] = session()->get('daili') ['Id'];
																	$status = DB::table('daili_cash_account')->insert($data);
																	if ($status) {
																			$json['status'] = "ok";
																			$json['msg'] = "添加收款账户成功";
																	} else {
																			$json['status'] = "error";
																			$json['msg'] = "服务器繁忙,银行卡号添加失败";
																	}
															} else {
																	$data2 = $data;
																	unset($data2['id']);
																	$status = DB::table('daili_cash_account')->where('Id', $data['id'])->update($data2);
																	if ($status) {
																			$json['status'] = "ok";
																			$json['msg'] = "编辑收款账户成功";
																	} else {
																			$json['status'] = "error";
																			$json['msg'] = "当前已存在该银行卡号";
																	}
															}
													}
											} else {
													$json['status'] = "error";
													$json['msg'] = "请输入开户姓名";
											}
									} else {
											$json['status'] = "error";
											$json['msg'] = "请输入正确的银行卡号";
									}
							} else if ($arr->input('action') == 'del') {
									if ($arr->has('id')) {
											DB::table('daili_drawing')->where('cash_account_id', $arr->input('id'))->delete();
											$status = DB::table('daili_cash_account')->where('Id', $arr->input('id'))->delete();
											if ($status) {
													$json['status'] = "ok";
													$json['msg'] = "删除成功";
											} else {
													$json['status'] = "error";
													$json['msg'] = "当前不存在此收款账户";
											}
									} else {
											$json['status'] = "error";
											$json['msg'] = "不安全的提交方式";
									}
							}
					} else {
							$json['status'] = "error";
					}
					return $json;
			}
			return view('daili/settlement_account');
	}
	/***用户信息***/
	public function userinfo(Request $arr) {
			if ($arr->isMethod('post')) {
					if ($arr->has('action')) {
							if ($arr->input('action') == 'getinfo') {
									$user =  DB::table('daili')->where('Id', session()->get('daili') ['Id'])->first();
									$user->order_service = ($user->order_service * 100) . "%";
									if ($user->type == 1){
											$user->type = "普通商户";
									}else if ($user->type == 2) {
											$user->type = "高级商户";
									}else{
											$user->type = "VIP商户";
									}
									$user->safety = $user->safety == 1 ? true : false;
									$ga = new Google;
									$url = $ga->getQRCodeGoogleUrl('YM_Pay',$user->safetycode);
									$user->safety_qrcode = "data:image/png;base64,".base64_encode(QrCode::format('png')->size(200)->margin(1)->generate($url));
									$json['status'] = "ok";
									$json['data'] = $user;
							}else if($arr->input('action') == 'open'){
									$status =  DB::table('daili')->where('id',session()->get('daili')['Id'])->update(array('safety'=>1));
									if($status){
											$json['status'] = "ok";
									}else{
											$json['status'] = "error";
											$json['msg'] = "当前已开启过了哦";
									}
							}else if($arr->input('action') == 'ajax'){
									$data = $arr->all();
									$ga = new Google;
									$checkResult = $ga->verifyCode( DB::table('daili')->where('id',session()->get('daili')['Id'])->first()->safetycode,trim($data['google_code']),2);
									if($checkResult){
											$status =  DB::table('daili')->where('id',session()->get('daili')['Id'])->update(array('safety'=>2));
											if($status){
													$json['status'] = "ok";
													$json['msg'] = "关闭成功";
											}else{
													$json['status'] = "error";
													$json['msg'] = "当前已关闭过了哦";
											}
									}else{
											$json['status'] ="error";
											$json['msg'] = "验证码错误";
									}
							} else {
									$json['status'] = "error";
									$json['msg'] = "请求不规范";
							}
					}
					return $json;
			}
			return view('daili/userinfo');
	}
}
