<?php
namespace App\Http\Controllers\Pay;

use Illuminate\Support\Facades\Redis;
use Vinkla\Hashids\Facades\Hashids;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Models\DiepollingpaymentModel;
use App\Http\Models\LivepollingpaymentModel;
use QrCode;

class PayController extends Controller {
	public function __construct(){
        
     }
	/****PC付款页面*****/
	public function index(Request $arr){
		$admin_site = DB::table('admin_site')->first();
		if($arr->isMethod('get')){
			if($arr->filled('key')){
				try {
					$orderinfo = json_decode(Redis::get(decrypt($arr->input('key'))), true);
					if(!$orderinfo){
						return array('state'=>0,'msg'=>'订单已过期或已支付成功');
					}
				} catch (\Exception $e) {
					return array('state'=>0,'msg'=>'订单有误');
				}
			}else{
				return array('state'=>0,'msg'=>'订单有误');
			}
		}
      	///////////////////////////////
		if($arr->isMethod('post')){
          if($arr->input('action')=='exorder' && $arr->filled('order_id')){
              $orderinfo = DB::table('order')->where('apiorder_id',$arr->input('order_id'))->first();
              if($orderinfo){
				return array('state'=>1,'msg'=>"获取成功",'data'=>$orderinfo);
              }else{
                return array('state'=>0,'msg'=>'订单有误');
              }
           }else if($arr->input('action')=='getorder' && $arr->filled('key')){
           	 try {
          		$orderinfo = json_decode(Redis::get(decrypt($arr->input('key'))), true);
				if(!$orderinfo){
					return array('state'=>0,'msg'=>'订单已过期或已支付成功');
				}else{
                	$orderinfo['inttime'] = $orderinfo['com_time']-time();
                     if(isset($orderinfo['qrcode_url'])){
                      if($orderinfo['qrcode_url'] != 2){
                        if($orderinfo['passageway_id'] ==901 || $orderinfo['passageway_id']== 903 || $orderinfo['passageway_id']== 804){
                        	$orderinfo['qrcode_url'] = "http://".config('route.domain.api')."/alido?key=".$arr->input('key');
                        }
                        if($orderinfo['type'] == 'aliwap'){
                            $orderinfo['h5_url'] = $orderinfo['qrcode_url'];
                        }
                        $orderinfo['qrcode_url'] = "data:image/png;base64,".base64_encode(QrCode::format('png')->size(200)->margin(0)->generate($orderinfo['qrcode_url']));
                      }
                     }else{
                       $orderinfo['qrcode_url'] = 2;
                     }
                  return array('state'=>1,'msg'=>"获取成功",'data'=>$orderinfo);
                }
           	 } catch (\Exception $e) {
				return array('state'=>0,'msg'=>'订单有误');
			 }
           }else if($arr->input('action')== 'qrcode' && $arr->filled('order_id')){
          		//查询二维码
                $orderinfo = DB::table('order')->where('apiorder_id',$arr->input('order_id'))->first();
            	if($orderinfo){
                    $orderinfo = (array)$orderinfo;
                	if($orderinfo['qrcode_url'] != 2){
                      $json['state'] = 1;
                       if($orderinfo['passageway_id'] ==804 || $orderinfo['passageway_id'] ==901 || $orderinfo['passageway_id']== 903){
                        	$orderinfo['qrcode_url'] = "http://".config('route.domain.api')."/alido?key=".encrypt(md5($orderinfo['apiorder_id']));
                        }
                       if($orderinfo['type'] == 'aliwap'){
                            $json['data']['h5_url'] = $orderinfo['qrcode_url'];
                        }
                      $json['data']['qrcode_url'] = "data:image/png;base64,".base64_encode(QrCode::format('png')->size(200)->margin(0)->generate($orderinfo['qrcode_url']));
                    }else{
                      $json['state'] = 0;
                    }
                }else{
                	$json['state'] = 0;
                }
            	return $json;
          	}
		}
       ///////////////////////////////
       if($admin_site->pay_template == 1){
       		if(ismobile()) return view('pay/wap');else return view('pay/pc');
       }else{
       		return view('pay/template_2',['info'=>$orderinfo]);
       }
        
	}

	/***支付宝跳转检测****/
	public function alido(Request $arr){
		if (strpos($_SERVER['HTTP_USER_AGENT'], 'AlipayClient') !== false) {
			if($arr->isMethod('get')){
				if($arr->filled('key')){
					try {
						$orderinfo = json_decode(Redis::get(decrypt($arr->input('key'))), true);
						if(!$orderinfo){
							return array('state'=>0,'msg'=>'订单已过期或已支付成功');
						}else{
	                      	if($orderinfo['type'] == 'alipay' || $orderinfo['type']=='aliwap'){
	                        	if($orderinfo['passageway_id'] == 804 || $orderinfo['passageway_id'] ==901 || $orderinfo['passageway_id']== 903){
	                                return view('pay/flightmode');
	                            }else{
	                                return view('pay/common_patterns');
	                            }
	                        }else{
	                        	return array('state'=>0,'msg'=>'支付方式有误');
	                        }
						} 
					} catch (\Exception $e) {
						return array('state'=>0,'msg'=>'订单有误');
					}
				}else{
					return array('state'=>0,'msg'=>'订单有误');
				}
			}
			if($arr->isMethod('post')){
				if($arr->input('action') == 'getorder' && $arr->filled('key')){
					try {
						$orderinfo = json_decode(Redis::get(decrypt($arr->input('key'))),true);
						if(!$orderinfo){
							return array('state'=>0,'msg'=>'订单已过期或已支付成功');
						}else{
							if($orderinfo['passageway_id'] ==901 || $orderinfo['passageway_id']== 903){
								$orderinfo['alipay_uid'] = geturlkey($orderinfo['qrcode_url'])['uid'];
	                    		$orderinfo['alipay_user'] = geturlkey($orderinfo['qrcode_url'])['aliuser'];
							}
							return array('state'=>1,'data'=>$orderinfo,'inttime'=>Redis::TTL(decrypt($arr->input('key'))),'msg'=>"获取成功");
						} 
					} catch (\Exception $e) {
						return array('state'=>0,'msg'=>'订单有误');
					}
				}
			}
		}else{
			return array('state'=>0,'msg'=>'请扫码或在支付页面启动支付宝APP内打开');
		}
	}

	/***微信跳转检测****/
	public function wxdo(Request $arr){
		if ( strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false ) {
			return 'ok';
		}else{
			return 'error';
		}
	}
	
	/****二维码生成****/
	public function qrcode(Request $arr){
        if($arr->isMethod('get')){
        	if($arr->filled('url') && $arr->filled('type')){
        			$res = $arr->all();
        		try {
        			$img = "/public/members/icon/{$res['type']}.png";
	        		$data = QrCode::format('png')->size(200)->margin(0)->merge($img,.15)->generate($res['url']);
			        $url = base64_encode($data);
			        $json['state'] = 1;
			        $json['data']  = "data:image/png;base64,".$url;
        		} catch (Exception $e) {
        			$json['state'] = 0;
        			$json['msg']  = $e->getMessage();
        		}
        	}else{
        		$json['state'] = 0;
        		$json['msg'] ="不安全的提交方式";
        	}
	       	return $json;
	    }
    }
    
    /****码商自测收银台页面****/
    public function cashier(Request $arr){
    	if($arr->isMethod('get')){
    		if($arr->filled('token')){
    			//查询是否存在
    			$info = DB::table('member')->where('apikey',$arr->input('token'))->first();
    			if(!$info){
    				echo 'error';die;
    			}else if($info->status != 1){
    				echo "当前账号已被冻结";die;
    			}else{
    				$data = $arr->all();
    				if(!empty($data['paytype']) && !empty($data['amount']) && !empty($data['code_type']) && !empty($data['merchant_uid']) && !empty($data['channel_id'])){
    					/***判断后台是否设置商户ID****/
						 $postdata['user_id']=DB::table('admin_site')->first()->pay_user_id;
						 if(!empty($postdata['user_id'])){
						 	 $userinfo = DB::table('user')->where('Id',$postdata['user_id'])->first();
					 		 if($userinfo){
					 		 	 $postdata['user_id'] = $userinfo->Id;
						         $postdata['order_id'] = date('dhis',time()).rand(1000000,9999999);
						         $postdata['amount'] = $data['amount'];
						         $postdata['return_url']="http://".config('route.domain.api').'/demo_notice';
								 $postdata['notice_url']="http://".config('route.domain.api').'/demo_notice';
								 $postdata['merchant_key']=$info->apikey;
						         $postdata['paytype'] =$data['paytype'];
						         $postdata['code_type'] = $data['code_type'];
						         $postdata['merchant_uid'] = $data['merchant_uid'];
						         $postdata['channel_id'] = $data['channel_id'];
						         $postdata['sign'] = getsign($postdata,$userinfo->token);
						         $str = '';
						         foreach ($postdata as $k => $v) {
							            $str.= '<input type="hidden" name="'.$k.'" value="'.$v.'">';
							     }
							     echo '<html><head><meta charset="utf-8" /><title>正在提交..</title></head><body onload="javascript:document.form1.submit();"><form id="form1" name="form1" method="post" action="'."http://".config('route.domain.api').'/pay">'.$str.'</form>';exit;
					 		 }else{
					 		 	return array('state'=>0,'msg'=>"平台未开启收款服务");
					 		 }
						 }
    				}
    			}
    		}else{
    			echo "error";die;
    		}
    	}

    	if($arr->isMethod('post')){
    		$data = $arr->all();
    		//查询码商信息
    		if($arr->filled('token') && preg_match("@[a-zA-Z0-9]{32}@",$arr->input('token'))){
    			$info = DB::table('member')->where('apikey',$data['token'])->first();
	    		if($info){
	    			if($arr->filled('username') && $arr->input('username')!= '当前类型无账号'){
	    				$map['username'] = $arr->input('username');
	    			}
	    			$map['member_id'] = $info->Id;
		    		$map['type'] = $data['code_type'];
		    		//查询指定类型的收款账号
		    		$pollinglist = DB::table('member_polling')->where($map)->select('Id','username')->get();
		    		if(!$pollinglist->isEmpty()){
		    			$pollinglist = $pollinglist->toarray();
		    			//如果有的话默认查询首个账号下的通道
		    			if($data['code_type'] == 1){
		    				$payment = DiepollingpaymentModel::where('polling_id',$pollinglist[0]->Id)->select('passageway_id')->with('payment')->get();
		    			}else{
		    				$payment = LivepollingpaymentModel::where('polling_id',$pollinglist[0]->Id)->select('passageway_id')->with('payment')->get();
		    			}
	
		    			if(!$payment->isEmpty()){
		    				$payment = $payment->toarray();
		    				foreach ($payment as $v) {
		    					$v = (array)$v;
		    					$json['data']['list']['channel_id'][] = array('Id'=>$v['payment']['Id'],'name'=>$v['payment']['name']);
		    				}
		    				$json['data']['list']['merchant_uid'] = $pollinglist;
		    				$json['data']['channel_id'] = $json['data']['list']['channel_id'][0];
		    				$json['data']['merchant_uid'] = $pollinglist[0];
		    				$json['code'] = 100;
		    				return $json;
						}else{
							return array('code'=>102,'msg'=>"当前账号未添加通道");
						}
		    		}else{
		    			return array('status'=>101,'msg'=>"当前类型无账号");
		    		}
	    		}else{
	    			$json['code'] = 101;
	    			$json['msg']  = "token错误";
	    		}
    		}else{
    			$json['code'] = 101;
	    		$json['msg']  = "token有误";
    		}
    	}

    	return view('pay/cashier');
    }
}