<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class OrderModel extends Model
{ 
	protected $table = 'order';
    public $timestamps = false;

    /***关联商户账号****/
    public function user()
    {
        return $this->hasone('App\Http\Models\UserModel','Id','user_id');
    }

    /***关联码商账号****/
    public function merchant()
    {
        return $this->hasone('App\Http\Models\MemberModel','Id','member_id');
    }

    /***关联码商活码收款账号下收款通道****/
    public function livepollingpayment()
    {
        return $this->hasone('App\Http\Models\LivepollingpaymentModel','key','polling_passageway_key');
    }

    /***关联码商收款账号****/
    public function polling()
    {
        return $this->hasone('App\Http\Models\PollingModel','username','polling_user');
    }

    /***关联码商固码收款账号下收款通道****/
    public function diepollingpayment()
    {
        return $this->hasone('App\Http\Models\DiepollingpaymentModel','key','polling_passageway_key');
    }

    /***关联活码通道****/
    public function livepassageway()
    {
        return $this->hasone('App\Http\Models\LivepassagewayModel','Id','passageway_id');
    }

    /***关联固码通道****/
    public function diepassageway()
    {
        return $this->hasone('App\Http\Models\DiepassagewayModel','Id','passageway_id');
    }

}
