<?php

namespace App\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        //

        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
            if (!isset($_SERVER['HTTP_HOST'])){
                $currentDomain = 'www';
            }else{
                $currentDomain = $_SERVER['HTTP_HOST'];
            }
         switch ($currentDomain) {
             case config('route.domain.member'):
                            Route::domain(config('route.domain.member'))->middleware('web')
                             ->namespace($this->namespace)
                             ->group(base_path('routes/member.php'));
                 break;
             case config('route.domain.merchant'):
                            Route::domain(config('route.domain.merchant'))->middleware('web')
                             ->namespace($this->namespace)
                             ->group(base_path('routes/merchant.php'));
                 break;
            case config('route.domain.api'):
                            Route::domain(config('route.domain.api'))->middleware('api')
                             ->namespace($this->namespace)
                             ->group(base_path('routes/api.php'));
                 break;
            case config('route.domain.admin'):
                            Route::domain(config('route.domain.admin'))->middleware('web')
                             ->namespace($this->namespace)
                             ->group(base_path('routes/admin.php'));
                 break;
                 //webtext
             case config('route.domain.daili'):
                             Route::domain(config('route.domain.daili'))->middleware('web')
                              ->namespace($this->namespace)
                              ->group(base_path('routes/daili.php'));
                  break;
             default:      Route::domain(config('route.domain.www'))->middleware('web')
                             ->namespace($this->namespace)
                             ->group(base_path('routes/www.php'));
                 break;
         }

         /*
        $this->mapApiRoutes();

        $this->mapWebRoutes();

        $this->mapSocketRoutes();*/

        //
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')
             ->namespace($this->namespace)
             ->group(base_path('routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::prefix('api')
             ->middleware('api')
             ->namespace($this->namespace)
             ->group(base_path('routes/api.php'));
    }

    protected function mapSocketRoutes()
    {
        Route::prefix('socket')
             ->middleware('socket')
             ->namespace($this->namespace)
             ->group(base_path('routes/socket.php'));
    }
}
