from app.Model.Model import FlArticleType
from sqlalchemy_serializer import SerializerMixin
from app.Vendor.Decorator import classTransaction
from app import dBSession

class ArticleType(FlArticleType, SerializerMixin):

    """ 
        列表
        @param set filters 查询条件
        @param obj order 排序
        @param tuple field 字段
        @param int offset 偏移量
        @param int limit 取多少条
        @return dict
    """
    def getList(self, filters, order, field=(), offset = 0, limit = 15):
        res = {}
        res['count'] = dBSession.query(ArticleType).filter(*filters).count()
        res['list'] = []
        if res['count'] > 0:
            res['list'] = dBSession.query(ArticleType).filter(*filters)
            res['list'] = res['list'].order_by(order).offset(offset).limit(limit).all()
        if not field:
            res['list'] = [c.to_dict() for c in res['list']]
        else:
            res['list'] = [c.to_dict(only=field) for c in res['list']]
        return res

    """
        查询全部
        @param set filters 查询条件
        @param obj order 排序
        @param tuple field 字段
        @param int $limit 取多少条
        @return dict
    """
    def getAll(self, filters, order, field = (), limit = 0):
        if not filters:
            res = dBSession.query(ArticleType)
        else:   
            res = dBSession.query(ArticleType).filter(*filters)
        if limit != 0:
            res = res.order_by(order).limit(limit).all()
        else:
            res = res.order_by(order).all()
        if not field:
            res = [c.to_dict() for c in res] 
        else:
            res = [c.to_dict(only=field) for c in res]
        return res

    
    """
        获取一条
        @param set filters 查询条件
        @param obj order 排序
        @param tuple field 字段
        @return dict
    """
    def getOne(self, filters, order, field = ()):
        res = dBSession.query(ArticleType).filter(*filters)
        res = res.order_by(order).first()
        if res == None:
            return None
        if not field:
            res = res.to_dict()
        else:
           res = res.to_dict(only=field) 
        return res
  
    """
        添加
        @param obj data 数据
        @return bool
    """
    @classTransaction
    def add(self, data):
        dBSession.add(ArticleType(**data))
        return True

    
    """
        修改
        @param dict data 数据
        @param set filters 条件
        @return bool
    """
    @classTransaction
    def edit(self, data, filters):
        dBSession.query(ArticleType).filter(*filters).update(data, synchronize_session=False)
        return True
    
    """
        删除
        @paramset filters 条件
        @return bool
    """
    @classTransaction
    def delete(self, filters):
        dBSession.query(ArticleType).filter(*filters).delete()
        return True
    
    """
        统计数量
        @param set filters 条件
        @param obj field 字段
        @return int
    """  
    def getCount(self, filters, field = None):
        if field == None:
            return dBSession.query(ArticleType).filter(*filters).count()
        else:
            return dBSession.query(ArticleType).filter(*filters).count(field)


    """
        将列表生成树形结构
        @param int parent_id 父级ID
        @param int deep 层级
        @return list
    """
    def list_to_tree(self, parent_id=0, deep=0):
        arr= []
        cats = self.getAll({FlArticleType.parent_id== parent_id}, FlArticleType.listorder.asc())
        if cats:
            for row in cats:
                row['deep'] = deep
                child = self.list_to_tree(row["id"], deep+1)
                if child:
                    row['child'] = child
                arr.append(row)
        return arr
	

    """
       树形结构转成列表
        @param list listData 数据
        @param int parent_id 父级ID
        @param list temp 空模板
        @return list
    """
    def tree_to_list(self, listData, parent_id=0, temp=[]):
        if listData:	
            for v in listData:
                data = {
                    "id":v['id'],
                    "deep":v['deep'],
                    "name":v['name'],
                    "filename":v['filename'],
                    "parent_id":v['parent_id'],
                    "add_time":v['add_time']
                }
                temp.append(data)
                if 'child' in v.keys():
                    self.tree_to_list( v['child'], v['parent_id'], temp)
        return temp