# coding: utf-8
from sqlalchemy import CHAR, Column, String, TIMESTAMP, text
from sqlalchemy.dialects.mysql import INTEGER, MEDIUMTEXT, SMALLINT, TINYINT
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()
metadata = Base.metadata


class FlAccess(Base):
    __tablename__ = 'fl_access'

    id = Column(INTEGER(11), primary_key=True)
    role_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='角色ID')
    menu_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='菜单ID')


class FlAdmin(Base):
    __tablename__ = 'fl_admin'

    id = Column(INTEGER(11), primary_key=True)
    role_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='角色ID')
    name = Column(String(30), nullable=False, server_default=text("''"), comment='admin888')
    pwd = Column(CHAR(32), nullable=False, server_default=text("''"), comment='admin')
    mobile = Column(String(20), nullable=False, server_default=text("''"), comment='手机号')
    email = Column(String(30), nullable=False, server_default=text("''"), comment='邮箱')
    avatar = Column(String(150), nullable=False, server_default=text("''"), comment='头像')
    status = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='用户状态 0：正常； 1：禁用 ；2：未验证')
    login_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='登录时间')
    add_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='添加时间')
    update_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='更新时间')
    delete_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='删除时间')


class FlAdminLog(Base):
    __tablename__ = 'fl_admin_log'

    id = Column(INTEGER(10), primary_key=True)
    content = Column(String(250), nullable=False, server_default=text("''"), comment='操作内容')
    ip = Column(String(15), nullable=False, server_default=text("'0'"), comment='IP')
    route = Column(String(60), nullable=False, server_default=text("''"), comment='路由')
    http_method = Column(String(10), nullable=False, server_default=text("''"), comment='请求方式')
    admin_name = Column(String(60), nullable=False, server_default=text("''"), comment='管理员名称')
    admin_id = Column(INTEGER(10), nullable=False, server_default=text("'0'"), comment='管理员ID')
    add_time = Column(INTEGER(10), nullable=False, server_default=text("'0'"), comment='添加时间')


class FlAdminRole(Base):
    __tablename__ = 'fl_admin_role'

    id = Column(INTEGER(11), primary_key=True)
    parent_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='父角色ID')
    name = Column(String(30), nullable=False, unique=True, server_default=text("''"), comment='角色名')
    desc = Column(String(150), nullable=False, server_default=text("''"), comment='描述')
    listorder = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='排序')
    status = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='状态，0正常，1禁用')


class FlArticle(Base):
    __tablename__ = 'fl_article'

    id = Column(INTEGER(11), primary_key=True)
    type_id = Column(INTEGER(11), nullable=False, comment='栏目ID')
    tuijian = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='推荐等级')
    click = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='点击量')
    title = Column(String(150), nullable=False, server_default=text("''"), comment='标题')
    content = Column(MEDIUMTEXT, comment='内容')
    writer = Column(String(20), nullable=False, server_default=text("''"), comment='作者')
    source = Column(String(30), nullable=False, server_default=text("''"), comment='来源')
    litpic = Column(String(150), nullable=False, server_default=text("''"), comment='缩略图')
    keywords = Column(String(60), nullable=False, server_default=text("''"), comment='关键词')
    seotitle = Column(String(150), nullable=False, server_default=text("''"), comment='SEO标题')
    description = Column(String(250), nullable=False, server_default=text("''"), comment='描述')
    status = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='0正常，1未审核')
    type_id2 = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='副栏目ID')
    user_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='是谁发布的')
    add_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='添加时间')
    update_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='更新时间')
    delete_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='是否删除，0未删除')


class FlArticleType(Base):
    __tablename__ = 'fl_article_type'

    id = Column(INTEGER(11), primary_key=True)
    parent_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='父级栏目ID')
    name = Column(String(30), nullable=False, server_default=text("''"), comment='栏目名称')
    seotitle = Column(String(150), nullable=False, server_default=text("''"), comment='SEO标题')
    keywords = Column(String(60), nullable=False, server_default=text("''"), comment='关键词')
    description = Column(String(250), nullable=False, server_default=text("''"), comment='描述')
    content = Column(MEDIUMTEXT, comment='内容')
    filename = Column(String(30), nullable=False, unique=True, server_default=text("''"), comment='别名')
    templist = Column(String(50), nullable=False, server_default=text("''"), comment='列表页模板')
    temparticle = Column(String(50), nullable=False, server_default=text("''"), comment='文章页模板')
    litpic = Column(String(150), nullable=False, server_default=text("''"), comment='封面或缩略图')
    is_part = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='栏目属性：0列表栏目（允许发布文档），1频道封面（不允许发布文档）')
    listorder = Column(INTEGER(11), nullable=False, server_default=text("'50'"), comment='排序')
    update_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='更新时间')
    add_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='添加时间')
    delete_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='是否删除，0未删除')


class FlFeedback(Base):
    __tablename__ = 'fl_feedback'

    id = Column(INTEGER(11), primary_key=True)
    type = Column(String(20), nullable=False, server_default=text("''"), comment='意见反馈类型，选填')
    title = Column(String(150), nullable=False, server_default=text("''"), comment='标题，选填')
    content = Column(MEDIUMTEXT, comment='意见反馈内容')
    mobile = Column(String(20), nullable=False, server_default=text("''"), comment='手机号码，选填')
    user_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='用户id')
    add_time = Column(TIMESTAMP, nullable=False, server_default=text("CURRENT_TIMESTAMP"), comment='添加时间')


class FlFriendlink(Base):
    __tablename__ = 'fl_friendlink'

    id = Column(INTEGER(11), primary_key=True)
    name = Column(String(60), nullable=False, server_default=text("''"), comment='名称')
    url = Column(String(150), nullable=False, server_default=text("''"), comment='url链接')
    target = Column(SMALLINT(2), nullable=False, server_default=text("'0'"), comment='跳转方式，0_blank，1_self，2_parent，3_top，4framename')
    group_id = Column(INTEGER(5), nullable=False, server_default=text("'0'"), comment='分组ID')
    listorder = Column(INTEGER(11), nullable=False, server_default=text("'50'"), comment='排序')


class FlGuestbook(Base):
    __tablename__ = 'fl_guestbook'

    id = Column(INTEGER(11), primary_key=True)
    title = Column(String(150), nullable=False, server_default=text("''"), comment='标题')
    msg = Column(String(250), nullable=False, server_default=text("''"), comment='描述')
    add_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='添加时间')
    delete_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='删除时间')


class FlKeyword(Base):
    __tablename__ = 'fl_keyword'

    id = Column(INTEGER(11), primary_key=True)
    name = Column(String(30), nullable=False, server_default=text("''"), comment='内链关键词')
    url = Column(String(150), nullable=False, server_default=text("''"), comment='链接网址')


class FlMenu(Base):
    __tablename__ = 'fl_menu'

    id = Column(INTEGER(11), primary_key=True)
    parent_id = Column(INTEGER(11), nullable=False, index=True, server_default=text("'0'"), comment='父级ID')
    module = Column(String(50), nullable=False, server_default=text("''"), comment='模型')
    controller = Column(String(50), nullable=False, server_default=text("''"), comment='控制器')
    action = Column(String(50), nullable=False, server_default=text("''"), comment='方法')
    data = Column(String(50), nullable=False, server_default=text("''"), comment='额外参数')
    type = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='菜单类型  1：权限认证+菜单；0：只作为菜单')
    name = Column(String(50), nullable=False, server_default=text("''"), comment='菜单名称')
    icon = Column(String(50), nullable=False, server_default=text("''"), comment='菜单图标')
    desc = Column(String(250), nullable=False, server_default=text("''"), comment='备注')
    listorder = Column(INTEGER(11), nullable=False, server_default=text("'50'"), comment='排序ID')
    status = Column(TINYINT(1), nullable=False, index=True, server_default=text("'0'"), comment='状态，0正常，1隐藏')


class FlPage(Base):
    __tablename__ = 'fl_page'

    id = Column(INTEGER(11), primary_key=True)
    title = Column(String(150), nullable=False, server_default=text("''"), comment='标题')
    seotitle = Column(String(150), nullable=False, server_default=text("''"), comment='SEO标题')
    keywords = Column(String(100), nullable=False, server_default=text("''"), comment='关键词')
    description = Column(String(250), nullable=False, server_default=text("''"), comment='描述')
    content = Column(MEDIUMTEXT, comment='内容')
    template = Column(String(30), nullable=False, server_default=text("''"), comment='模板名称')
    filename = Column(String(60), nullable=False, server_default=text("''"), comment='别名')
    litpic = Column(String(150), nullable=False, server_default=text("''"), comment='缩略图')
    click = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='点击量')
    group_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='分组ID')
    add_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='添加时间')
    update_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='更新时间')
    delete_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='删除时间')


class FlSearchword(Base):
    __tablename__ = 'fl_searchword'

    id = Column(INTEGER(11), primary_key=True)
    name = Column(String(36), nullable=False, server_default=text("''"), comment='名称')
    title = Column(String(60), nullable=False, server_default=text("''"), comment='SEO标题')
    keywords = Column(String(100), nullable=False, server_default=text("''"), comment='关键词')
    description = Column(String(250), nullable=False, server_default=text("''"), comment='描述')
    content = Column(MEDIUMTEXT, comment='内容')
    click = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='点击量')
    litpic = Column(String(150), nullable=False, server_default=text("''"), comment='缩略图或封面')
    template = Column(String(30), nullable=False, server_default=text("''"), comment='模板名称')
    filename = Column(String(60), nullable=False, server_default=text("''"), comment='别名')
    status = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='状态，0正常，1禁用')
    update_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='添加时间')


class FlSlide(Base):
    __tablename__ = 'fl_slide'

    id = Column(INTEGER(11), primary_key=True)
    title = Column(String(150), nullable=False, server_default=text("''"), comment='标题')
    url = Column(String(150), nullable=False, server_default=text("''"), comment='跳转的url')
    target = Column(SMALLINT(2), nullable=False, server_default=text("'0'"), comment='跳转方式，0_blank，1_self，2_parent，3_top，4framename')
    group_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='分组ID')
    pic = Column(String(150), nullable=False, server_default=text("''"), comment='图片地址')
    listorder = Column(INTEGER(4), nullable=False, server_default=text("'0'"), comment='排序')
    status = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='0正常，1禁用')


class FlSysconfig(Base):
    __tablename__ = 'fl_sysconfig'

    id = Column(INTEGER(11), primary_key=True)
    varname = Column(String(100), nullable=False, server_default=text("''"), comment='变量名')
    info = Column(String(100), nullable=False, server_default=text("''"), comment='变量值')
    value = Column(MEDIUMTEXT, nullable=False, comment='变量说明')


class FlTag(Base):
    __tablename__ = 'fl_tag'

    id = Column(INTEGER(11), primary_key=True)
    name = Column(String(36), nullable=False, server_default=text("''"), comment='名称')
    title = Column(String(100), nullable=False, server_default=text("''"), comment='标题')
    keywords = Column(String(100), nullable=False, server_default=text("''"), comment='关键词')
    description = Column(String(150), nullable=False, server_default=text("''"), comment='描述')
    content = Column(MEDIUMTEXT, comment='内容')
    click = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='点击量')
    litpic = Column(String(150), nullable=False, server_default=text("''"), comment='缩略图或封面')
    template = Column(String(30), nullable=False, server_default=text("''"), comment='模板名称')
    filename = Column(String(60), nullable=False, server_default=text("''"), comment='别名')
    status = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='0正常，1禁用')
    add_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='添加时间')
    update_time = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='更新时间')


class FlTaglist(Base):
    __tablename__ = 'fl_taglist'

    id = Column(INTEGER(11), primary_key=True)
    tag_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='TAG ID')
    article_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"), comment='文章ID')
