'''
@Author: hua
@Date: 2019-04-16 17:06:35
@LastEditors: hua
@LastEditTime: 2019-05-14 14:51:38
'''
from app.Model.Model import FlTaglist
from app.Model.Article import Article
from sqlalchemy_serializer import SerializerMixin
from app.Vendor.Decorator import classTransaction
from sqlalchemy.orm import  relationship, foreign, remote
from app import dBSession

class Taglist(FlTaglist, SerializerMixin):
    
    article = relationship('Article', uselist=False, primaryjoin=foreign(FlTaglist.article_id) == remote(Article.id))
    
    """ 
        列表
        @param set filters 查询条件
        @param obj order 排序
        @param tuple field 字段
        @param int offset 偏移量
        @param int limit 取多少条
        @return dict
    """
    def getList(self, filters, order, field=(), offset = 0, limit = 15):
        res = {}
        res['count'] = dBSession.query(Taglist).filter(*filters).count()
        res['list'] = []
        if res['count'] > 0:
            res['list'] = dBSession.query(Taglist).filter(*filters)
            res['list'] = res['list'].order_by(order).offset(offset).limit(limit).all()
        if not field:
            res['list'] = [c.to_dict() for c in res['list']]
        else:
            res['list'] = [c.to_dict(only=field) for c in res['list']]
        return res

    """
        查询全部
        @param set filters 查询条件
        @param obj order 排序
        @param tuple field 字段
        @param int $limit 取多少条
        @return dict
    """
    def getAll(self, filters, order, field = (), limit = 0):
        if not filters:
            res = dBSession.query(Taglist)
        else:   
            res = dBSession.query(Taglist).filter(*filters)
        if limit != 0:
            res = res.order_by(order).limit(limit).all()
        else:
            res = res.order_by(order).all()
        if not field:
            res = [c.to_dict() for c in res]
        else:
            res = [c.to_dict(only=field) for c in res]
        return res

    
    """
        获取一条
        @param set filters 查询条件
        @param obj order 排序
        @param tuple field 字段
        @return dict
    """
    def getOne(self, filters, order, field = ()):
        res = dBSession.query(Taglist).filter(*filters)
        res = res.order_by(order).first()
        if not field:
            res = res.to_dict()
        else:
           res = res.to_dict(only=field) 
        return res
  
    """
        添加
        @param obj data 数据
        @return bool
    """
    @classTransaction
    def add(self, data):
        dBSession.add(Taglist(**data))
        return True

    
    """
        修改
        @param dict data 数据
        @param set filters 条件
        @return bool
    """
    @classTransaction
    def edit(self, data, filters):
        dBSession.query(Taglist).filter(*filters).update(data)
        return True
    
    """
        删除
        @paramset filters 条件
        @return bool
    """
    @classTransaction
    def delete(self, filters):
        dBSession.query(Taglist).filter(*filters).delete()
        return True
    
    """
        统计数量
        @param set filters 条件
        @param obj field 字段
        @return int
    """  
    def getCount(self, filters, field = None):
        if field == None:
            return dBSession.query(Taglist).filter(*filters).count()
        else:
            return dBSession.query(Taglist).filter(*filters).count(field)