from app.Model.ArticleType import ArticleType
import re

class ArticleService():
    """
        递归获取面包屑导航
        @param  int type_id
        @param string temp 空模板
        @return string
    """
    def get_article_type_path(self, type_id, temp=''):
        filters = {
            ArticleType.id == type_id
        }
        row = ArticleType().getOne(filters, ArticleType.add_time.desc(), ('name','parent_id','id',))     
        temp = '<a href="/articlelist/f'+str(row["id"])+'">'+row["name"]+"</a> > "+temp
        if row['parent_id'] > 0:
            self.get_article_type_path(row['parent_id'], temp)
        return temp


    """
        字符串转成数组
        @param  string key
        @return dict
    """
    def getArrByString(self, key):
        res = {}
        if not key:
            return res
        letter = re.finditer(r'[a-z]+', key)
        number = re.finditer(r'[0-9]+', key)
        for i in letter :
            key = i.group()
        for v in number :
            value = v.group()
        res[key] = value
        return res

