'''
@Author: hua
@Date: 2019-05-05 20:03:47
@LastEditors: hua
@LastEditTime: 2019-05-15 08:44:09
'''
from aiohttp import web
from app.Model.Friendlink import Friendlink
from app.Vendor.Decorator import validator
from app.Vendor.tempDef import sysconfig, backStatus, randomInt
from  sqlalchemy.sql.expression import func
from app.Vendor.Code import Code
import aiohttp_jinja2
import time, jieba, json,re

#列表
@aiohttp_jinja2.template('fladmin/friendlink/index.html')
async def index(request, **k):
    params = request.query
    data = dict()
    if 'keyword' in params.keys():
       filters = {Friendlink.name.like('%'+params['keyword']+'%')}
       res = Friendlink().getList(filters, Friendlink.id.desc(), ())
    else:
       res = Friendlink().getList({}, Friendlink.id.desc(), ())
    data['page'] = res['page']
    data['list'] = res['list']
    return data 
	
#添加
@aiohttp_jinja2.template('fladmin/friendlink/add.html')
async def addByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    res = Friendlink().add(params)   
    if res==True:
        return backStatus(request, '添加成功')
    return backStatus(request, '添加失败', 0)
     
         
#添加
@aiohttp_jinja2.template('fladmin/friendlink/add.html')
async def addByGet(request, **k):
    return {}
    
#修改
@aiohttp_jinja2.template('fladmin/friendlink/edit.html')
async def editByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    filters = {
        Friendlink.id == params['id']
    }
    res = Friendlink().edit(params, filters)
    if res == True:
        return backStatus(request, '编辑成功')
    return backStatus(request, '编辑失败', 0)
    
    

@aiohttp_jinja2.template('fladmin/friendlink/edit.html')
async def editByGet(request, **k):
    params = request.query
    data = dict()
    filters = {
        Friendlink.id == params['id']
    }
    data['id'] = params['id']
   
    data['post'] = Friendlink().getOne(filters, Friendlink.id.desc())
    return data

	
#删除
async def delete(request, **k):
    params = request.query
    filters = {
        Friendlink.id == params['id']
    }
    res = Friendlink().delete(filters)
    if res==True:
        return backStatus(request, '删除成功') 
    return backStatus(request, '删除失败', 0)