from aiohttp import web
from app import dBSession
from app.Model.Sysconfig import Sysconfig
from app.Vendor.Decorator import validator
from app.Vendor.tempDef import sysconfig, backStatus, randomInt
from  sqlalchemy.sql.expression import func
from app.Vendor.Code import Code
import aiohttp_jinja2
import time, json


#列表
@aiohttp_jinja2.template('fladmin/sysconfig/index.html')
async def index(request, **k):
    params = request.query
    data = dict()
    if 'keyword' in params.keys():
       filters = {Sysconfig.info.like('%'+params['keyword']+'%')}
       res = Sysconfig().getList(filters, Sysconfig.id.desc(), ())
    else:
       res = Sysconfig().getList({}, Sysconfig.id.desc(), ())
    data['page'] = res['page']
    data['list'] = res['list']
    return data 

#添加
@aiohttp_jinja2.template('fladmin/sysconfig/add.html')
async def addByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    res = Sysconfig().add(params)   
    if res:
        return backStatus(request, '添加成功')
    return backStatus(request, '添加失败', 0)
          
#添加
@aiohttp_jinja2.template('fladmin/sysconfig/add.html')
async def addByGet(request, **k):
    return {}
    
#修改
@aiohttp_jinja2.template('fladmin/sysconfig/edit.html')
async def editByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    filters = {
        Sysconfig.id == params['id']
    }  
    res = Sysconfig().edit(params, filters)
    if res==True:
        return backStatus(request, '编辑成功')
    return backStatus(request, '编辑失败', 0)
        
#修改
@aiohttp_jinja2.template('fladmin/sysconfig/edit.html')
async def editByGet(request, **k):
    params = request.query
    data = dict()
    filters = {
        Sysconfig.id == params['id']
    }
    data['id'] = params['id'] 
    data['post'] =  Sysconfig().getOne(filters, Sysconfig.id.desc())
    return data

#删除
async def delete(request, **k):
    params = request.query
    filters = {
        Sysconfig.id == params['id']
    }
    res = Sysconfig().delete(filters)
    if res==True:
        return backStatus(request, '删除成功') 
    return backStatus(request, '删除失败', 0)
